**Workflow Runner**
- Script: `scripts/run_workflow.py`
- Output: A timestamped run folder with per‑step prompt files to paste into your AIs.

**Prerequisites**
- Python 3.9+
- PyYAML: `pip install pyyaml`

**Examples**
- Interaktiver Wizard (CMD/PowerShell):
  - CMD: `run_wizard.cmd`
  - PowerShell: `./run_wizard.ps1` oder `python scripts/run_workflow.py --interactive`
  - KI-Auswahl: Für jede Rolle (Lead/Reviewer/Prompt/Image) bekommst du 1–X Optionen aus `models/model_suggestions.yaml` angezeigt. Eingabe leer = bevorzugtes Modell (preferred), sonst Index eingeben oder eigener Providernamen tippen.

- Texterstellung workflow with tailored model suggestions:
  - `python scripts/run_workflow.py --workflow workflows/texterstellung.yaml --models models/model_suggestions.yaml`

- Provide inputs from a JSON file (keys must match `inputs` in the workflow):
  - `python scripts/run_workflow.py --workflow workflows/web_programming.yaml --models models/model_suggestions.yaml --inputs inputs.json`

- Override model selection:
  - `python scripts/run_workflow.py --workflow workflows/bildgenerierung.yaml --models models/model_suggestions.yaml --prompt-ai "Claude (Anthropic)" --reviewer-ai "ChatGPT (OpenAI)" --image-generator "GPT-4o (OpenAI)"`

**What It Produces**
- `runs/YYYYMMDD-HHMMSS-<workflow>`
  - `README.txt`: how to execute the prompts and selected models
  - `meta.json`: workflow name, selected models, inputs
  - `NN_<step-id>_<actor>.txt`: prompt for each step (lead/reviewer/prompt engineer)

**Notes**
- This runner does not call provider APIs. It generates high‑quality prompt packs so you can use any UI (OpenAI, Anthropic, Google, etc.).
- Model choices are guided by `models/model_suggestions.yaml`, curated from your KI‑Matrix.

**Flowchart (Mermaid)**
- Diagram file: `docs/runner_flow.mmd`
- Preview by copying the contents into any Mermaid‑enabled viewer.
