**KI‑Matrix Workflows Overview**
- Location: `workflows/`
- Scope: Six focused workflows with a built‑in two‑AI review loop.
- Source reference: Use `ki_modelle_matrix.csv` or `.xlsx` to pick suitable models per task.

**How To Use**
- Pick a workflow YAML in `workflows/` based on the task.
- Provide values for the `inputs` fields (brief, constraints, assets, etc.).
- Assign two AIs:
  - `lead_ai`: produces the first version and runs self‑checks.
  - `reviewer_ai`: audits outputs against the rubric and requests fixes.
- Iterate until the reviewer signs off; then export the final artifacts.

**Model Selection Guidance**
- Choose models based on strengths listed in `ki_modelle_matrix.csv`:
  - Programming: models with strong code generation and large context.
  - Text creation: models with strong long‑form writing and factual grounding.
  - Image prompts: models with strong instruction‑following and visual reasoning.
  - Image generation: providers supporting your target style/aspect ratio and usage rights.

**Files**
- `workflows/web_programming.yaml`
- `workflows/html_css.yaml`
- `workflows/typo3.yaml`
- `workflows/wordpress.yaml`
- `workflows/texterstellung.yaml`
- `workflows/bildgenerierung.yaml`

Each YAML defines: purpose, inputs, steps (lead + reviewer), internal checks, acceptance criteria, outputs.

**Tailored Models + Runner**
- Tailored suggestions per workflow: `models/model_suggestions.yaml` (derived from your KI‑Matrix).
- Runner to generate step‑by‑step prompt packs: `scripts/run_workflow.py`.
  - Interaktiver Wizard (CMD/PowerShell): `run_wizard.cmd` / `./run_wizard.ps1`
  - Mehr Details in `RUNNER.md`.
