Wallet v2 (Generic Pass)

Kurzüberblick
- Zweck: Erstellen und Vorschau eines Google Wallet Generic Pass (Objekt + Klasse), inkl. Save-Link (JWT) ohne externe Abhängigkeiten.
- Konfiguration: `v2/config.json` für Issuer, Class, Bilder, Farben und Pfad zur Service-Account-Datei.
- Endpunkte: Vorschau/Erstellung von Objekt/Save-Link, optionale Class-Preview.

Voraussetzungen
- Node.js 16+.
- Google Wallet Issuer ist eingerichtet. Du hast eine Service-Account JSON-Datei (z. B. `../key.json`) mit Wallet-Rechten.
- Die Class-ID `${ISSUER_ID}.${CLASS_ID}` existiert bereits oder wird separat in der Google Wallet API angelegt.

Schnellstart (Standalone)
1) In `v2/` wechseln und `config.json` anpassen (Issuer, Class, Bilder, Farben, `serviceAccountKeyPath`).
2) Lege deine Service-Account-Datei als `v2/key.json` ab (oder passe `serviceAccountKeyPath` an).
3) Starten: `npm start` (oder `node server.js`) im Ordner `v2/`.
4) Objekt-Preview: `POST http://localhost:3100/object/preview`
5) Save-Link generieren: `POST http://localhost:3100/wallet/save`

Wichtige Endpunkte (Port 3100)
- GET `/health`: Healthcheck.
- GET `/config`: Rückgabe der aktiven Konfiguration.
- POST `/class/preview`: Gibt die Klassen-JSON gemäß Template zurück.
  - Optionaler Body: `{ "issuerId": "...", "classId": "...", "classRows": [ ... ] }` um IDs/Rows ad-hoc zu überschreiben.
- POST `/object/preview`: Gibt die Objekt-JSON gemäß Template zurück (mit deinen Eingaben).
- POST `/wallet/save`: Signiert das Objekt in einem JWT und liefert `saveUrl` + `objectPreview`.

Class-Template (Konfigurierbar über `config.json > classRows`)
Beispiel (Telefon/E‑Mail/Mobil/PLZ/Ort):
{
  "id": "ISSUER_ID.CLASS_ID",
  "classTemplateInfo": {
    "cardTemplateOverride": {
      "cardRowTemplateInfos": [
        { "twoItems": { "startItem": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['telefon']"}]}}, "endItem": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['e-mail']"}]}} } },
        { "oneItem":  { "item": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['mobil']"}]}} } },
        { "twoItems": { "startItem": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['plz']"}]}},     "endItem": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['ort']"}]}} } }
      ]
    }
  }
}

Request-Beispiel (Object/Save)
POST /wallet/save
{
  "objectId": "OBJECT_ID_OPTIONAL",           // falls leer, wird generiert
  "cardTitle": "Dies ist ein Name",
  "subheader": "Attendee",
  "header": "Alex McJacobs",
  "textModulesData": [                      // IDs/Headers frei änderbar; Defaults passen zum Class-Template
    { "id": "telefon", "header": "Telefon", "body": "0251 49095982" },
    { "id": "e-mail",  "header": "E-Mail",  "body": "mb@wow.gmbh" },
    { "id": "mobil",   "header": "Mobil",   "body": "0175 111111111" },
    { "id": "plz",     "header": "PLZ",     "body": "48145" },
    { "id": "ort",     "header": "Ort",     "body": "Münster" }
  ],
  "barcodeValue": "BARCODE_VALUE"
}

Ad-hoc Class‑Preview mit Body
- POST `/class/preview`
```
{
  "issuerId": "3388000000022991353",
  "classId": "employee_card",
  "classRows": [
    { "twoItems": { "startItem": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['telefon']"}]}}, "endItem": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['e-mail']"}]}} } },
    { "oneItem":  { "item": {"firstValue": {"fields": [{"fieldPath": "object.textModulesData['mobil']"}]}} } }
  ]
}
```
Wenn `issuerId`/`classId`/`classRows` fehlen, werden die Werte aus `config.json` verwendet.

Hinweise
- Die erzeugte `heroImage`- und `logo`-Struktur enthält `contentDescription`, wie im Beispiel gewünscht.
- `hexBackgroundColor` aus `config.json` wird standardmäßig verwendet.
- Class-Anlage via Google API ist optional und erfordert Netzwerkzugriff sowie OAuth2 Token-Anforderung – die Logik ist vorbereitet, aber ggf. in deiner Umgebung zu aktivieren.
