# Wallet v2 – Benutzer‑Dokumentation

## Zielgruppe
Anwender, die den lokalen Server starten und den Pass über die Web‑Oberfläche erstellen und in Google Wallet speichern möchten.

## Voraussetzungen
- Node.js: Version 16 oder höher ist installiert.
- Google Wallet: Ein Google‑Konto mit Zugriff auf Google Wallet (Android mit Google Wallet App oder Chrome/Desktop für Vorschau).
- Service‑Account‑Schlüssel: Eine JSON‑Datei mit Wallet‑Rechten (von Google Cloud), z. B. `key.json`.

## Vorbereitung (einmalig)
- `config.json`: Issuer und Class eintragen (`issuerId`, `classId`), Farben/Bilder optional anpassen.
- Service‑Key ablegen: Lege deine Service‑Account‑Datei als `v2/key.json` ab oder passe `serviceAccountKeyPath` in `config.json` an.

## Server starten (CMD oder PowerShell)
- Ordner öffnen: Dieses Projektverzeichnis `v2` in der Konsole öffnen.
- Starten (CMD/PowerShell):
  ```powershell
  cd Pfad\zu\v2
  npm start
  # oder
  node server.js
  ```
- Prüfen: Konsole zeigt „Server running at http://localhost:3100“.

## Web‑Oberfläche verwenden
- Browser öffnen: `http://localhost:3100` aufrufen.
- Konfiguration prüfen: Der Block „Konfiguration“ zeigt die aktiven Werte aus `config.json`.

## Pass erstellen
- Basisdaten: Felder „Header“, „Subheader“, „Card Title“, „Barcode Value“ nach Bedarf ausfüllen.
- Bilder/Farbe: Optional `Logo URL`, `Hero URL` und „Hintergrundfarbe“ setzen.
- Textmodule: Die fünf Datenfelder (Telefon, E‑Mail, Mobil, PLZ, Ort) mit deinen Inhalten füllen. IDs kannst du bei Bedarf ändern.
- Layout definieren: Unter „Layout (Card Rows)“ Zeilen hinzufügen:
  - „zwei Spalten“: Links und Rechts je ein Feld auswählen.
  - „eine Spalte“: Einzelnes Feld über volle Breite.
  - Reihenfolge über Pfeile ändern, mit „Entfernen“ löschen.
- Vorschau Objekt: „Objekt‑Preview“ klicken. Ergebnis erscheint rechts unter „Preview Ergebnis“.
- Vorschau Klasse: „Klassen‑Preview“ zeigt nur das Layout (Class‑Template).
- Save‑Link erzeugen: „Save‑Link erzeugen“ klicken. Rechts erscheint „Save Ergebnis“ inkl. `saveUrl`; der Link öffnet automatisch in einem neuen Tab.
- In Wallet speichern: Auf dem geöffneten Google‑Wallet‑Tab den Pass hinzufügen. Auf Android muss die Google‑Wallet‑App installiert und mit deinem Google‑Konto angemeldet sein.

## Häufige Probleme
- Fehlender Service‑Key: Meldung „Service account key missing or invalid“. Lösung: `key.json` korrekt ablegen und `serviceAccountKeyPath` prüfen.
- Fehlende IDs: Meldung „Missing issuerId or classId“. Lösung: `issuerId`/`classId` in `config.json` setzen.
- Bilder werden nicht angezeigt: Prüfe, ob `Logo URL`/`Hero URL` öffentlich erreichbar sind (https‑Links).
- Save‑Link öffnet, aber Wallet lehnt ab: Prüfe Issuer‑Rechte und ob die Class‑ID (`issuerId.classId`) existiert.

## Direkte API‑Nutzung (optional)
- Objekt‑Preview: `POST http://localhost:3100/object/preview` mit JSON‑Body aus der Oberfläche.
- Save‑Link: `POST http://localhost:3100/wallet/save` – Antwort enthält `saveUrl` und `objectPreview`.

## Tipps
- IDs der Textmodule (z. B. `telefon`, `e-mail`) sollten mit dem Layout übereinstimmen, damit die Felder in den Card‑Zeilen erscheinen.
- Farben/Bilder kannst du dauerhaft in `config.json` pflegen; kurzfristige Tests sind über die Eingabefelder möglich.
