# Wallet v2 – Kurz-Anleitung (für Empfänger einer ZIP)

Diese Anleitung ist bewusst kurz gehalten. In 2–3 Minuten startklar.

## Voraussetzungen
- Node.js 16 oder höher installiert (https://nodejs.org)
- Optional zum Speichern in Google Wallet: Android‑Gerät mit Google‑Wallet‑App

## Schritt 1: ZIP entpacken
- ZIP an einen beliebigen Ort entpacken (z. B. Desktop).

## Schritt 2: Schlüsseldatei ablegen
- Service‑Account‑Schlüssel als `key.json` in diesen entpackten Ordner legen.
  - Falls die Datei woanders liegt: Pfad in `config.json` unter `serviceAccountKeyPath` anpassen.

## Schritt 3: Konfiguration prüfen
- Datei `config.json` öffnen.
  - Prüfen/setzen: `issuerId` und `classId` (z. B. `3388...` und `employee_card_v2`).
  - Bilder/Farbe können so bleiben.

## Schritt 4: Server starten (CMD oder PowerShell)
- Konsole öffnen und in diesen Ordner wechseln:
  ```powershell
  cd Pfad\zum\entpackten\Ordner
  npm start
  # oder
  node server.js
  ```
- Erfolgsanzeige: „Server running at http://localhost:3100“

> Hinweis: Wenn `npm`/`node` nicht gefunden werden, Node.js installieren und Konsole neu öffnen.

## Schritt 5: Browser öffnen
- `http://localhost:3100` aufrufen.
- Felder nach Bedarf ausfüllen.
- Mit „Objekt‑Preview“ das Ergebnis prüfen.

## Schritt 6: In Google Wallet speichern (optional)
- „Save‑Link erzeugen“ klicken.
- Der Link öffnet sich in einem neuen Tab; dort den Pass zu Google Wallet hinzufügen.
  - Dafür muss dein Google‑Konto die nötigen Issuer‑Rechte haben und die Wallet‑App installiert sein.

## Kurz‑Fehlerhilfe
- „Service account key missing or invalid“ → `key.json` prüfen bzw. `serviceAccountKeyPath` in `config.json` korrigieren.
- „Missing issuerId or classId“ → `issuerId`/`classId` in `config.json` setzen.
- Bilder fehlen → Öffentliche HTTPS‑URLs für Logo/Hero verwenden.
