# Ablaufdiagramm – Kunde liefert Daten

Dieses Diagramm zeigt aus Kundensicht, wie Daten und Assets an uns geliefert werden, wie die Vorschau und Freigabe ablaufen und wie der finale Pass bereitgestellt wird.

```mermaid
flowchart TB
  subgraph Kunde
    K1[Briefing erhalten]
    K2[Daten sammeln Inhalte Bilder Farbe Links]
    K3[Daten uebermitteln an Projektteam]
    K4[Testpass pruefen auf Geraet]
    K5[Freigabe oder Korrekturen]
    K6[Go Live Pass nutzen und teilen]
  end

  subgraph Projektteam_System
    P1[Briefing und Template senden]
    P2[Validierung Inhalte und Assets]
    P3[Erfassung in UI oder Import]
    P4[Preview erzeugen]
    P5[Save Link generieren]
    P6[Testpass bereitstellen]
    P7[Korrekturen umsetzen]
    P8[Finalisieren und Uebergabe]
  end

  P1 --> K1
  K1 --> K2
  K2 --> K3
  K3 --> P2
  P2 --> P3
  P3 --> P4
  P4 --> P5
  P5 --> P6
  P6 --> K4
  K4 --> K5
  K5 -- Korrekturen --> P7
  P7 --> P4
  K5 -- Freigabe --> P8
  P8 --> K6

  %% Optional und Compliance
  D1[Datenschutz Zustimmung und Logos Freigabe]
  K2 -. optional .-> D1
  D1 -. optional .-> P2

  %% Styles
  classDef area fill:#eef7ff,stroke:#2b6cb0,color:#1a202c;
  class K1,K2,K3,K4,K5,K6 area;
  class P1,P2,P3,P4,P5,P6,P7,P8 area;
```

Hinweise
- Inhalte: cardTitle, header, subheader, Textmodule, Barcode, Links.
- Assets: Logo, Hero Bild, Farbcode hexBackgroundColor.
- Freigaben: Markenfreigabe, Datenschutz, gegebenenfalls Nutzungsbedingungen.

