# Ablaufdiagramm – Wallet v2 (für Projektmanager)

Das folgende Diagramm visualisiert den End-to-End-Ablauf von Setup bis zum Hinzufügen des Passes in Google Wallet. Es basiert auf den Inhalten in `README.md`, `START-HIER.txt` und `USER-DOKUMENTATION.md`.

```mermaid
flowchart TD
  A([Start]) --> B{Node.js 16+ installiert?}
  B -- Nein --> B1[Node.js 16+ installieren]
  B1 --> B
  B -- Ja --> C{Service-Account<br/>key.json vorhanden?}
  C -- Nein --> C1[Key beschaffen/erstellen<br/>als v2/key.json ablegen<br/>oder Pfad in config.json setzen]
  C1 --> C
  C -- Ja --> D[Konfiguration prüfen/anpassen<br/>config.json: issuerId, classId,<br/>Bilder, Farben, serviceAccountKeyPath]
  D --> E[Server starten<br/>npm start oder node server.js]
  E --> F[UI öffnen<br/>http://localhost:3100]
  F --> G[Inhalte erfassen<br/>Titel, Header, Textmodule, Barcode]
  G --> H{Layout ok?}
  H -- Nein --> H1[Class-Layout anpassen<br/>UI oder POST /class/preview<br/>mit classRows]
  H1 --> G
  H -- Ja --> I[Objektvorschau prüfen<br/>POST /object/preview]
  I --> J[Save-Link erzeugen<br/>POST /wallet/save]
  J --> K{IDs + Key gültig?}
  K -- Nein --> K1[Fehlerhinweis lesen<br/>IDs/Key in `config.json` prüfen]
  K1 --> J
  K -- Ja --> L[Save-URL erhalten<br/>saveUrl + objectPreview]
  L --> M[Auf Gerät öffnen<br/>Pass zu Google Wallet hinzufügen]
  M --> N([Fertig])
  E -. Optional .-> E1[Health/Config prüfen<br/>GET /health, GET /config]

  %% Styling
  classDef step fill:#eef7ff,stroke:#2b6cb0,color:#1a202c;
  classDef decision fill:#fff7e6,stroke:#b7791f,color:#1a202c;
  classDef finish fill:#e6ffed,stroke:#2f855a,color:#1a202c;
  class A,B1,C1,D,E,F,G,H1,I,J,K1,L,M,E1 step;
  class B,C,H,K decision;
  class N finish;
```

Hinweise
- Voraussetzung: `issuerId`/`classId` gesetzt und Service-Account-Key gültig.
- Fehlerfälle: Bei fehlenden/ungültigen IDs/Keys liefert `/wallet/save` entsprechende Hinweise.
- Optional: Class-Preview hilft, das Kartenlayout (cardRowTemplateInfos) mit den TextModules abzugleichen.

Export (optional)
- Mit Mermaid-CLI: `npx @mermaid-js/mermaid-cli -i docs/ablaufdiagramm-projektmanager.md -o docs/ablaufdiagramm-projektmanager.svg`
- Oder direkt im Editor via Mermaid-Plugin/Markdown-Vorschau rendern.
