# Technisches Ablaufdiagramm – Wallet v2

Das Diagramm zeigt den technischen Ablauf der wichtigsten Endpunkte mit Fokus auf `POST /wallet/save` (Konfiguration laden, Schlüssel lesen, JSON bauen, JWT signieren, Antwort liefern).

```mermaid
sequenceDiagram
  autonumber
  participant UI as Browser UI
  participant S as server.js HTTP
  participant CFG as Config Loader
  participant KEY as Service Key
  participant CF as ClassFactory
  participant OF as ObjectFactory
  participant JWT as JwtService
  participant GW as Google Wallet

  Note over UI,S: Ablauf für POST /wallet/save
  UI->>S: POST /wallet/save payload
  S->>CFG: load config.json
  CFG-->>S: config
  S->>KEY: read key.json
  KEY-->>S: key data
  S->>CF: buildClassJson
  CF-->>S: GenericClass
  S->>OF: buildObjectJson
  OF-->>S: GenericObject
  S->>JWT: createJwt
  JWT-->>S: saveUrl und jwt
  S-->>UI: 200 saveUrl und objectPreview
  UI->>GW: open saveUrl
  GW-->>UI: pass added

  alt Fehlende IDs oder Key
    S-->>UI: 400 oder 500 Fehler
  else OK
    S-->>UI: 200 Antwort
  end

  opt Preview Endpunkte
    UI->>S: POST /class/preview
    S->>CF: buildClassJson
    CF-->>S: GenericClass JSON
    S-->>UI: 200 class JSON
    UI->>S: POST /object/preview
    S->>OF: buildObjectJson
    OF-->>S: GenericObject JSON
    S-->>UI: 200 object JSON
  end
```

Hinweise
- Fehlerfälle: 400 bei fehlenden IDs, 500 bei ungültigem Schlüssel.
- Health und Config: GET /health, GET /config für Betrieb und Debug.
- Save-Link ist eine URL, die im Browser oder Gerät geöffnet wird.

