<?php
session_start();

$passwordFile = 'password.txt';
$loginError = '';

// Logout-Logik
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Login-Versuch
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['password'])) {
        $submittedPassword = $_POST['password'];
        if (file_exists($passwordFile) && filesize($passwordFile) > 0) {
            $storedHash = trim(file_get_contents($passwordFile));
            if (password_verify($submittedPassword, $storedHash)) {
                $_SESSION['is_admin_logged_in'] = true;
                header("Location: " . $_SERVER['PHP_SELF']); // Weiterleitung zur Admin-Hauptseite (wo jetzt die Buttons sind)
                exit;
            } else {
                $loginError = "Falsches Passwort.";
            }
        } else {
            $loginError = "Passwortdatei nicht gefunden oder leer. Bitte Admin kontaktieren.";
        }
    } else {
        $loginError = "Bitte gib ein Passwort ein.";
    }
}

// Überprüfen, ob der Benutzer eingeloggt ist
if (isset($_SESSION['is_admin_logged_in']) && $_SESSION['is_admin_logged_in'] === true) {
    // Benutzer ist eingeloggt: Admin-Hauptseite mit Buttons anzeigen
    ?>
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Panel - Hauptseite</title>
        <style>
            body { font-family: sans-serif; margin: 0; background-color: #f4f4f4; display: flex; flex-direction: column; align-items: center; min-height: 100vh; padding-top: 20px;}
            .container { background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); width: 90%; max-width: 500px; text-align: center; }
            h1 { color: #333; margin-bottom: 25px; }
            .admin-menu a.button {
                display: block;
                background-color: #007bff;
                color: white;
                padding: 12px 20px;
                margin: 10px 0;
                text-decoration: none;
                border-radius: 5px;
                font-size: 1.05em;
                transition: background-color 0.3s ease;
            }
            .admin-menu a.button:hover { background-color: #0056b3; }
            .logout-link { display: inline-block; margin-top: 30px; color: #dc3545; text-decoration: none; padding: 8px 15px; border: 1px solid #dc3545; border-radius: 5px;}
            .logout-link:hover { background-color: #dc3545; color: white; }
        </style>

    </head>
    <body>
        <div class="container">
            <h1>Admin Panel</h1>
            <p>Willkommen! Wählen Sie einen Bereich zur Verwaltung aus:</p>
            
            <div class="admin-menu">
                <a href="view_folder.php?folder=layers" class="button">Inhalt des Ordners "Layers" anzeigen</a>
                <a href="view_folder.php?folder=generated_images" class="button">Inhalt des Ordners "Generierte Bilder" anzeigen</a>
                <!-- Hier könnten weitere Admin-Funktionen als Buttons hinzugefügt werden -->
            </div>

            <a href="?logout=true" class="logout-link">Logout</a>
        </div>
        <script>
  if ('serviceWorker' in navigator) {
    // Versuche, zuerst alle bestehenden SWs für den Admin-Pfad zu deregistrieren
    navigator.serviceWorker.getRegistrations().then(function(registrations) {
      for(let registration of registrations) {
        if (registration.scope.includes('/admin/')) { // Oder genauer Scope-Vergleich
          registration.unregister().then(function(boolean) {
            console.log(boolean ? 'Admin SW unregistriert' : 'Admin SW nicht unregistriert');
          });
        }
      }
      // Dann den No-Op SW registrieren
      navigator.serviceWorker.register('/admin/admin-noop-sw.js', { scope: '/admin/' })
        .then(registration => {
          console.log('Admin No-Op ServiceWorker registriert mit scope:', registration.scope);
        })
        .catch(error => {
          console.error('Admin No-Op ServiceWorker Registrierung fehlgeschlagen:', error);
        });
    });
  }
</script>
    </body>
    </html>
    <?php
} else {
    // Benutzer ist nicht eingeloggt: Login-Formular anzeigen
    ?>
    <!DOCTYPE html>
    <html lang="de">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Admin Login</title>
        <style>
            body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; min-height: 90vh; background-color: #f0f2f5; margin:0; }
            .login-container { background-color: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); width: 300px; }
            h1 { text-align: center; color: #333; margin-bottom: 20px; }
            label { display: block; margin-bottom: 5px; color: #555; }
            input[type="password"] { width: calc(100% - 22px); padding: 10px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 4px; }
            input[type="submit"] { width: 100%; padding: 10px; background-color: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; }
            input[type="submit"]:hover { background-color: #0056b3; }
            .error { color: red; text-align: center; margin-bottom: 10px; }
        </style>

    </head>
    <body>
        <div class="login-container">
            <h1>Admin Login</h1>
            <?php if (!empty($loginError)): ?>
                <p class="error"><?php echo htmlspecialchars($loginError); ?></p>
            <?php endif; ?>
            <form method="POST" action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>">
                <div>
                    <label for="password">Passwort:</label>
                    <input type="password" id="password" name="password" required>
                </div>
                <div>
                    <input type="submit" value="Login">
                </div>
            </form>
        </div>
<script>
  if ('serviceWorker' in navigator) {
    // Versuche, zuerst alle bestehenden SWs für den Admin-Pfad zu deregistrieren
    navigator.serviceWorker.getRegistrations().then(function(registrations) {
      for(let registration of registrations) {
        if (registration.scope.includes('/admin/')) { // Oder genauer Scope-Vergleich
          registration.unregister().then(function(boolean) {
            // console.log(boolean ? 'Admin SW unregistriert' : 'Admin SW nicht unregistriert');
          });
        }
      }
      // Dann den No-Op SW registrieren
      navigator.serviceWorker.register('/admin/admin-noop-sw.js', { scope: '/admin/' })
        .then(registration => {
          // console.log('Admin No-Op ServiceWorker registriert mit scope:', registration.scope);
        })
        .catch(error => {
          // console.error('Admin No-Op ServiceWorker Registrierung fehlgeschlagen:', error);
        });
    });
  }
</script>
    </body>
    
    </html>
    <?php
}
?>