console.log("Prüfe window.drawCameraOverlay VOR jeder Deklaration:", window.drawCameraOverlay);
alert("Prüfung window.drawCameraOverlay: " + typeof window.drawCameraOverlay); // Stoppt hier, damit du schauen kannst
console.log("MAIN.JS WIRD JETZT AUSGEFÜHRT - ZEITSTEMPEL:", new Date().toISOString());

// js/main.js
import {
    canvas,
    // ctx,
    imageUpload,// Für handleFile
    startCameraBtn,
    cameraModalElement,
    cameraFeed,
    photoCanvas,
    resolutionButtonsContainer,
    switchCameraBtn,
    takePhotoBtn,
    cameraErrorMsg,
    cameraOverlayCanvas,
    cameraOverlaySelect,
    cameraOverlayCtx,
    // drawCameraOverlay,
    layerSelect,
    addLayerBtn,
    saveProjectBtn,
    loadProjectInput,
    projectFilenameInput,
    downloadBtn,
    downloadFilenameInput,
    confirmResetModalElement,
    confirmResetModalYesBtn,
    resetProjectBtn,
    // baseImageSizeInfo,
    pageLoader,
    appContent,
    dropZone,
    uploadProgressContainer,
    uploadProgressBar,
    undoBtn,
    redoBtn,
    confirmDeleteLayerModalElement,
    confirmDeleteLayerModalYesBtn,
    layerNameToDeleteSpan,
    HANDLE_SIZE
} from './config.js';
import { Layer } from './layer.js';
import { fetchLayerOptionsFromServer, populateLayerSelectWithOptions } from './dataLoader.js';
import { drawCanvas, getMousePos, getTouchPos, getTouchDistance } from './canvasController.js';
import { updateLayerList, displayBaseImageSize, displayBaseImageError, initUIController } from './uiController.js';
import { showNotification } from './notifications.js';


// Globaler Anwendungsstatus
let baseImage = null;
let layers = [];
let activeLayerIndex = -1;
let action = null; // "move", "pinch", oder null
let offset = { x: 0, y: 0 };
let initialDistance = 0;
let initialScale = 1;
let confirmResetModalInstance = null;
let layerIndexToDelete = -1; // Um den Index zwischenzuspeichern
let wheelDebounceTimeout;
let cameraModalInstance = null;
let currentCameraStream = null; // Um den Stream später stoppen zu können
let availableVideoDevices = []; // Liste der verfügbaren Videogeräte
let currentDeviceIndex = 0;   // Index des aktuell verwendeten Geräts in availableVideoDevices
let initialCameraPermissionGranted = false;
let overlayInitialDistance = 0;     // Für Overlay-Pinch-Zoom
let overlayInitialScale = 1;        // Für Overlay-Pinch-Zoom
// Globale Variable für das Overlay-Canvas-Context und den ausgewählten Layer
// let cameraOverlayCtx = null;
let selectedOverlayLayerIndex = -1; // Index im `layers`-Array für das Overlay
let overlayLayerInstance = null; // Eine geklonte Instanz des Layers für das Overlay, um Original nicht zu verändern
let overlayAction = null;
let overlayOffset = { x: 0, y: 0 };

let currentRequestedWidth = 1280; // Standardwert
let currentRequestedHeight = 720; // Standardwert
// --- Undo/Redo State ---
let undoStack = [];
let redoStack = [];
const MAX_HISTORY_STATES = 50; // Begrenzung der Historie
let confirmDeleteLayerModalInstance = null;

// --- Hilfsfunktionen / UI Aktionen ---
function showLoader() {
    if (pageLoader) {
        pageLoader.classList.remove('hidden');
    }
    if (appContent) {
        appContent.classList.remove('visible'); // Sicherstellen, dass Inhalt nicht sichtbar ist
    }
}

function hideLoaderAndShowApp() {
    if (pageLoader) {
        pageLoader.classList.add('hidden');
    }
    if (appContent) {
        appContent.classList.add('visible'); // Inhalt sichtbar machen
        // Optional: style.display = 'none' entfernen, falls es noch gesetzt war
        // appContent.style.display = ''; // Oder 'block', 'flex' etc. je nach Layout
    }
}
// Hilfsfunktion zum tiefen Klonen des relevanten Zustands
function cloneState(stateLayers, stateActiveLayerIndex, stateBaseImage) {
    // Für Layer müssen wir sicherstellen, dass auch die internen Image-Objekte
    // nicht nur referenziert, sondern ihre relevanten Eigenschaften kopiert werden.
    // Da Image-Objekte nicht einfach tief geklont werden können, speichern wir ihre src.
    // Beim Wiederherstellen müssen die Bilder neu geladen werden (oder man hat eine Cache-Logik).
    // Für diese Implementierung fokussieren wir uns auf die Layer-Daten.
    const clonedLayers = stateLayers.map(layer => {
        // Erstelle eine neue Layer-Instanz oder ein einfaches Objekt
        // Wichtig: Das Image-Objekt selbst kann nicht einfach tief geklont werden.
        // Wir speichern die src und erstellen beim Wiederherstellen ein neues Image.
        return {
            // imageSrc: layer.image.src, // Wichtig für die Wiederherstellung
            // Stattdessen für eine einfachere Demo, die die Image-Objekte direkt referenziert
            // (Achtung: Das ist keine echte tiefe Kopie für die Bilder selbst!):
            image: layer.image, // Behält die Referenz zum Original-Image-Objekt
            // Für eine echte Undo/Redo für Bilder müsste man die src speichern
            // und beim Wiederherstellen des Zustands Images neu laden (asynchron!)

            x: layer.x,
            y: layer.y,
            scale: layer.scale,
            width: layer.width, // Originalbreite
            height: layer.height, // Originalhöhe
            label: layer.label,
            isVisible: layer.isVisible
        };
    });

    return {
        layers: clonedLayers,
        activeLayerIndex: stateActiveLayerIndex,
        baseImageSrc: stateBaseImage ? stateBaseImage.src : null, // Nur die Quelle speichern
        baseImageOriginalName: stateBaseImage ? stateBaseImage.originalName : null
        // Füge hier weitere Zustandsvariablen hinzu, die du speichern möchtest
    };
}
function getCurrentState() {
    return cloneState(layers, activeLayerIndex, baseImage);
}

function recordStateForUndo() {
    // Bevor ein neuer Zustand aufgezeichnet wird, den aktuellen Zustand sichern.
    // Dieser wird der "Vorher"-Zustand für die nächste Aktion.
    const stateToPush = getCurrentState(); // Den Zustand *vor* der Änderung holen
    console.log("recordStateForUndo: stateToPush =", JSON.stringify(stateToPush)); // DEBUG: Sieh dir den Zustand an
    undoStack.push(stateToPush);
    if (undoStack.length > MAX_HISTORY_STATES) {
        undoStack.shift(); // Ältesten Zustand entfernen, um Stack nicht unendlich wachsen zu lassen
    }
    redoStack = []; // Jede neue Aktion löscht die Redo-Historie
    updateUndoRedoButtons();
    console.log("recordStateForUndo: undoStack Länge =", undoStack.length); // DEBUG

}
// Wrapper-Funktion, die eine Aktion ausführt und den Zustand aufzeichnet
// Diese Funktion wird VOR jeder Aktion aufgerufen, die rückgängig gemacht werden soll
function performActionAndRecordState(actionFunction) {
    recordStateForUndo(); // Zustand VOR der Aktion speichern
    actionFunction();      // Die eigentliche Aktion ausführen
    // redrawAll() sollte Teil der actionFunction sein oder direkt danach aufgerufen werden
}
function applyState(state) {
    return new Promise(async (resolve, reject) => { // Async, da Bildladen involviert ist
        // Basisbild wiederherstellen
        baseImage = null; // Zurücksetzen
        if (state.baseImageSrc) {
            const newBaseImg = new Image();
            newBaseImg.originalName = state.baseImageOriginalName;
            const baseImageLoadPromise = new Promise((imgResolve, imgReject) => {
                newBaseImg.onload = () => { baseImage = newBaseImg; imgResolve(); };
                newBaseImg.onerror = imgReject;
            });
            newBaseImg.src = state.baseImageSrc;
            try {
                await baseImageLoadPromise;
                canvas.width = baseImage.width;
                canvas.height = baseImage.height;
                displayBaseImageSize(baseImage.naturalWidth, baseImage.naturalHeight);
            } catch (e) {
                console.warn("Konnte Basisbild beim Wiederherstellen nicht laden", e);
                displayBaseImageSize(null, null); // Alte Größe entfernen
                // Canvas auf Standardgröße oder leer lassen
                if (canvas) canvas.width = canvas.width;
            }
        } else {
            if (canvas) canvas.width = canvas.width; // Canvas leeren
            displayBaseImageSize(null, null);
        }


        // Layer wiederherstellen
        // Da wir in `cloneState` nur die Referenz zum Image-Objekt behalten haben (vereinfacht),
        // brauchen wir die Layer-Bilder nicht neu zu laden.
        // Bei einer Implementierung, die `imageSrc` speichert, wäre hier ein async map nötig.
        layers = state.layers.map(layerData => {
            // Wenn `cloneState` echte Layer-Objekte mit Referenz zum Image-Objekt erstellt:
            // Hier müsste man sicherstellen, dass die Layer-Objekte korrekte Prototypen haben,
            // falls cloneState nur Plain Objects erzeugt.
            // Für die vereinfachte Version, wo layer.image eine Referenz ist:
            const newLayer = new Layer(layerData.image, layerData.x, layerData.y, layerData.label);
            newLayer.scale = layerData.scale;
            newLayer.isVisible = layerData.isVisible;
            // width/height sind schon im Layer-Objekt durch das Image gesetzt.
            return newLayer;
        });

        activeLayerIndex = state.activeLayerIndex;
        if (activeLayerIndex >= layers.length) { // Sicherstellen, dass Index gültig ist
            activeLayerIndex = layers.length > 0 ? layers.length - 1 : -1;
        }

        redrawAll();
        updateUndoRedoButtons();
        resolve();
    });
}


function undo() {
    if (undoStack.length === 0) return;

    const stateToRestore = undoStack.pop();
    const currentStateForRedo = getCurrentState(); // Aktuellen Zustand für Redo sichern
    redoStack.push(currentStateForRedo);
    if (redoStack.length > MAX_HISTORY_STATES) {
        redoStack.shift();
    }

    applyState(stateToRestore).then(() => {
        showNotification("Aktion rückgängig gemacht", "info", 1500);
    });
}

function redo() {
    if (redoStack.length === 0) return;

    const stateToRestore = redoStack.pop();
    const currentStateForUndo = getCurrentState(); // Aktuellen Zustand für Undo sichern
    undoStack.push(currentStateForUndo);
    if (undoStack.length > MAX_HISTORY_STATES) {
        undoStack.shift();
    }

    applyState(stateToRestore).then(() => {
        showNotification("Aktion wiederholt", "info", 1500);
    });
}

function updateUndoRedoButtons() {
    if (undoBtn) undoBtn.disabled = undoStack.length === 0;
    if (redoBtn) redoBtn.disabled = redoStack.length === 0;
}
// --- FUNKTIONEN ZUM ÄNDERN DER LAYER-REIHENFOLGE ---
function moveLayerUp(index) {
    if (index <= 0 || index >= layers.length) { // Kann nicht weiter nach oben oder ungültiger Index
        return;
    }
    recordStateForUndo(); // Zustand VOR der Änderung sichern

    // Tausche das Element mit dem Element davor
    const temp = layers[index - 1];
    layers[index - 1] = layers[index];
    layers[index] = temp;

    // Wenn der aktive Layer verschoben wurde, aktualisiere seinen Index
    if (activeLayerIndex === index) {
        activeLayerIndex = index - 1;
    } else if (activeLayerIndex === index - 1) {
        activeLayerIndex = index;
    }

    redrawAll();
    showNotification(`Layer "${layers[activeLayerIndex]?.label || 'Ausgewählt'}" nach oben verschoben.`, 'info', 2000);
}

function moveLayerDown(index) {
    if (index < 0 || index >= layers.length - 1) { // Kann nicht weiter nach unten oder ungültiger Index
        return;
    }
    recordStateForUndo(); // Zustand VOR der Änderung sichern

    // Tausche das Element mit dem Element danach
    const temp = layers[index + 1];
    layers[index + 1] = layers[index];
    layers[index] = temp;

    // Wenn der aktive Layer verschoben wurde, aktualisiere seinen Index
    if (activeLayerIndex === index) {
        activeLayerIndex = index + 1;
    } else if (activeLayerIndex === index + 1) {
        activeLayerIndex = index;
    }

    redrawAll();
    showNotification(`Layer "${layers[activeLayerIndex]?.label || 'Ausgewählt'}" nach unten verschoben.`, 'info', 2000);
}

function resetProjectState() {
    // Globale Zustandsvariablen zurücksetzen
    baseImage = null;
    layers = [];
    activeLayerIndex = -1;
    action = null;
    offset = { x: 0, y: 0 };
    initialDistance = 0;
    initialScale = 1;

    // Undo/Redo Stacks leeren
    undoStack = [];
    redoStack = [];
    updateUndoRedoButtons(); // Buttons deaktivieren

    // UI-Elemente zurücksetzen
    if (canvas) {
        // Canvas leeren (einfacher Weg, um auch die Größe auf 0/0 zu setzen, wenn kein Bild da ist)
        // Besser wäre, die Standardgröße des Canvas wiederherzustellen, falls vorhanden,
        // oder zu warten, bis ein neues Basisbild geladen wird.
        // Für den Moment löschen wir den Inhalt.
        const tempCtx = canvas.getContext('2d');
        tempCtx.clearRect(0, 0, canvas.width, canvas.height);
        // Optional: Canvas-Dimensionen auf einen Standardwert oder 0 setzen
        // canvas.width = 0;
        // canvas.height = 0;
        // Besser: drawCanvas() wird leeren Canvas zeichnen, wenn baseImage null ist.
    }

    if (imageUpload) imageUpload.value = ""; // Dateiauswahlfeld zurücksetzen
    if (baseImageSizeInfo) displayBaseImageSize(null, null); // Aufruf der UI-Funktion
    if (downloadFilenameInput) downloadFilenameInput.value = "";
    if (projectFilenameInput) projectFilenameInput.value = "";
    if (layerSelect && layerSelect.options.length > 0) { // Layer-Auswahl zurücksetzen
        layerSelect.selectedIndex = 0;
    }


    // Alles neu zeichnen (leerer Zustand)
    redrawAll(); // Diese Funktion ruft drawCanvas und updateLayerList auf

    showNotification('Projekt zurückgesetzt.', 'info');
}
// Die Funktion, die tatsächlich den Layer löscht (ohne eigene Bestätigung)
function performLayerDelete(indexToDelete) {
    if (indexToDelete < 0 || indexToDelete >= layers.length) {
        console.error("Ungültiger Index zum Löschen:", indexToDelete);
        return;
    }
    const deletedLayerLabel = layers[indexToDelete].label || `Layer ${indexToDelete + 1}`; // Namen für Benachrichtigung holen

    recordStateForUndo(); // Zustand VOR dem Löschen sichern

    layers.splice(indexToDelete, 1);

    if (activeLayerIndex === indexToDelete) {
        activeLayerIndex = (layers.length > 0) ? Math.max(0, layers.length - 1) : -1;
    } else if (activeLayerIndex > indexToDelete) {
        activeLayerIndex--;
    }
    if (activeLayerIndex >= layers.length) {
        activeLayerIndex = layers.length > 0 ? layers.length - 1 : -1;
    }

    redrawAll();
    showNotification(`Layer "${deletedLayerLabel}" erfolgreich gelöscht.`, 'success');
}

// Diese Funktion wird jetzt vom uiController aufgerufen, wenn der Löschen-Button geklickt wird.
// Sie ist der neue "deleteLayer"-Callback.
function handleDeleteLayerRequest(index, layerName) {
    if (index < 0 || index >= layers.length) return;

    layerIndexToDelete = index; // Index für den "Ja"-Button im Modal speichern
    if (layerNameToDeleteSpan) {
        layerNameToDeleteSpan.textContent = layerName; // Namen im Modal anzeigen
    }

    if (confirmDeleteLayerModalInstance) {
        confirmDeleteLayerModalInstance.show(); // Modal anzeigen
    } else {
        console.error("Modal-Instanz für Layer-Löschbestätigung nicht gefunden!");
        // Fallback (sollte nicht passieren, wenn initializeApp korrekt ist)
        if (confirm(`Fallback: Layer "${layerName}" wirklich löschen?`)) {
            performLayerDelete(layerIndexToDelete);
        }
    }
}
function performProjectReset() {
    // Globale Zustandsvariablen zurücksetzen
    baseImage = null;
    layers = [];
    // ... (Rest deiner resetProjectState Logik von vorher) ...
    activeLayerIndex = -1;
    action = null;
    offset = { x: 0, y: 0 };
    initialDistance = 0;
    initialScale = 1;
    undoStack = [];
    redoStack = [];
    updateUndoRedoButtons();

    if (canvas) {
        const tempCtx = canvas.getContext('2d');
        tempCtx.clearRect(0, 0, canvas.width, canvas.height);
    }
    if (imageUpload) imageUpload.value = "";
    if (baseImageSizeInfo) displayBaseImageSize(null, null);
    if (downloadFilenameInput) downloadFilenameInput.value = "";
    if (projectFilenameInput) projectFilenameInput.value = "";
    if (layerSelect && layerSelect.options.length > 0) {
        layerSelect.selectedIndex = 0;
    }
    redrawAll();
    showNotification('Projekt zurückgesetzt.', 'info');
}

function redrawAll() {
    console.log("redrawAll aufgerufen"); // DEBUG
    drawCanvas(layers, activeLayerIndex, baseImage);
    updateLayerList(layers, activeLayerIndex); // Wichtig, damit UI-Buttons aktualisiert werden
    populateCameraOverlaySelectWithProjectLayers(); // Kamera-Overlay-Dropdown aktualisieren
}

function setActiveLayer(index) {
    if (index >= 0 && index < layers.length) {
        // PRÜFUNG AUF SICHTBARKEIT HINZUGEFÜGT:
        if (!layers[index].isVisible) {
            showNotification(`Layer "${layers[index].label || `Layer ${index + 1}`}" ist ausgeblendet und kann nicht ausgewählt werden.`, 'info', 3000);
            // Optional: Aktuelle Auswahl beibehalten oder auf -1 setzen, wenn der VORHER aktive Layer der ausgeblendete war.
            // Fürs Erste verhindern wir einfach die Auswahl.
            // Wenn der aktuell aktive Layer ausgeblendet wird, sollte die Auswahl ggf. auf -1 gesetzt werden.
            // Das passiert aber eher in toggleLayerVisibility.
            return; // Verhindere die Auswahl
        }
        // Nur den Zustand für Undo speichern, wenn sich der aktive Layer tatsächlich ändert
        // und der neue Layer nicht schon der aktive ist.
        if (activeLayerIndex !== index) {
            recordStateForUndo(); // Zustand VOR der Änderung des activeLayerIndex
            activeLayerIndex = index;
        }
        activeLayerIndex = index;
    } else {
        // Wenn Index ungültig, keinen aktiven Layer (oder den vorherigen beibehalten)
        // Hier ist es wahrscheinlich besser, explizit -1 zu setzen, wenn der Index ungültig ist
        if (activeLayerIndex !== -1) recordStateForUndo(); // Zustand vor dem Deselektieren
        activeLayerIndex = -1;
    }
    redrawAll();
}
// --- FUNKTION ZUM ÄNDERN DER LAYER-REIHENFOLGE DURCH DRAG & DROP ---
function moveLayerByIndex(startIndex, endIndex) {
    if (startIndex < 0 || startIndex >= layers.length || endIndex < 0 || endIndex >= layers.length) {
        console.error("Ungültige Indizes für Drag & Drop:", startIndex, endIndex);
        return;
    }
    if (startIndex === endIndex) return; // Nichts zu tun

    recordStateForUndo(); // Zustand VOR der Änderung sichern

    const itemToMove = layers.splice(startIndex, 1)[0]; // Entferne das Element und hole es
    layers.splice(endIndex, 0, itemToMove);         // Füge es an der neuen Position ein

    // activeLayerIndex anpassen
    if (activeLayerIndex === startIndex) {
        activeLayerIndex = endIndex;
    } else if (startIndex < activeLayerIndex && endIndex >= activeLayerIndex) {
        activeLayerIndex--;
    } else if (startIndex > activeLayerIndex && endIndex <= activeLayerIndex) {
        activeLayerIndex++;
    }
    // Sicherstellen, dass activeLayerIndex gültig bleibt
    if (activeLayerIndex >= layers.length) {
        activeLayerIndex = layers.length > 0 ? layers.length -1 : -1;
    }


    redrawAll();
    showNotification('Layer-Reihenfolge geändert.', 'info', 2000);
}
function getOverlayMousePos(evt) {
    if (!cameraOverlayCanvas) return { x: 0, y: 0 }; // Fallback
    const rect = cameraOverlayCanvas.getBoundingClientRect();
    const scaleX = cameraOverlayCanvas.width / rect.width;
    const scaleY = cameraOverlayCanvas.height / rect.height;
    return {
        x: (evt.clientX - rect.left) * scaleX,
        y: (evt.clientY - rect.top) * scaleY
    };
}

function getOverlayTouchPos(touch) {
    if (!cameraOverlayCanvas) return { x: 0, y: 0 }; // Fallback
    const rect = cameraOverlayCanvas.getBoundingClientRect();
    const scaleX = cameraOverlayCanvas.width / rect.width;
    const scaleY = cameraOverlayCanvas.height / rect.height;
    return {
        x: (touch.clientX - rect.left) * scaleX,
        y: (touch.clientY - rect.top) * scaleY
    };
}
function setupOverlayCanvasInteractions() {
    if (!cameraOverlayCanvas) {
        console.warn("cameraOverlayCanvas nicht gefunden für Interaktions-Setup.");
        return;
    }

    // --- MAUS-EVENTS FÜR OVERLAY-VERSCHIEBEN ---
    cameraOverlayCanvas.addEventListener("mousedown", e => {
        if (!overlayLayerInstance || !overlayLayerInstance.isVisible) return;

        const { x, y } = getOverlayMousePos(e);
        const layerBounds = overlayLayerInstance.getScaledSize(); // Breite/Höhe des skalierten Overlays

        // Prüfe, ob der Klick innerhalb der Grenzen des overlayLayerInstance liegt
        if (x >= overlayLayerInstance.x && x <= overlayLayerInstance.x + layerBounds.width &&
            y >= overlayLayerInstance.y && y <= overlayLayerInstance.y + layerBounds.height) {

            overlayAction = "move";
            overlayOffset.x = x - overlayLayerInstance.x;
            overlayOffset.y = y - overlayLayerInstance.y;

            // Verhindere Textauswahl etc. während des Ziehens (optional, aber oft gut)
            e.preventDefault();
            // console.log("Overlay mousedown: start move", overlayOffset);
            drawCameraOverlay(); // Um ggf. Handles oder Hervorhebung zu zeigen
        } else {
            overlayAction = null; // Klick war außerhalb des Overlays
        }
    });

    // Wichtig: Mousemove auf dem Window oder Document, um das Ziehen auch außerhalb des Canvas fortzusetzen
    window.addEventListener("mousemove", e => {
        if (!overlayLayerInstance || overlayAction !== "move") return;

        // Verhindere, dass die Maus-Events das Video oder andere Elemente beeinflussen,
        // WENN eine Overlay-Aktion aktiv ist.
        // Dies kann knifflig sein, wenn das Overlay nicht den gesamten Kamerabereich abdeckt.
        // Fürs Erste gehen wir davon aus, dass das Ziehen immer Priorität hat, wenn `overlayAction` gesetzt ist.
        e.preventDefault(); // Verhindert ggf. Scrollen der Seite, wenn man schnell zieht

        const { x, y } = getOverlayMousePos(e); // Mausposition relativ zum Overlay-Canvas
        overlayLayerInstance.x = x - overlayOffset.x;
        overlayLayerInstance.y = y - overlayOffset.y;
        drawCameraOverlay();
    });

    window.addEventListener("mouseup", e => { // Auf window lauschen, um Loslassen überall zu erkennen
        if (overlayAction === "move") {
            console.log("Overlay mouseup: move beendet");
            overlayAction = null;
            // Hier KEIN recordStateForUndo, da es nur das temporäre Overlay betrifft
            drawCameraOverlay(); // Finale Position zeichnen
        }
    });


    // --- TOUCH-EVENTS FÜR OVERLAY-VERSCHIEBEN (Pinch-Zoom kommt später, falls gewünscht) ---
    cameraOverlayCanvas.addEventListener("touchstart", e => {
        if (!overlayLayerInstance || !overlayLayerInstance.isVisible || e.touches.length === 0) return;

        // Fürs Erste nur Single-Touch-Verschieben
        if (e.touches.length === 1) {
            const touch = e.touches[0];
            const { x, y } = getOverlayTouchPos(touch);
            const layerBounds = overlayLayerInstance.getScaledSize();

            if (x >= overlayLayerInstance.x && x <= overlayLayerInstance.x + layerBounds.width &&
                y >= overlayLayerInstance.y && y <= overlayLayerInstance.y + layerBounds.height) {

                overlayAction = "move";
                overlayOffset.x = x - overlayLayerInstance.x;
                overlayOffset.y = y - overlayLayerInstance.y;
                // console.log("Overlay touchstart: start move", overlayOffset);
                drawCameraOverlay();
                e.preventDefault(); // Verhindert Scrollen der Seite etc.
            } else {
                overlayAction = null;
            }
        }
        // Hier könnte später die Pinch-Zoom-Logik für das Overlay hin
        // else if (e.touches.length === 2) {
        //     overlayAction = "pinch";
        //     overlayInitialDistance = getTouchDistance(e.touches);
        //     overlayInitialScale = overlayLayerInstance.scale;
        //     e.preventDefault();
        // }

    }, { passive: false }); // passive:false, um preventDefault zu erlauben

    cameraOverlayCanvas.addEventListener("touchmove", e => {
        if (!overlayLayerInstance || !overlayAction || e.touches.length === 0) return;
        e.preventDefault();

        if (e.touches.length === 1 && overlayAction === "move") {
            const touch = e.touches[0];
            const { x, y } = getOverlayTouchPos(touch);
            overlayLayerInstance.x = x - overlayOffset.x;
            overlayLayerInstance.y = y - overlayOffset.y;
            drawCameraOverlay();
        }
        // Hier Pinch-Zoom-Logik für Overlay
        // else if (e.touches.length === 2 && overlayAction === "pinch") {
        //     const newDist = getTouchDistance(e.touches);
        //     overlayLayerInstance.scale = Math.max(0.1, overlayInitialScale * (newDist / overlayInitialDistance));
        //     drawCameraOverlay();
        // }
    });

    cameraOverlayCanvas.addEventListener("touchend", e => {
        if (overlayAction) { // Nur wenn eine Overlay-Aktion aktiv war
            // console.log("Overlay touchend: action beendet", overlayAction);
        }
        overlayAction = null; // Aktion immer zurücksetzen
        // Ggf. drawCameraOverlay(), um finale Position ohne Handles zu zeichnen
        drawCameraOverlay();
    });

    console.log("Event-Listener für Overlay-Canvas-Interaktionen eingerichtet.");
}

// Funktion zum Verarbeiten der ausgewählten/gedroppten Datei
function handleFile(file) {
    if (!file) {
        if (uploadProgressContainer) uploadProgressContainer.style.display = 'none';
        return; // Kein File ausgewählt
    }

    // Erweiterte Typüberprüfung
    const allowedMimeTypes = [
        'image/jpeg',
        'image/png',
        'image/gif',
        'image/bmp',
        'image/webp',
        'image/svg+xml',
        'image/heic', // MIME-Typ für HEIC
        'image/heif'  // MIME-Typ für HEIF
    ];

    const allowedExtensions = ['.jpg', '.jpeg', '.png', '.gif', '.bmp', '.webp', '.svg', '.heic', '.heif'];

    // Überprüfung anhand des MIME-Typs (primär) oder der Dateiendung (sekundär)
    let isValidType = allowedMimeTypes.includes(file.type.toLowerCase());

    if (!isValidType && file.name) {
        const fileExtension = '.' + file.name.split('.').pop().toLowerCase();
        if (allowedExtensions.includes(fileExtension)) {
            // Wenn MIME-Typ leer oder nicht erkannt, aber Endung bekannt ist, akzeptieren wir es erstmal.
            // Der Browser muss es dann verarbeiten können.
            // Besonders bei HEIC kann der MIME-Typ manchmal leer sein oder nicht als 'image/...' starten.
            console.warn(`Datei "${file.name}" hat einen unbekannten oder leeren MIME-Typ ("${file.type}"), wird aber aufgrund der Endung "${fileExtension}" akzeptiert.`);
            isValidType = true;
            // Wenn der MIME-Typ bei HEIC leer ist, setze ihn ggf. manuell,
            // falls eine Konvertierungsbibliothek ihn später braucht (optional)
            if ((fileExtension === '.heic' || fileExtension === '.heif') && !file.type) {
                // Dies ist nur ein Versuch, eine spätere Konvertierung zu unterstützen.
                // Object.defineProperty(file, 'type', { value: 'image/heic' }); // Kann nicht direkt geändert werden
                // Stattdessen müsste man ein neues File-Objekt oder einen Blob erstellen.
                // Für die reine Anzeige durch den Browser ist das oft nicht nötig.
            }
        }
    }


    if (!isValidType) {
        showNotification(
            "Bitte wählen Sie eine gültige Bilddatei aus (z.B. JPG, PNG, GIF, WEBP, HEIC, SVG).",
            'error',
            5000
        );
        if (uploadProgressContainer) uploadProgressContainer.style.display = 'none';
        return;
    }
    const reader = new FileReader();

    reader.onloadstart = function () {
        if (uploadProgressContainer) uploadProgressContainer.style.display = 'block';
        if (uploadProgressBar) {
            uploadProgressBar.style.width = '0%';
            uploadProgressBar.textContent = '0%';
            uploadProgressBar.setAttribute('aria-valuenow', '0');
        }
    };

    reader.onprogress = function (event) {
        if (event.lengthComputable) {
            const percentLoaded = Math.round((event.loaded / event.total) * 100);
            if (uploadProgressBar) {
                uploadProgressBar.style.width = percentLoaded + '%';
                uploadProgressBar.textContent = percentLoaded + '%';
                uploadProgressBar.setAttribute('aria-valuenow', percentLoaded.toString());
            }
        }
    };

    reader.onload = function (evt) {
        const newBaseImage = new Image();
        newBaseImage.originalName = file.name;
        newBaseImage.onload = () => {
            baseImage = newBaseImage;
            canvas.width = baseImage.width;
            canvas.height = baseImage.height;
            displayBaseImageSize(baseImage.naturalWidth, baseImage.naturalHeight);
            redrawAll();
            // ERFOLGSMELDUNG FÜR BILDUPLOAD
            showNotification(`Basisbild "${file.name}" erfolgreich geladen!`, 'success', 3000);
            if (uploadProgressContainer) {
                // Fortschrittsbalken nach kurzer Verzögerung ausblenden oder bei Erfolg
                setTimeout(() => {
                    if (uploadProgressContainer) uploadProgressContainer.style.display = 'none';
                }, 500); // Kurze Verzögerung, um "100%" anzuzeigen
            }
        };
        newBaseImage.onerror = () => {
            const errorMessage = `Basisbild "${file.name}" konnte nicht geladen werden.`;
            console.error(errorMessage);
            showNotification(errorMessage, 'error'); // Standarddauer
            displayBaseImageError(); // Deine bestehende Funktion für die UI
            baseImage = null;
            if (uploadProgressContainer) uploadProgressContainer.style.display = 'none';
        };
        newBaseImage.src = evt.target.result;
    };

    reader.onerror = function () {
        const errorMessage = "Fehler beim Lesen der Datei.";
        console.error("FileReader Fehler:", reader.error);
        showNotification(errorMessage, 'error');
        if (uploadProgressContainer) uploadProgressContainer.style.display = 'none';
    };

    reader.readAsDataURL(file);
}
function deleteLayer(indexToDelete) {
    recordStateForUndo();
    console.log("deleteLayer in main.js aufgerufen mit Index:", indexToDelete); // DEBUG
    if (indexToDelete < 0 || indexToDelete >= layers.length) {
        console.error("Ungültiger Index zum Löschen:", indexToDelete);
        return;
    }
    layers.splice(indexToDelete, 1); // Entfernt den Layer aus dem Array

    // Wenn der gelöschte Layer der aktive war oder der aktive Layer jetzt außerhalb des Bereichs liegt
    if (activeLayerIndex === indexToDelete) {
        activeLayerIndex = -1; // Keinen aktiven Layer oder den letzten wählen
        if (layers.length > 0) {
            activeLayerIndex = Math.max(0, layers.length - 1); // Letzten Layer aktiv machen
        }
    } else if (activeLayerIndex > indexToDelete) {
        activeLayerIndex--; // Index anpassen, da ein Element davor entfernt wurde
    }
    // Sicherstellen, dass activeLayerIndex gültig bleibt
    if (activeLayerIndex >= layers.length) {
        activeLayerIndex = layers.length > 0 ? layers.length - 1 : -1;
    }

    redrawAll(); // Canvas und Liste neu zeichnen
    showNotification('Layer erfolgreich gelöscht.', 'success');
}

// Funktion zum Umschalten der Sichtbarkeit
function toggleLayerVisibility(indexToToggle) {
    if (indexToToggle < 0 || indexToToggle >= layers.length) { /* ... */ return; }

    recordStateForUndo(); // Zustand VOR der Sichtbarkeitsänderung sichern

    const layer = layers[indexToToggle];
    layer.isVisible = !layer.isVisible;

    // WENN DER AKTIVE LAYER AUSGEBLENDET WIRD, AUSWAHL AUFHEBEN
    if (indexToToggle === activeLayerIndex && !layer.isVisible) {
        activeLayerIndex = -1; // Auswahl aufheben
        showNotification('Aktiver Layer wurde ausgeblendet. Auswahl aufgehoben.', 'info', 2500);
    }

    redrawAll();
    showNotification(`Sichtbarkeit für Layer "${layer.label || `Layer ${indexToToggle + 1}`}" ${layer.isVisible ? 'aktiviert' : 'deaktiviert'}.`, 'info');
}
// --- PROJEKT SPEICHERN ---
function getProjectData() {
    const projectData = {
        baseImageSrc: baseImage ? baseImage.src : null,
        baseImageOriginalName: baseImage ? baseImage.originalName : null,
        layers: layers.map(layer => ({
            src: layer.image.src, // Speichere die Quelle des Bildes
            x: layer.x,
            y: layer.y,
            scale: layer.scale,
            label: layer.label,
            isVisible: layer.isVisible,
            // Original width/height werden beim Laden des Bildes neu gesetzt,
            // daher müssen sie nicht zwingend gespeichert werden, es sei denn,
            // die Layer-Quellen sind nicht immer direkt zugänglich.
            // Für Bilder, die direkt geladen werden, ist src ausreichend.
        })),
        activeLayerIndex: activeLayerIndex,
        downloadFilename: downloadFilenameInput ? downloadFilenameInput.value : ""
    };
    return projectData;
}

// Funktion zum Stoppen des Kamerastreams
function stopCameraStream() {
    if (currentCameraStream) {
        currentCameraStream.getTracks().forEach(track => track.stop());
        currentCameraStream = null;
        if (cameraFeed) cameraFeed.srcObject = null; // Wichtig, um die Kamera freizugeben
        console.log("Kamerastream gestoppt.");
    }
    if (cameraOverlayCtx && cameraOverlayCanvas) { // Overlay leeren
        console.log("[stopCameraStream] Versuche clearRect."); // DEBUG
        try {
            cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);
        } catch (e) {
            console.error("[stopCameraStream] Fehler bei clearRect:", e, "cameraOverlayCtx war:", cameraOverlayCtx); // DEBUG
        }
    }
    overlayAction = null; // Wichtig: Aktion zurücksetzen, wenn Stream gestoppt wird
    if (cameraOverlaySelect) cameraOverlaySelect.value = "-1"; // Auswahl zurücksetzen
    overlayLayerInstance = null;
    selectedOverlayLayerIndex = -1;
    // Auflösungsbuttons ausblenden, wenn Stream gestoppt wird
    if (resolutionButtonsContainer) resolutionButtonsContainer.style.display = 'none';
    console.log("Kamerastream gestoppt und Overlay-Kontext ggf. behandelt.");
}
// Funktion zum Füllen des Overlay-Auswahl-Dropdowns
function populateCameraOverlaySelect() {
    if (!cameraOverlaySelect || !layers) { // Prüfe auch, ob 'layers' existiert
        if (cameraOverlaySelect) cameraOverlaySelect.innerHTML = '<option value="-1">Keine Layer verfügbar</option>';
        return;
    }
    const previouslySelectedValue = cameraOverlaySelect.value; // Um Auswahl beizubehalten
    cameraOverlaySelect.innerHTML = '<option value="-1">Kein Overlay</option>'; // Standardoption

    console.log("Populating overlay select with layers:", layers); // DEBUG

    layers.forEach((layer, index) => {
        // Optional: Nur sichtbare Layer als Overlay anbieten oder alle
        // if (layer.isVisible) {
            const option = document.createElement('option');
            option.value = index.toString(); // Der Wert ist der Index im globalen 'layers'-Array
            option.textContent = layer.label || `Layer ${index + 1}`;
            cameraOverlaySelect.appendChild(option);
        // }
    });
    // Versuche, die vorherige Auswahl wiederherzustellen
    if (Array.from(cameraOverlaySelect.options).some(opt => opt.value === previouslySelectedValue)) {
        cameraOverlaySelect.value = previouslySelectedValue;
    } else {
        // cameraOverlaySelect.value = "-1"; // Fallback auf "Kein Overlay"
        selectedOverlayLayerIndex = -1;
        // overlayLayerInstance = null;
    }
    // Trigger das Zeichnen des Overlays basierend auf der aktuellen Auswahl
    handleOverlaySelection();
}

// Funktion zum Zeichnen des Overlay-Layers
// js/main.js
// ... (globale Variablen, andere Funktionen) ...

// 1. drawCameraOverlay: Zeichnet das overlayLayerInstance auf das cameraOverlayCanvas
//    Diese Funktion verwendet die aktuellen x, y, scale des overlayLayerInstance.
// function drawCameraOverlay() {
//      console.log("[drawCameraOverlay] Beginn. cameraOverlayCtx:", cameraOverlayCtx, "cameraOverlayCanvas:", cameraOverlayCanvas); // DEBUG
//     if (!cameraOverlayCanvas || !cameraOverlayCtx || !cameraFeed.srcObject || cameraFeed.videoWidth === 0) {
//         if (cameraOverlayCtx && cameraOverlayCanvas) {
//             console.log("[drawCameraOverlay] Bedingungen nicht voll erfüllt, aber Ctx existiert. Versuche clearRect."); // DEBUG
//             cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);
//             try {
//                 cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);
//             } catch (e) {
//                 console.error("[drawCameraOverlay] Fehler bei clearRect im Bedingungsblock:", e, "cameraOverlayCtx war:", cameraOverlayCtx); // DEBUG
//             }
//         }
//         return;
//     }

//     // Synchronisiere Canvas-Größe mit Video-Feed-Größe
//     if (cameraOverlayCanvas.width !== cameraFeed.videoWidth || cameraOverlayCanvas.height !== cameraFeed.videoHeight) {
//         cameraOverlayCanvas.width = cameraFeed.videoWidth;
//         cameraOverlayCanvas.height = cameraFeed.videoHeight;
//     }
// cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);
//     console.log("[drawCameraOverlay] Vor Haupt-clearRect. cameraOverlayCtx:", cameraOverlayCtx); // DEBUG
//     try {
//         cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);
//     } catch (e) {
//         console.error("[drawCameraOverlay] Fehler bei Haupt-clearRect:", e, "cameraOverlayCtx war:", cameraOverlayCtx); // DEBUG
//         return; // Verlasse die Funktion, wenn clearRect fehlschlägt
//     }

//     if (overlayLayerInstance && overlayLayerInstance.isVisible) {
//         const layerToDraw = overlayLayerInstance; // Der Klon, der interaktiv angepasst wird
//         const bounds = layerToDraw.getScaledSize(); // Holt width * scale, height * scale

//         cameraOverlayCtx.globalAlpha = 0.7; // Einstellbare Deckkraft für das Overlay
//         cameraOverlayCtx.drawImage(
//             layerToDraw.image,
//             layerToDraw.x,     // Die aktuelle x-Position des Overlay-Klons
//             layerToDraw.y,     // Die aktuelle y-Position des Overlay-Klons
//             bounds.width,      // Die aktuelle skalierte Breite des Overlay-Klons
//             bounds.height      // Die aktuelle skalierte Höhe des Overlay-Klons
//         );
//         cameraOverlayCtx.globalAlpha = 1.0;

//         // Optional: Handles für das Overlay zeichnen, wenn es "aktiv" ist (z.B. während overlayAction)
//         if (overlayAction) { // Oder ein anderer Indikator
//             const corners = {
//                 tl: { x: layerToDraw.x, y: layerToDraw.y },
//                 tr: { x: layerToDraw.x + bounds.width, y: layerToDraw.y },
//                 bl: { x: layerToDraw.x, y: layerToDraw.y + bounds.height },
//                 br: { x: layerToDraw.x + bounds.width, y: layerToDraw.y + bounds.height }
//             };
//             cameraOverlayCtx.fillStyle = "rgba(0, 0, 255, 0.5)"; // Blaue Handles für Overlay
//             // HANDLE_SIZE muss definiert sein (wahrscheinlich aus config.js)
//             for (const pt of Object.values(corners)) {
//                 cameraOverlayCtx.fillRect(pt.x - HANDLE_SIZE / 2, pt.y - HANDLE_SIZE / 2, HANDLE_SIZE, HANDLE_SIZE);
//             }
//         }
//         // Optional: Handles für das Overlay zeichnen, wenn es "aktiv" ist
//         if (overlayAction === "move" /* || overlayAction === "pinch" || ist_overlay_selektiert_flag */) {
//             const layerToDraw = overlayLayerInstance;
//             const bounds = layerToDraw.getScaledSize();
//             const corners = { /* ... Ecken berechnen ... */ };
//             cameraOverlayCtx.fillStyle = "rgba(0, 150, 255, 0.6)"; // Andere Farbe für Overlay-Handles
//             // HANDLE_SIZE muss definiert sein
//             for (const pt of Object.values(corners)) {
//                 cameraOverlayCtx.fillRect(pt.x - HANDLE_SIZE / 2, pt.y - HANDLE_SIZE / 2, HANDLE_SIZE, HANDLE_SIZE);
//             }
//         }
//     }
// }

function drawCameraOverlay() {
    if (!cameraOverlayCanvas || !cameraOverlayCtx || !cameraFeed.srcObject || cameraFeed.videoWidth === 0) {
        if (cameraOverlayCtx && cameraOverlayCanvas) {
            cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);
        }
        return;
    }

    // Synchronisiere Canvas-Größe mit Video-Feed-Größe
    if (cameraOverlayCanvas.width !== cameraFeed.videoWidth || cameraOverlayCanvas.height !== cameraFeed.videoHeight) {
        cameraOverlayCanvas.width = cameraFeed.videoWidth;
        cameraOverlayCanvas.height = cameraFeed.videoHeight;
    }

    cameraOverlayCtx.clearRect(0, 0, cameraOverlayCanvas.width, cameraOverlayCanvas.height);

    if (overlayLayerInstance && overlayLayerInstance.isVisible) {
        const layerToDraw = overlayLayerInstance;
        const bounds = layerToDraw.getScaledSize();

        cameraOverlayCtx.globalAlpha = 0.7;
        cameraOverlayCtx.drawImage(
            layerToDraw.image,
            layerToDraw.x,
            layerToDraw.y,
            bounds.width,
            bounds.height
        );
        cameraOverlayCtx.globalAlpha = 1.0;

        if (overlayAction) {
            const corners = {
                tl: { x: layerToDraw.x, y: layerToDraw.y },
                tr: { x: layerToDraw.x + bounds.width, y: layerToDraw.y },
                bl: { x: layerToDraw.x, y: layerToDraw.y + bounds.height },
                br: { x: layerToDraw.x + bounds.width, y: layerToDraw.y + bounds.height }
            };
            cameraOverlayCtx.fillStyle = "rgba(0, 0, 255, 0.5)";
            // HANDLE_SIZE muss hier verfügbar sein (global oder importiert)
            for (const pt of Object.values(corners)) {
                cameraOverlayCtx.fillRect(pt.x - HANDLE_SIZE / 2, pt.y - HANDLE_SIZE / 2, HANDLE_SIZE, HANDLE_SIZE);
            }
        }
    }
}

// 2. handleOverlaySelection: Setzt den overlayLayerInstance und positioniert ihn initial
function handleOverlaySelection() {
    if (!cameraOverlaySelect) return;
    selectedOverlayLayerIndex = parseInt(cameraOverlaySelect.value, 10);

    if (selectedOverlayLayerIndex !== -1 && layers[selectedOverlayLayerIndex]) {
        const originalLayer = layers[selectedOverlayLayerIndex];
        overlayLayerInstance = new Layer(originalLayer.image, originalLayer.x, originalLayer.y, originalLayer.label);
        overlayLayerInstance.scale = originalLayer.scale;
        overlayLayerInstance.isVisible = true;

        // INITIALE POSITIONIERUNG DES OVERLAYS:
        // Hier entscheiden wir, wie der Layer beim ersten Auswählen im Overlay erscheint.
        // Option A: Zentriert (einfach)
        const overlayBounds = overlayLayerInstance.getScaledSize();
        if (cameraOverlayCanvas && cameraOverlayCanvas.width > 0) {
            overlayLayerInstance.x = (cameraOverlayCanvas.width - overlayBounds.width) / 2;
            overlayLayerInstance.y = (cameraOverlayCanvas.height - overlayBounds.height) / 2;
        } else {
            overlayLayerInstance.x = 50; overlayLayerInstance.y = 50; // Fallback
        }
        console.log("Overlay-Layer ausgewählt und initial zentriert:", overlayLayerInstance.label);

        // Option B: Versuche, die relative Position vom Haupt-Canvas zu übertragen (komplexer)
        /*
        if (baseImage && canvas.width > 0 && cameraOverlayCanvas.width > 0) {
            const mainCanvasWidth = canvas.width;
            const mainCanvasHeight = canvas.height;
            const overlayWidth = cameraOverlayCanvas.width;
            const overlayHeight = cameraOverlayCanvas.height;

            const scaleXFactor = overlayWidth / mainCanvasWidth;
            const scaleYFactor = overlayHeight / mainCanvasHeight;
            const effectiveScaleFactor = Math.min(scaleXFactor, scaleYFactor);

            const scaledMainContentWidth = mainCanvasWidth * effectiveScaleFactor;
            const scaledMainContentHeight = mainCanvasHeight * effectiveScaleFactor;
            const offsetX = (overlayWidth - scaledMainContentWidth) / 2;
            const offsetY = (overlayHeight - scaledMainContentHeight) / 2;

            // Die Position und Größe des *Original-Layers*
            const olX = originalLayer.x;
            const olY = originalLayer.y;
            const olScaledWidth = originalLayer.width * originalLayer.scale;
            const olScaledHeight = originalLayer.height * originalLayer.scale;

            // Setze die Eigenschaften des *overlayLayerInstance*
            overlayLayerInstance.x = olX * effectiveScaleFactor + offsetX;
            overlayLayerInstance.y = olY * effectiveScaleFactor + offsetY;
            // Die Skalierung des overlayLayerInstance selbst sollte sich auf die *ursprüngliche* Layer-Skalierung beziehen,
            // aber die gerenderte Größe wird durch effectiveScaleFactor beeinflusst.
            // Um die *visuelle* Größe beizubehalten, müssen wir die Skalierung des Klons anpassen.
            // Dies ist der knifflige Teil: Wenn der Klon eine eigene `scale`-Eigenschaft hat,
            // die der Benutzer interaktiv ändert, wollen wir hier vielleicht die `originalLayer.scale`
            // als Basis nehmen und dann `effectiveScaleFactor` anwenden, um die visuelle Größe zu approximieren.
            // Fürs Erste behalten wir die Skalierung des Original-Layers und die Größe wird durch effectiveScaleFactor angepasst.
            // Die gerenderte Breite wäre dann (originalLayer.width * overlayLayerInstance.scale) * effectiveScaleFactor
            // Dies bedeutet, dass die getScaledSize() des overlayLayerInstance die Skalierung des Haupt-Layers
            // widerspiegelt und die effektive Skalierung auf dem Overlay-Canvas dann separat angewendet wird.
            // Einfacher ist es oft, die Skalierung des overlayLayerInstance so zu setzen, dass seine gerenderte Größe
            // im Overlay-Canvas der skalierten Größe des Original-Layers mal effectiveScaleFactor entspricht.
            // overlayLayerInstance.scale = originalLayer.scale; // Behalte die Original-Skalierung des Layers bei

            // Die gerenderte Breite im Overlay soll sein: (originalLayer.width * originalLayer.scale) * effectiveScaleFactor
            // Da overlayLayerInstance.getScaledSize().width = overlayLayerInstance.width * overlayLayerInstance.scale ist,
            // und overlayLayerInstance.width = originalLayer.width,
            // setzen wir overlayLayerInstance.scale = originalLayer.scale * effectiveScaleFactor
            // NEIN, das ist falsch, wenn der User die Skalierung des Overlays selbst ändern können soll.
            // Wir behalten die Skalierung des Original-Layers für den Klon bei.
            // Die `drawCameraOverlay` muss dann die `effectiveScaleFactor`-Logik anwenden,
            // WENN sie die Positionen vom Haupt-Canvas übertragen soll.
            // DA WIR JETZT ABER DAS OVERLAY INTERAKTIV MACHEN, IST ES BESSER,
            // DAS overlayLayerInstance HAT SEINE EIGENEN X,Y,SCALE relativ zum cameraOverlayCanvas.
            // Die initiale Positionierung kann komplexer sein, aber danach ist es einfach.

            console.log("Overlay-Layer ausgewählt und relativ positioniert:", overlayLayerInstance.label);
        } else { // Fallback auf Zentrierung, wenn keine Referenz
            const overlayBounds = overlayLayerInstance.getScaledSize();
            if (cameraOverlayCanvas && cameraOverlayCanvas.width > 0) {
                overlayLayerInstance.x = (cameraOverlayCanvas.width - overlayBounds.width) / 2;
                overlayLayerInstance.y = (cameraOverlayCanvas.height - overlayBounds.height) / 2;
            }
        }
        */

    } else {
        overlayLayerInstance = null;
    }
    drawCameraOverlay(); // Zeichne mit der initialen Position des Klons
}
// Event-Listener für die Auflösungsbuttons (muss nach DOM-Ready oder in initCameraSystem registriert werden)
function setupResolutionButtons() {
    if (resolutionButtonsContainer) {
        const resBtns = resolutionButtonsContainer.querySelectorAll('.resolution-btn');
        resBtns.forEach(btn => {
            btn.addEventListener('click', async () => {
                const newWidth = parseInt(btn.dataset.width, 10);
                const newHeight = parseInt(btn.dataset.height, 10);

                if (newWidth && newHeight && (newWidth !== currentRequestedWidth || newHeight !== currentRequestedHeight)) {
                    console.log(`Angeforderte neue Auflösung: ${newWidth}x${newHeight}`);
                    showNotification(`Versuche Auflösung: ${newWidth}x${newHeight}...`, 'info', 1500);

                    currentRequestedWidth = newWidth;
                    currentRequestedHeight = newHeight;

                    // Aktiviere den geklickten Button visuell (optional)
                    resBtns.forEach(b => b.classList.remove('active'));
                    btn.classList.add('active');

                    // Stream neu starten mit der aktuellen Kamera, aber neuer Auflösung
                    try {
                        let currentDevId = null;
                        if (availableVideoDevices.length > 0 && availableVideoDevices[currentDeviceIndex]) {
                            currentDevId = availableVideoDevices[currentDeviceIndex].deviceId;
                        }
                        await _startStream(currentDevId, newWidth, newHeight);
                        // Das Modal sollte bereits offen sein.
                    } catch (error) {
                        // Fehlerbehandlung, wenn die neue Auflösung nicht gesetzt werden konnte
                        // Die Fehlerbehandlung in _startStream sollte das meiste abdecken
                        showNotification(`Auflösung ${newWidth}x${newHeight} konnte nicht gesetzt werden.`, 'error');
                        // Setze ggf. auf vorherige Auflösung zurück oder einen Standard
                    }
                }
            });
        });
    }
}
// Diese Funktion wird jetzt nur noch von main.js aufgerufen, wenn sich die Projekt-Layer ändern
// oder wenn das Kamera-Modal geöffnet wird.
function populateCameraOverlaySelectWithProjectLayers() {
    if (!cameraOverlaySelect || !layers) {
        if (cameraOverlaySelect) cameraOverlaySelect.innerHTML = '<option value="-1">Keine Layer im Projekt</option>';
        handleOverlaySelection(); // Stellt sicher, dass overlayLayerInstance null ist
        return;
    }

    const previouslySelectedOverlayValue = cameraOverlaySelect.value; // Index als String
    cameraOverlaySelect.innerHTML = '<option value="-1">Kein Overlay</option>';

    layers.forEach((layer, index) => {
        // Optional: Nur sichtbare Layer als Overlay anbieten
        // if (layer.isVisible) {
            const option = document.createElement('option');
            option.value = index.toString(); // Wert ist der Index im `layers`-Array
            option.textContent = layer.label || `Layer ${index + 1}`;
            cameraOverlaySelect.appendChild(option);
        // }
    });

    if (Array.from(cameraOverlaySelect.options).some(opt => opt.value === previouslySelectedOverlayValue)) {
        cameraOverlaySelect.value = previouslySelectedOverlayValue;
    } else {
        cameraOverlaySelect.value = "-1"; // Kein Overlay, wenn vorheriges nicht mehr da
    }
    handleOverlaySelection(); // Aktualisiere das Overlay basierend auf der Auswahl
}
// Funktion zum Wechseln der Kamera
function switchCamera() {
    console.log("switchCamera Funktion aufgerufen."); // DEBUG
    if (!availableVideoDevices || availableVideoDevices.length <= 1) {
        console.log("Nicht genügend Kameras zum Wechseln vorhanden."); // DEBUG
        showNotification("Keine weitere Kamera zum Wechseln verfügbar.", "info");
        if (switchCameraBtn) switchCameraBtn.style.display = 'none'; // Button ausblenden, wenn nutzlos
        return;
    }

    currentDeviceIndex = (currentDeviceIndex + 1) % availableVideoDevices.length;
    const nextDevice = availableVideoDevices[currentDeviceIndex];

    if (!nextDevice || !nextDevice.deviceId) {
        console.error("Fehler: Nächstes Gerät oder dessen deviceId ist ungültig.", nextDevice);
        showNotification("Fehler beim Kamerawechsel.", "error");
        // Ggf. currentDeviceIndex zurücksetzen oder Kameraliste neu laden
        enumerateCameras().then(() => { // Versuche, die Liste zu aktualisieren
            if (availableVideoDevices.length > 1 && availableVideoDevices[0]) {
                currentDeviceIndex = 0;
                startCamera(availableVideoDevices[0].deviceId);
            }
        });
        return;
        console.log(`Wechsle zu Kamera: "${nextDevice.label}"`);
        showNotification(`Wechsle zu Kamera: ${nextDevice.label.split('(')[0].trim() || 'Nächste Kamera'}`, 'info', 2000);
        startCamera(nextDevice.deviceId);
    }

    console.log(`Wechsle zu Kamera: "${nextDevice.label}" (Index ${currentDeviceIndex}, ID: ${nextDevice.deviceId})`); // DEBUG
    showNotification(`Wechsle zu Kamera: ${nextDevice.label.split('(')[0].trim() || 'Nächste Kamera'}`, 'info', 2000);

    startCamera(nextDevice.deviceId); // Starte die Kamera mit der neuen deviceId
}
// In performLayerDelete (NACHDEM der Layer aus `layers` entfernt wurde):
function performLayerDeleteInternal(indexToDelete) { // Umbenannt, um Konflikt zu vermeiden
    // ... (Layer entfernen) ...
    redrawAll(); // Aktualisiert auch das Overlay-Dropdown
    showNotification(`Layer "${deletedLayerLabel}" erfolgreich gelöscht.`, 'success');
}
// Funktion zum Aufnehmen des Fotos
function takePhoto() {
    // if (!cameraFeed || !currentCameraStream || !photoCanvas) return;

    // const videoWidth = cameraFeed.videoWidth;
    // const videoHeight = cameraFeed.videoHeight;

    // if (videoWidth === 0 || videoHeight === 0) {
    //     showNotification("Kameravideo nicht bereit für Aufnahme.", "warning");
    //     return;
    // }

    // const photoCtx = photoCanvas.getContext('2d');
    // photoCanvas.width = videoWidth;
    // photoCanvas.height = videoHeight;

    // photoCtx.drawImage(cameraFeed, 0, 0, videoWidth, videoHeight);

    // // 2. Wenn ein Overlay-Layer aktiv ist, diesen DARÜBER auf dasselbe Aufnahme-Canvas zeichnen
    // //    mit derselben Logik wie in drawCameraOverlay
    // if (overlayLayerInstance && overlayLayerInstance.isVisible && baseImage) { // Benötigt baseImage
    //     const mainCanvasWidth = canvas.width;
    //     const mainCanvasHeight = canvas.height;
    //     const overlayWidth = photoCanvas.width; // Hier photoCanvas-Dimensionen verwenden
    //     const overlayHeight = photoCanvas.height;

    //     if (mainCanvasWidth > 0 && mainCanvasHeight > 0) { // Nur wenn Haupt-Canvas Dimensionen hat
    //         const scaleX = overlayWidth / mainCanvasWidth;
    //         const scaleY = overlayHeight / mainCanvasHeight;
    //         const effectiveScale = Math.min(scaleX, scaleY);

    //         const scaledMainWidth = mainCanvasWidth * effectiveScale;
    //         const scaledMainHeight = mainCanvasHeight * effectiveScale;
    //         const offsetX = (overlayWidth - scaledMainWidth) / 2;
    //         const offsetY = (overlayHeight - scaledMainHeight) / 2;

    //         const originalLayer = overlayLayerInstance;
    //         const originalLayerScaledWidth = originalLayer.width * originalLayer.scale;
    //         const originalLayerScaledHeight = originalLayer.height * originalLayer.scale;

    //         const overlayDrawX = originalLayer.x * effectiveScale + offsetX;
    //         const overlayDrawY = originalLayer.y * effectiveScale + offsetY;
    //         const overlayDrawWidth = originalLayerScaledWidth * effectiveScale;
    //         const overlayDrawHeight = originalLayerScaledHeight * effectiveScale;

    //         photoCtx.globalAlpha = 0.7; // Konsistente Transparenz
    //         photoCtx.drawImage(
    //             originalLayer.image,
    //             overlayDrawX,
    //             overlayDrawY,
    //             overlayDrawWidth,
    //             overlayDrawHeight
    //         );
    //         photoCtx.globalAlpha = 1.0;
    //         console.log("Overlay-Layer mit skalierten Optionen auf finales Foto gezeichnet.");
    //     } else {
    //          console.warn("Konnte Overlay nicht mit genauen Optionen auf Foto zeichnen, da Haupt-Canvas keine Dimensionen hat.");
    //     }

    // } else if (overlayLayerInstance && overlayLayerInstance.isVisible && !baseImage) {
    //     // Fallback: Zentriert zeichnen, wenn kein Basisbild für Referenz da ist
    //     const layerBounds = overlayLayerInstance.getCanvasBounds();
    //     const drawX = (photoCanvas.width - layerBounds.width) / 2;
    //     const drawY = (photoCanvas.height - layerBounds.height) / 2;
    //     photoCtx.globalAlpha = 0.7;
    //     photoCtx.drawImage(overlayLayerInstance.image, drawX, drawY, layerBounds.width, layerBounds.height);
    //     photoCtx.globalAlpha = 1.0;
    // }

    // // Bild als Data URL bekommen (oder als Blob, wenn du das bevorzugst)
    // const imageDataUrl = photoCanvas.toDataURL('image/jpeg', 0.9); // Qualität 0.9

    // // Hier musst du entscheiden, was mit imageDataUrl passieren soll.
    // // Am einfachsten ist es, es wie eine hochgeladene Datei zu behandeln.
    // // Wir können eine Pseudo-Datei erstellen und an handleFile übergeben.
    // fetch(imageDataUrl)
    //     .then(res => res.blob())
    //     .then(blob => {
    //         const timestamp = new Date().toISOString().replace(/[-:.]/g, "");
    //         const filename = `kamerafoto_${timestamp}.jpg`;
    //         const photoFile = new File([blob], filename, { type: 'image/jpeg' });
    //         handleFile(photoFile); // Deine bestehende Funktion zum Verarbeiten von Dateien

    //         showNotification("Foto aufgenommen und als Basisbild geladen!", "success");
    //     })
    //     .catch(err => {
    //         console.error("Fehler beim Erstellen der Fotodatei:", err);
    //         showNotification("Fehler beim Verarbeiten des Fotos.", "error");
    //     });


    // if (cameraModalInstance) {
    //     cameraModalInstance.hide(); // Modal nach Aufnahme schließen
    // }
    // // Der Stream wird gestoppt, wenn das Modal geschlossen wird (siehe unten)

    if (!cameraFeed || !currentCameraStream || !photoCanvas) {
        console.warn("processTakePhoto: Benötigte Elemente nicht bereit.");
        return;
    }

    const videoWidth = cameraFeed.videoWidth;
    const videoHeight = cameraFeed.videoHeight;

    if (videoWidth === 0 || videoHeight === 0) {
        showNotification("Kameravideo nicht bereit für Aufnahme.", "warning");
        return;
    }

    const photoCtx = photoCanvas.getContext('2d');
    photoCanvas.width = videoWidth;
    photoCanvas.height = videoHeight;

    // 1. Kamerabild (aktueller Frame vom Video) auf das photoCanvas zeichnen
    photoCtx.drawImage(cameraFeed, 0, 0, videoWidth, videoHeight);

    // 2. Wenn ein Overlay-Layer aktiv und sichtbar ist, diesen DARÜBER zeichnen
    if (overlayLayerInstance && overlayLayerInstance.isVisible) {
        const layerToDraw = overlayLayerInstance;
        // Hole die skalierten Dimensionen des Overlay-Layers
        // (basierend auf overlayLayerInstance.width/height und seiner eigenen .scale Eigenschaft)
        const overlayBounds = layerToDraw.getScaledSize();

        // Die x, y, width, height des overlayLayerInstance sind bereits
        // relativ zum cameraOverlayCanvas (das die gleichen Dimensionen wie photoCanvas hat).
        // Daher können wir sie direkt verwenden.
        photoCtx.globalAlpha = 0.7; // Behalte die Transparenz bei, die auch im Live-Overlay verwendet wurde (oder mache sie konfigurierbar)
        photoCtx.drawImage(
            layerToDraw.image,
            layerToDraw.x,         // X-Position des Overlays (wie im Live-Overlay eingestellt)
            layerToDraw.y,         // Y-Position des Overlays (wie im Live-Overlay eingestellt)
            overlayBounds.width,   // Skalierte Breite des Overlays
            overlayBounds.height   // Skalierte Höhe des Overlays
        );
        photoCtx.globalAlpha = 1.0; // globalAlpha zurücksetzen
        console.log("Interaktives Overlay mit seinen eigenen x, y, scale auf finales Foto gezeichnet.");
    }

    // 3. Bild als Data URL bekommen und weiterverarbeiten
    const imageDataUrl = photoCanvas.toDataURL('image/jpeg', 0.9); // Qualität 0.9

    fetch(imageDataUrl)
        .then(res => res.blob())
        .then(blob => {
            const timestamp = new Date().toISOString().replace(/[-:.]/g, "");
            const filename = `kamerafoto_${timestamp}.jpg`;
            const photoFile = new File([blob], filename, { type: 'image/jpeg' });

            handleFile(photoFile); // Übergib das aufgenommene Foto an deine Verarbeitungsfunktion

            // Die Benachrichtigung "Foto aufgenommen und als Basisbild geladen!"
            // sollte idealerweise von handleFile kommen, nachdem das Bild tatsächlich
            // als Basisbild gesetzt wurde. Hier nur eine allgemeine Erfolgsmeldung:
            showNotification("Foto erfolgreich aufgenommen!", "success");
        })
        .catch(err => {
            console.error("Fehler beim Erstellen der Fotodatei aus DataURL:", err);
            showNotification("Fehler beim Verarbeiten des aufgenommenen Fotos.", "error");
        });

    if (cameraModalInstance) {
        cameraModalInstance.hide(); // Modal nach Aufnahme schließen
        // Der Stream wird durch den 'hidden.bs.modal'-Listener gestoppt, den wir eingerichtet haben.
    }
}


async function ensureCameraPermissionsAndEnumerate() {
    if (initialCameraPermissionGranted && availableVideoDevices.length > 0) {
        // console.log("Berechtigungen bereits erteilt und Geräte bekannt.");
        return true; // Schnell zurück, wenn schon erledigt
    }

    console.log("Versuche, Kameraberechtigungen zu erhalten und Geräte aufzulisten...");
    let tempStream = null;
    try {
        // 1. Generischer Aufruf, um Berechtigungen zu triggern und Labels zu füllen
        //    Wir fragen nach 'environment', um die Chance auf die Rückkamera zu erhöhen.
        tempStream = await navigator.mediaDevices.getUserMedia({ video: { facingMode: "environment" } })
            .catch(async (e) => { // Fallback, wenn 'environment' fehlschlägt
                console.warn("Erster Versuch mit facingMode: 'environment' fehlgeschlagen, versuche video:true", e.message);
                return await navigator.mediaDevices.getUserMedia({ video: true });
            });

        initialCameraPermissionGranted = true; // Berechtigung wurde (wahrscheinlich) erteilt
        console.log("Temporärer Kamerastream für Berechtigungen erhalten.");

        // Wichtig: Temporären Stream sofort wieder stoppen!
        if (tempStream) {
            tempStream.getTracks().forEach(track => track.stop());
            console.log("Temporärer Kamerastream gestoppt.");
        }

        // 2. JETZT enumerateDevices aufrufen, die Labels sollten zuverlässiger sein
        return await enumerateCameras(); // enumerateCameras füllt availableVideoDevices

    } catch (err) {
        console.error("Fehler beim initialen Kamerazugriff oder Auflisten:", err.name, err.message);
        showNotification(`Kamerazugriff nicht möglich: ${err.name === 'NotAllowedError' ? 'Berechtigung verweigert.' : 'Keine Kamera gefunden.'}`, "error");
        initialCameraPermissionGranted = false; // Zurücksetzen, falls es fehlgeschlagen ist
        if (switchCameraBtn) switchCameraBtn.style.display = 'none';
        return false;
    }
}

// Funktion zum Auflisten und Vorbereiten der Kameras
async function enumerateCameras() {
    if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
        console.warn("enumerateDevices() wird nicht unterstützt.");
        if (switchCameraBtn) switchCameraBtn.style.display = 'none';
        return false;
    }
    try {
        const devices = await navigator.mediaDevices.enumerateDevices();
        availableVideoDevices = devices.filter(device => device.kind === 'videoinput');
        console.log("Verfügbare Videogeräte nach enumerateCameras:", availableVideoDevices.map(d => ({ label: d.label, id: d.deviceId.substring(0, 10) + "..." })));

        if (availableVideoDevices.length > 1) {
            if (switchCameraBtn) switchCameraBtn.style.display = 'inline-block'; // Button anzeigen
        } else {
            if (switchCameraBtn) switchCameraBtn.style.display = 'none'; // Button ausblenden
        }
        // Setze currentDeviceIndex auf die bevorzugte Rückkamera, falls vorhanden, sonst 0
        if (availableVideoDevices.length > 0) {
            const rearCamera = availableVideoDevices.find(
                device => device.label && (device.label.toLowerCase().includes('back') || device.label.toLowerCase().includes('rück'))
            );
            if (rearCamera) {
                currentDeviceIndex = availableVideoDevices.indexOf(rearCamera);
            } else {
                currentDeviceIndex = 0;
            }
        } else {
            currentDeviceIndex = -1;
        }
        return availableVideoDevices.length > 0;
    } catch (err) {
        console.error("Fehler beim Auflisten der Geräte:", err);
        if (switchCameraBtn) switchCameraBtn.style.display = 'none';
        return false;
    }
}
async function startCamera(deviceId = null, requestedWidth, requestedHeight) {
    console.log("startCamera aufgerufen mit deviceId Parameter:", deviceId); // GANZ OBEN HINZUFÜGEN

    if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
        const msg = "Kamerazugriff (getUserMedia) wird von diesem Browser nicht unterstützt.";
        console.error(msg);
        showNotification(msg, 'error');
        if (cameraErrorMsg) {
            cameraErrorMsg.textContent = msg;
            cameraErrorMsg.style.display = 'block';
        }
        return;
    }

    stopCameraStream(); // Wichtig: Alten Stream stoppen
    if (cameraErrorMsg) cameraErrorMsg.style.display = 'none';

    // Verwende die übergebenen oder die aktuellen Modul-weiten Auflösungswünsche
    const targetWidth = requestedWidth || currentRequestedWidth;
    const targetHeight = requestedHeight || currentRequestedHeight;
    let videoConstraintsConfig = { // videoConstraintsConfig statt videoConstraints
        // Gewünschte Auflösung (Beispiele)
        // Option 1: Idealwerte (Browser versucht, diese zu erreichen)
        width: { ideal: targetWidth }, // z.B. HD-Breite
        height: { ideal: targetHeight }, // z.B. HD-Höhe

        // Option 2: Mindestwerte
        // width: { min: 640 },
        // height: { min: 480 },

        // Option 3: Exakte Werte (vorsichtig verwenden!)
        // width: { exact: 1920 },
        // height: { exact: 1080 },

        // Option 4: Seitenverhältnis (Aspect Ratio)
        // aspectRatio: { ideal: 16/9 } // z.B. für Breitbild
    };

    let finalVideoConstraints = {}; // Um die zuletzt versuchten Constraints im Fehlerfall zu loggen
    let selectedDeviceDescription = "Standardauswahl / Unbekannt"; // Initialisiere mit einem Standardwert

    try {
        // if (deviceId && typeof deviceId === 'string') { // Prüft jetzt auch auf String
        //     console.log("Spezifische deviceId (String) wird verwendet:", deviceId);
        //     selectedDeviceForLog = `Spezifische ID: ${deviceId}`;
        //     finalVideoConstraints = { deviceId: { exact: deviceId }, ...videoConstraintsConfig };
        //     currentCameraStream = await navigator.mediaDevices.getUserMedia({ video: finalVideoConstraints });
        // } 
        // else if (deviceId) { // deviceId ist vorhanden, aber KEIN String -> das ist der Fehlerfall!
        //     console.error("FEHLER: startCamera wurde mit einer deviceId aufgerufen, die kein String ist!", deviceId);
        //     // Hier könntest du versuchen, die Logik für "keine deviceId übergeben" auszuführen oder einen Fehler werfen
        //     // Fürs Erste werfen wir einen Fehler, um das Problem klar zu machen.
        //     throw new Error("Ungültiger deviceId-Typ an startCamera übergeben.");
        // } 
        // else if (availableVideoDevices.length > 0) {
        //     // Bevorzugt Rückkamera, sonst erste verfügbare
        //     const rearCamera = availableVideoDevices.find(device => 
        //         device.label.toLowerCase().includes('back') || device.label.toLowerCase().includes('rück') ||
        //     (device.facingMode && device.facingMode === 'environment') // device.facingMode ist oft undefined hier
        //     );
        //     let preferredDevice = rearCamera || availableVideoDevices[0];

        //     // Stelle sicher, dass der currentDeviceIndex korrekt gesetzt wird,
        //     // bevor versucht wird, den Stream zu starten, falls switchCamera() den Index schon geändert hat.
        //     if (availableVideoDevices[currentDeviceIndex]) { // Prüfe, ob der Index gültig ist
        //          preferredDevice = availableVideoDevices[currentDeviceIndex];
        //     } 
        //     else if (rearCamera) {
        //          currentDeviceIndex = availableVideoDevices.indexOf(rearCamera);
        //          preferredDevice = rearCamera;
        //     } 
        //     else if (availableVideoDevices.length > 0) {
        //          currentDeviceIndex = 0;
        //          preferredDevice = availableVideoDevices[0];
        //     }
        //      // Stelle sicher, dass preferredDevice.deviceId ein STRING ist
        //     if (typeof preferredDevice.deviceId !== 'string') {
        //          console.error("FEHLER: preferredDevice.deviceId ist kein String!", preferredDevice);
        //          throw new Error("Ungültige deviceId von preferredDevice.");
        //     }


        //     console.log("Keine deviceId übergeben, verwende bevorzugtes/aktuelles Gerät:", preferredDevice.label, preferredDevice.deviceId);
        //     finalVideoConstraints = { deviceId: { exact: preferredDevice.deviceId }, ...videoConstraintsConfig };
        //     console.log("Versuche Kamera mit bevorzugtem Gerät:", preferredDevice.label, "Constraints:", JSON.stringify(finalVideoConstraints));
        //     currentCameraStream = await navigator.mediaDevices.getUserMedia({ video: finalVideoConstraints });
        // } 
        // else {
        //     // Keine Geräte bekannt, versuche Standard-Rückkamera, dann Standard-Frontkamera
        //     console.log("Keine spezifischen Geräte bekannt, versuche Rückkamera, dann Frontkamera.");
        //     finalVideoConstraints = { facingMode: "environment", ...videoConstraintsConfig };
        //     try {
        //         console.log("Versuche Kamera mit Constraints:", JSON.stringify({video: finalVideoConstraints}));
        //         currentCameraStream = await navigator.mediaDevices.getUserMedia({ video: finalVideoConstraints });
        //     } catch (eOuter) { // Erster Versuch mit "environment" fehlgeschlagen
        //         console.warn(`Versuch mit facingMode: "environment" fehlgeschlagen (${eOuter.name}: ${eOuter.message}). Versuche Standard-Videogerät.`);
        //         finalVideoConstraints = { ...videoConstraintsConfig }; // Ohne facingMode, nimmt Standard
        //         // fallbackVideoConstraints könnten hier auch verwendet werden, wenn sie andere Auflösungen haben
        //         // const fallbackVideoConstraints = { width: { ideal: 640 }, height: { ideal: 480 }};
        //         // finalVideoConstraints = fallbackVideoConstraints;
        //         console.log("Versuche Kamera mit Constraints:", JSON.stringify({video: finalVideoConstraints}));
        //         currentCameraStream = await navigator.mediaDevices.getUserMedia({ video: finalVideoConstraints }); // Zweiter Versuch (wahrscheinlich Frontkamera)
        //     }
        // }

        if (deviceId && typeof deviceId === 'string') {
            selectedDeviceDescription = `Spezifische ID: ${deviceId.substring(0, 10)}...`;
            finalVideoConstraints = { deviceId: { exact: deviceId }, ...videoConstraintsConfig };
        } else {
            // Keine deviceId übergeben -> versuche, die beste Standardkamera zu wählen
            if (availableVideoDevices.length > 0) {
                let preferredDevice = null;

                // Logik zur Auswahl der bevorzugten Kamera (Rückkamera zuerst)
                // 1. Versuche, eine Kamera mit "back" im Label zu finden
                preferredDevice = availableVideoDevices.find(
                    device => device.label && (device.label.toLowerCase().includes('back') || device.label.toLowerCase().includes('rück'))
                );

                if (preferredDevice) {
                    selectedDeviceDescription = `Bevorzugt 'back' im Label: "${preferredDevice.label}"`;
                } else if (availableVideoDevices[currentDeviceIndex]) {
                    // 2. Wenn nicht, nimm das Gerät am currentDeviceIndex, wenn es existiert
                    // (nützlich, wenn schon mal gewechselt wurde oder enumerateCameras einen Index gesetzt hat)
                    preferredDevice = availableVideoDevices[currentDeviceIndex];
                    selectedDeviceDescription = `Aktueller Index ${currentDeviceIndex}: "${preferredDevice.label}"`;
                } else if (availableVideoDevices.length > 0) {
                    // 3. Fallback zum ersten Gerät in der Liste
                    preferredDevice = availableVideoDevices[0];
                    selectedDeviceDescription = `Fallback: Erstes verfügb. Gerät: "${preferredDevice.label}"`;
                }


                if (preferredDevice && preferredDevice.deviceId) {
                    finalVideoConstraints = { deviceId: { exact: preferredDevice.deviceId }, ...videoConstraintsConfig };
                    // currentDeviceIndex wird nach erfolgreichem Stream-Start aktualisiert
                } else {
                    console.warn("Konnte kein bevorzugtes Gerät über Label/Index finden, versuche facingMode: 'environment'.");
                    selectedDeviceDescription = "Versuche facingMode: 'environment'";
                    finalVideoConstraints = { facingMode: "environment", ...videoConstraintsConfig };
                }
            } else {
                // Keine Geräte über enumerateDevices bekannt, Standard-Fallback mit facingMode
                console.warn("Keine Geräte über enumerateDevices bekannt, versuche Standard-facingMode.");
                selectedDeviceDescription = "Standard facingMode: 'environment'";
                finalVideoConstraints = { facingMode: "environment", ...videoConstraintsConfig };
            }
        }

        console.log("Starte Kamera mit finalen Constraints:", JSON.stringify({ video: finalVideoConstraints }), "Ausgewählt als:", selectedDeviceDescription);
        currentCameraStream = await navigator.mediaDevices.getUserMedia({ video: finalVideoConstraints });
        // Wenn wir hier sind und currentCameraStream gesetzt ist, war ein Versuch erfolgreich
        if (!currentCameraStream) {
            // Dieser Fall sollte durch die obigen try/catch abgedeckt sein, aber zur Sicherheit
            throw new Error("Konnte keinen Kamerastream erhalten nach mehreren Versuchen.");
        }

        if (cameraFeed && currentCameraStream) {
            cameraFeed.srcObject = currentCameraStream;
            await new Promise(resolve => {
                cameraFeed.onloadedmetadata = () => {
                    console.log("[onloadedmetadata] Ereignis ausgelöst."); // DEBUG
                    cameraFeed.play();
                    if (resolutionButtonsContainer) resolutionButtonsContainer.style.display = 'block';
                    if (cameraOverlayCanvas && !cameraOverlayCtx) { // Initialisiere Overlay-Context
                        cameraOverlayCtx = cameraOverlayCanvas.getContext('2d');
                    }
                    if (cameraOverlayCanvas) { // Prüfe, ob das Canvas-Element existiert
                        if (!cameraOverlayCtx) { // Initialisiere nur, wenn noch nicht geschehen
                            cameraOverlayCtx = cameraOverlayCanvas.getContext('2d');
                            console.log("[onloadedmetadata] cameraOverlayCtx initialisiert:", cameraOverlayCtx); // DEBUG
                        }
                        // Stelle sicher, dass das Overlay-Canvas die korrekten Dimensionen hat
                        if (cameraOverlayCanvas.width !== cameraFeed.videoWidth || cameraOverlayCanvas.height !== cameraFeed.videoHeight) {
                            cameraOverlayCanvas.width = cameraFeed.videoWidth;
                            cameraOverlayCanvas.height = cameraFeed.videoHeight;
                        }
                    } else {
                        console.error("[onloadedmetadata] cameraOverlayCanvas Element nicht gefunden!");
                    }
                    populateCameraOverlaySelect(); // Fülle das Dropdown, wenn der Stream bereit ist
                    // drawCameraOverlay(); // Zeichne initiales Overlay (wird "Kein Overlay" sein)
                    const track = currentCameraStream.getVideoTracks()[0];
                    if (track && track.getSettings) {
                        const settings = track.getSettings();
                        const activeDeviceId = settings.deviceId;
                        const activeLabel = availableVideoDevices.find(d => d.deviceId === activeDeviceId)?.label || 'Unbekannt';
                        console.log(`Kamerastream gestartet. Aktives Gerät ID: ${activeDeviceId ? activeDeviceId.substring(0, 10) + '...' : 'N/A'}, Label: "${activeLabel}", Auflösung: ${settings.width}x${settings.height}, FacingMode: ${settings.facingMode || 'N/A'}`);
                        showNotification(`Kamera aktiv: ${settings.width}x${settings.height} (${settings.facingMode || 'N/A'})`, 'info', 2500);

                        if (activeDeviceId && availableVideoDevices.length > 0) {
                            const foundIndex = availableVideoDevices.findIndex(device => device.deviceId === activeDeviceId);
                            if (foundIndex !== -1) {
                                currentDeviceIndex = foundIndex;
                                console.log("currentDeviceIndex aktualisiert auf:", currentDeviceIndex);
                            } else {
                                console.warn("Aktive deviceId nicht in bekannter Liste. currentDeviceIndex nicht zuverlässig aktualisiert.");
                            }
                        }
                    }
                    resolve();
                };
            });
        }

        if (cameraModalInstance && !cameraModalInstance._isShown) {
            cameraModalInstance.show();
        }

    } catch (err) { // Äußerer Catch-Block für alle nicht abgefangenen Fehler
        // Fallback-Logik, falls der erste Versuch mit den ermittelten Constraints fehlschlägt
        // Dies ist besonders relevant, wenn KEINE deviceId übergeben wurde (initialer Start)
        // und der Versuch mit facingMode oder einer (vielleicht falsch) abgeleiteten deviceId fehlschlägt.
        if (!deviceId && (err.name === 'OverconstrainedError' || err.name === 'NotFoundError' || err.name === 'NotReadableError' || err.name === 'AbortError')) {
            console.warn(`Kameraversuch mit Constraints '${JSON.stringify(finalVideoConstraints)}' fehlgeschlagen (${err.name}). Versuche allgemeine Video-Constraints (video: true).`);
            // console.error("Fehler beim Zugriff auf die Kamera (äußerer Catch):", err.name, err.message, "Versuchte Constraints:", finalVideoConstraints);

            selectedDeviceDescription = "Allgemeiner Fallback (video: true)"; // Update für Logging
            finalVideoConstraints = { video: true }; // Einfach irgendeine Kamera
            try {
                currentCameraStream = await navigator.mediaDevices.getUserMedia(finalVideoConstraints); // KEIN {video: finalVideoConstraints} hier!
                if (!currentCameraStream) throw new Error("Fallback-Kamerastream ist null.");

                // Erneut srcObject etc. setzen
                if (cameraFeed) {
                    cameraFeed.srcObject = currentCameraStream;
                    cameraFeed.onloadedmetadata = () => {
                        cameraFeed.play();
                        const track = currentCameraStream.getVideoTracks()[0];
                        if (track && track.getSettings) { // Logge auch hier die Infos
                            const settings = track.getSettings();
                            const activeDeviceId = settings.deviceId;
                            const activeLabel = availableVideoDevices.find(d => d.deviceId === activeDeviceId)?.label || 'Unbekannt';
                            console.log(`FALLBACK Kamerastream gestartet. Aktives Gerät ID: ${activeDeviceId ? activeDeviceId.substring(0, 10) + '...' : 'N/A'}, Label: "${activeLabel}", Auflösung: ${settings.width}x${settings.height}, FacingMode: ${settings.facingMode || 'N/A'}`);
                            showNotification(`Kamera aktiv (Fallback): ${settings.width}x${settings.height}`, 'info', 2500);
                            if (activeDeviceId && availableVideoDevices.length > 0) {
                                currentDeviceIndex = availableVideoDevices.findIndex(device => device.deviceId === activeDeviceId);
                                if (currentDeviceIndex === -1) currentDeviceIndex = 0;
                            }
                        }
                    };
                }
                if (resolutionButtonsContainer) resolutionButtonsContainer.style.display = 'block';
                if (cameraModalInstance && !cameraModalInstance._isShown) { cameraModalInstance.show(); }
                return; // Wichtig: Erfolgreichen Fallback nicht in den äußeren Catch laufen lassen
            } catch (fallbackErr) {
                console.error("Auch der allgemeinste Fallback-Kameraversuch ist fehlgeschlagen:", fallbackErr.name, fallbackErr.message);
                err = fallbackErr; // Setze err auf den Fehler des Fallbacks für die allgemeine Fehlermeldung unten
            }
        }
        console.error("Fehler beim Zugriff auf die Kamera (finaler Catch):", err.name, err.message, "Zuletzt versuchte Constraints:", JSON.stringify(finalVideoConstraints), "Ausgewählt als:", selectedDeviceDescription);
        let userFriendlyMessage = "Kamerazugriff fehlgeschlagen.";
        if (err.name === 'NotAllowedError') {
            userFriendlyMessage = "Berechtigung für Kamerazugriff verweigert.";
        } else if (err.name === 'NotFoundError' || err.name === 'DevicesNotFoundError') {
            userFriendlyMessage = "Keine passende Kamera gefunden.";
        } else if (err.name === 'NotReadableError' || err.name === 'TrackStartError') {
            userFriendlyMessage = "Kamera wird bereits verwendet oder kann nicht gelesen werden.";
        } else if (err.name === 'OverconstrainedError') {
            // err.constraint gibt den problematischen Constraint an
            userFriendlyMessage = `Die angeforderte Kameraeinstellung wird nicht unterstützt. ${err.constraint ? '(' + err.constraint + ')' : ''}`;
        } else if (err.message.includes("Failed to allocate video source")) { // Spezifischer Fehlertext
            userFriendlyMessage = "Kamera konnte nicht initialisiert werden (möglicherweise bereits verwendet).";
        } else {
            userFriendlyMessage = `Unerwarteter Kamerafehler: ${err.message.substring(0, 100)}`; // Gekürzte Nachricht
        }
        showNotification(userFriendlyMessage, 'error', 5000); // Längere Anzeige für Kamerafehler
        if (cameraErrorMsg) {
            cameraErrorMsg.textContent = userFriendlyMessage;
            cameraErrorMsg.style.display = 'block';
        }
        stopCameraStream(); // Wichtig, um Ressourcen freizugeben
    }
}

async function applyProjectData(projectData, loadedFilename) {
    // Altes Projekt zurücksetzen
    baseImage = null;
    layers = [];
    activeLayerIndex = -1;
    if (downloadFilenameInput) {
        downloadFilenameInput.value = projectData.downloadFilename || "";
    }
    // Setze den Projektnamen-Input-Feld basierend auf dem geladenen Dateinamen
    if (projectFilenameInput && loadedFilename) {
        let projectName = loadedFilename;
        if (projectName.toLowerCase().endsWith('.json')) {
            projectName = projectName.substring(0, projectName.lastIndexOf('.'));
        }
        projectFilenameInput.value = projectName;
    } else if (projectFilenameInput) {
        projectFilenameInput.value = ""; // Leeren, falls kein Filename übergeben wurde
    }

    // Canvas leeren, falls nötig (wird durch redrawAll erledigt)
    if (canvas) { // Sicherstellen, dass canvas initialisiert ist
        canvas.width = canvas.width; // Einfacher Weg, Canvas zu leeren und Reset
    }


    // Lade Basisbild (asynchron)
    const baseImagePromise = new Promise((resolve, reject) => {
        if (projectData.baseImageSrc) {
            const newBaseImg = new Image();
            newBaseImg.originalName = projectData.baseImageOriginalName || 'basisbild';
            newBaseImg.onload = () => {
                baseImage = newBaseImg;
                canvas.width = baseImage.width;
                canvas.height = baseImage.height;
                displayBaseImageSize(baseImage.naturalWidth, baseImage.naturalHeight);
                resolve();
            };
            newBaseImg.onerror = () => {
                showNotification('Basisbild aus Projektdatei konnte nicht geladen werden.', 'warning');
                reject(new Error('Basisbild konnte nicht geladen werden'));
            };
            newBaseImg.src = projectData.baseImageSrc;
        } else {
            displayBaseImageSize(null, null);
            resolve(); // Kein Basisbild zu laden
        }
    });

    try {
        await baseImagePromise; // Warte, bis das Basisbild geladen ist (oder nicht vorhanden)
    } catch (error) {
        console.warn(error.message);
        // Basisbild konnte nicht geladen werden, aber wir versuchen trotzdem, die Layer zu laden.
        // Canvas hat dann ggf. Standardgröße oder keine Größe, was zu Problemen führen kann.
        // Alternativ hier abbrechen oder Standard-Canvas-Größe setzen.
        if (canvas && (canvas.width === 0 || canvas.height === 0)) {
            // Fallback Canvas Größe, wenn Basisbild fehlt
            // canvas.width = 800; canvas.height = 600;
            // showNotification('Basisbild fehlt, Canvas auf Standardgröße.', 'info');
        }
    }


    // Lade Layer (asynchron, da Bilder geladen werden müssen)
    const layerPromises = projectData.layers.map(layerData => {
        return new Promise((resolve, reject) => {
            const img = new Image();
            img.onload = () => {
                const newLayer = new Layer(img, layerData.x, layerData.y, layerData.label);
                newLayer.scale = layerData.scale;
                newLayer.isVisible = layerData.isVisible !== undefined ? layerData.isVisible : true; // Fallback
                layers.push(newLayer);
                resolve();
            };
            img.onerror = () => {
                showNotification(`Layer-Bild "${layerData.label || layerData.src}" konnte nicht geladen werden.`, 'warning');
                // Layer wird übersprungen, aber wir rejecten nicht den gesamten Promise,
                // damit andere Layer noch geladen werden können.
                resolve(); // Auflösen, um mit anderen Layern fortzufahren
            };
            img.src = layerData.src;
        });
    });

    await Promise.allSettled(projectData, layerPromises); // Warte, bis alle Layer-Bilder geladen (oder fehlgeschlagen) sind

    activeLayerIndex = (projectData.activeLayerIndex !== undefined && projectData.activeLayerIndex < layers.length)
        ? projectData.activeLayerIndex
        : (layers.length > 0 ? 0 : -1);

    redrawAll();
}

async function loadFonts() {
    if (document.fonts) { // Prüfen, ob die API unterstützt wird
        try {
            // 'Material Icons' muss dem font-family Namen in deiner @font-face Regel entsprechen
            await document.fonts.load('24px "Material Icons"'); // Größe ist optional, aber kann helfen
            console.log('Material Icons font loaded.');
        } catch (error) {
            console.error('Error loading Material Icons font:', error);
            // Hier könntest du entscheiden, trotzdem fortzufahren oder eine Fehlermeldung anzuzeigen
        }
    } else {
        console.warn('CSS Font Loading API not supported. Cannot guarantee font load before hiding loader.');
        // Fallback: Kurze Verzögerung, um dem Font etwas Zeit zu geben (nicht ideal)
        await new Promise(resolve => setTimeout(resolve, 500));
    }
}
async function initializeApp() {
    showLoader(); // Loader direkt am Anfang anzeigen
    // initUIController(setActiveLayer, deleteLayer, toggleLayerVisibility);
    initUIController(
        setActiveLayer,
        handleDeleteLayerRequest,
        toggleLayerVisibility,
        moveLayerUp,      // NEU
        moveLayerDown,     // NEU
        null,             // dragStartCallback (optional, hier nicht implementiert)
        moveLayerByIndex  // dropCallback
    );
    updateUndoRedoButtons(); // Initialer Zustand der Buttons
    setupResolutionButtons();
    // Erstelle die Modal-Instanz hier, wenn das Element existiert
    if (confirmResetModalElement) {
        confirmResetModalInstance = new bootstrap.Modal(confirmResetModalElement, {
            keyboard: false // Optional: Verhindert Schließen mit ESC-Taste
            // backdrop: 'static' // Optional: Verhindert Schließen durch Klick außerhalb
        });
    }
    if (confirmDeleteLayerModalElement) { // NEUES MODAL
        confirmDeleteLayerModalInstance = new bootstrap.Modal(confirmDeleteLayerModalElement);
    }
    if (cameraModalElement) {
        cameraModalInstance = new bootstrap.Modal(cameraModalElement);
        // Event Listener, um den Stream zu stoppen, wenn das Modal geschlossen wird
        cameraModalElement.addEventListener('hidden.bs.modal', () => {
            stopCameraStream();
            if (resolutionButtonsContainer) resolutionButtonsContainer.style.display = 'none';
            if (cameraOverlaySelect) cameraOverlaySelect.value = "-1"; // Reset Dropdown
            overlayLayerInstance = null; // Reset Overlay
            overlayAction = null; // Wichtig: Overlay-Aktion zurücksetzen
        });
    }
setupOverlayCanvasInteractions();


    let fontsLoadedSuccessfully = false;
    let layerOptionsLoadedSuccessfully = false;
    try {
        const results = await Promise.allSettled([ // Promise.allSettled, um beide Ergebnisse zu bekommen, auch wenn eines fehlschlägt
            loadFonts(),
            fetchLayerOptionsFromServer().then(data => {
                populateLayerSelectWithOptions(data);
                return data; // Wichtig, um die Daten weiterzugeben
            })
        ]);

        // Ergebnis von loadFonts prüfen
        if (results[0].status === 'fulfilled' && results[0].value) { // Annahme: loadFonts gibt true bei Erfolg zurück
            fontsLoadedSuccessfully = true;
        } else if (results[0].status === 'rejected') {
            console.error("Fehler beim Laden der Fonts:", results[0].reason);
            // showNotification wurde ggf. schon in loadFonts() aufgerufen
        }

        // Ergebnis von fetchLayerOptionsFromServer prüfen
        if (results[1].status === 'fulfilled' && results[1].value) {
            layerOptionsLoadedSuccessfully = true;
            // Erfolgsmeldung für Layer-Optionen
            showNotification('Anwendung initialisiert und Layer-Optionen geladen!', 'success', 2000);
        } else if (results[1].status === 'rejected') {
            const errorMessage = `Initialisierungsfehler: Layer-Optionen konnten nicht geladen werden. (${results[1].reason.message || results[1].reason})`;
            console.error(errorMessage, results[1].reason);
            showNotification(errorMessage, 'error', 7000);
        }
    } catch (error) {
        const errorMessage = `Initialisierungsfehler: Layer-Optionen konnten nicht geladen werden. (${error.message})`;
        console.error(errorMessage, error);
        showNotification(errorMessage, 'error', 7000); // Längere Anzeige bei kritischen Fehlern
    }

    updateLayerList(layers, activeLayerIndex);
    if (uploadProgressContainer) uploadProgressContainer.style.display = 'none';
    console.log("App initialisiert (Fonts geladen: " + fontsLoadedSuccessfully + ", Layer-Optionen geladen: " + layerOptionsLoadedSuccessfully + ").");

    // Am Ende der Initialisierung (oder nach einer kleinen Verzögerung für den Effekt)
    // den Loader ausblenden und den App-Inhalt anzeigen.
    // Eine kleine Verzögerung kann manchmal netter aussehen, wenn das Laden sehr schnell geht.
    // setTimeout(hideLoaderAndShowApp, 300); // z.B. 300ms Verzögerung
    hideLoaderAndShowApp(); // Oder direkt

    if ('serviceWorker' in navigator) {
        window.addEventListener('load', () => { // Stelle sicher, dass die Seite geladen ist
            navigator.serviceWorker.register('./sw.js') // Pfad zu deiner sw.js Datei
                .then(registration => {
                    console.log('ServiceWorker: Registrierung erfolgreich, Scope ist:', registration.scope);
                })
                .catch(error => {
                    console.error('ServiceWorker: Registrierung fehlgeschlagen:', error);
                });
        });
    } else {
        console.log('ServiceWorker nicht unterstützt in diesem Browser.');
    }
}


// Event Listener für den normalen Datei-Input (bleibt bestehen)
if (imageUpload) {
    imageUpload.addEventListener("change", e => {
        if (e.target.files && e.target.files[0]) {
            handleFile(e.target.files[0]);
        }
    });
}

// Drag & Drop Event Listener für die Drop-Zone
if (dropZone) {
    // Verhindert Standardverhalten des Browsers (Datei im Browser öffnen)
    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
        dropZone.addEventListener(eventName, preventDefaults, false);
        document.body.addEventListener(eventName, preventDefaults, false); // Für den Fall, dass außerhalb gedroppt wird
    });

    function preventDefaults(e) {
        e.preventDefault();
        e.stopPropagation();
    }

    // Hervorheben der Drop-Zone beim Darüberziehen
    ['dragenter', 'dragover'].forEach(eventName => {
        dropZone.addEventListener(eventName, () => dropZone.classList.add('dragover'), false);
    });

    ['dragleave', 'drop'].forEach(eventName => {
        dropZone.addEventListener(eventName, () => dropZone.classList.remove('dragover'), false);
    });

    // Verarbeiten der gedroppten Datei
    dropZone.addEventListener('drop', handleDrop, false);

    function handleDrop(e) {
        const dt = e.dataTransfer;
        const files = dt.files;

        if (files && files.length > 0) {
            handleFile(files[0]); // Verarbeite nur die erste Datei
        } else {
            // Ggf. Daten aus dt.items versuchen zu lesen, falls es keine "files" sind
            // (z.B. wenn ein Bild direkt aus einer Webseite gezogen wird)
            // Das ist komplexer und hier erstmal nicht implementiert.
            console.log("Keine Dateien im Drop-Event gefunden, prüfe items...");
        }
    }
}
// Event Listener für Undo/Redo Buttons
if (undoBtn) undoBtn.addEventListener('click', undo);
if (redoBtn) redoBtn.addEventListener('click', redo);
if (saveProjectBtn) {
    saveProjectBtn.addEventListener('click', () => {
        const projectData = getProjectData();
        const jsonData = JSON.stringify(projectData, null, 2);
        const blob = new Blob([jsonData], { type: 'application/json' });
        const url = URL.createObjectURL(blob);
        const link = document.createElement('a');

        // Dateinamen generieren basierend auf dem neuen Input-Feld
        let projectFilename = "canvas_projekt.json"; // Standardname
        if (projectFilenameInput && projectFilenameInput.value.trim()) {
            let userInput = projectFilenameInput.value.trim();
            // Entferne ungültige Zeichen für Dateinamen (einfache Variante)
            userInput = userInput.replace(/[<>:"/\\|?*]+/g, '_');
            // Stelle sicher, dass es mit .json endet
            if (!userInput.toLowerCase().endsWith('.json')) {
                projectFilename = userInput + ".json";
            } else {
                projectFilename = userInput;
            }
        }

        link.download = projectFilename;
        link.href = url;
        link.click();
        URL.revokeObjectURL(url);
        showNotification('Projekt erfolgreich gespeichert!', 'success');
    });
}
// Event Listener für die neuen Buttons
if (startCameraBtn) {
    startCameraBtn.addEventListener('click', async () => { // Stelle sicher, dass es eine Arrow-Function ohne Parameter ist oder Parameter ignoriert werden
        console.log("startCameraBtn Klick! Argumente für startCamera() werden jetzt bestimmt."); // DEBUG
        const hasPermissionAndDevices = await ensureCameraPermissionsAndEnumerate();
        // const camerasAvailable = await enumerateCameras();
        if (hasPermissionAndDevices) {
            startCamera(); // KORREKT: Ruft startCamera ohne Argument auf (oder mit null)
        } else {
            showNotification("Keine Kameras gefunden.", "warning");
        }
    });
}
// Event Listener für den Kamera-Wechsel-Button
if (switchCameraBtn) {
    switchCameraBtn.addEventListener('click', switchCamera); // <<< HIER WIRD DER LISTENER REGISTRIERT
    console.log("Event Listener für #switchCameraBtn registriert."); // DEBUG
} else {
    console.warn("#switchCameraBtn nicht im DOM gefunden bei Listener-Registrierung."); // DEBUG
}
if (takePhotoBtn) {
    takePhotoBtn.addEventListener('click', takePhoto);
}
// Event-Listener für die Auflösungsbuttons
if (resolutionButtonsContainer) {
    const resBtns = resolutionButtonsContainer.querySelectorAll('.resolution-btn');
    resBtns.forEach(btn => {
        btn.addEventListener('click', async () => {
            const newWidth = parseInt(btn.dataset.width, 10);
            const newHeight = parseInt(btn.dataset.height, 10);

            if (newWidth && newHeight && (newWidth !== currentRequestedWidth || newHeight !== currentRequestedHeight)) {
                showNotification(`Versuche Auflösung: ${newWidth}x${newHeight}...`, 'info', 1500);
                currentRequestedWidth = newWidth;
                currentRequestedHeight = newHeight;

                resBtns.forEach(b => b.classList.remove('active'));
                btn.classList.add('active');

                let currentDevId = null;
                if (availableVideoDevices.length > 0 && availableVideoDevices[currentDeviceIndex] && availableVideoDevices[currentDeviceIndex].deviceId) {
                    currentDevId = availableVideoDevices[currentDeviceIndex].deviceId;
                }

                try {
                    await startCamera(currentDevId, newWidth, newHeight);
                } catch (error) {
                    // Detaillierte Fehlerbehandlung ist in startCamera
                    // Hier ggf. nur Log oder eine spezifische UI-Reaktion, wenn der Auflösungswechsel selbst fehlschlägt
                    console.error("Fehler beim Setzen der neuen Auflösung über Button:", error);
                    // showNotification(`Auflösung ${newWidth}x${newHeight} konnte nicht final gesetzt werden.`, 'error');
                }
            }
        });
    });
}

// Listener für das Overlay-Dropdown
if (cameraOverlaySelect) {
    cameraOverlaySelect.addEventListener('change', handleOverlaySelection);
}

// --- PROJEKT LADEN ---
if (loadProjectInput) {
    loadProjectInput.addEventListener('change', (event) => {
        const file = event.target.files[0];
        if (!file) {
            return;
        }

        if (layers.length > 0 || baseImage) {
            if (!confirm("Möchten Sie das aktuelle Projekt verwerfen und ein neues laden? Alle nicht gespeicherten Änderungen gehen verloren.")) {
                loadProjectInput.value = ""; // Input zurücksetzen, um denselben File nochmal wählen zu können
                return;
            }
        }

        const reader = new FileReader();
        reader.onload = (e) => {
            try {
                const projectData = JSON.parse(e.target.result);
                applyProjectData(projectData, file.name); // Übergebe den Dateinamen
                showNotification('Projekt erfolgreich geladen!', 'success');
            } catch (error) {
                console.error("Fehler beim Parsen der Projektdatei:", error);
                showNotification(`Fehler beim Laden des Projekts: ${error.message}`, 'error');
            } finally {
                loadProjectInput.value = ""; // Input zurücksetzen
            }
        };
        reader.onerror = () => {
            showNotification('Fehler beim Lesen der Projektdatei.', 'error');
            loadProjectInput.value = ""; // Input zurücksetzen
        };
        reader.readAsText(file);
    });
}

// Event-Listener für den "Neu" Button, der das Modal öffnet
if (resetProjectBtn && confirmResetModalElement) {
    if (!confirmResetModalInstance) {
        // Die Instanz wird idealerweise in initializeApp() erstellt und hier wiederverwendet
        confirmResetModalInstance = new bootstrap.Modal(confirmResetModalElement);
    }

    resetProjectBtn.addEventListener('click', () => {
        // HIER DARF KEIN AUFRUF VON performProjectReset() oder resetProjectState() STEHEN!
        // Es darf NUR das Modal angezeigt werden.

        // FALSCH (Beispiel, was den Fehler verursachen würde):
        // performProjectReset(); // <-- DIES WÜRDE SOFORT LÖSCHEN!
        // if (confirm("Wirklich?")) { performProjectReset(); } // <-- AUCH FALSCH HIER!

        // RICHTIG:
        if (confirmResetModalInstance) {
            confirmResetModalInstance.show(); // Zeige das Modal
        } else {
            // Dieser Fall sollte eigentlich nicht eintreten, wenn initializeApp korrekt ist
            console.error("Modal-Instanz für Reset-Bestätigung nicht gefunden! Initialisierungsproblem?");
            // Als absoluter Notfall-Fallback könnte man hier das alte confirm nehmen,
            // aber das Ziel ist, dass die Instanz immer da ist.
            if (confirm("Fallback-Frage: Projekt wirklich zurücksetzen? (Modal-Problem)")) {
                performProjectReset();
            }
        }
    });
}
// Event-Listener für den "Ja, löschen" Button im Layer-Löschen-Modal
if (confirmDeleteLayerModalYesBtn) { // Prüft, ob das Element im DOM ist
    confirmDeleteLayerModalYesBtn.addEventListener('click', () => {
        console.log("Modal 'Ja, löschen' geklickt. layerIndexToDelete:", layerIndexToDelete); // DEBUG

        if (layerIndexToDelete !== -1) { // Sicherstellen, dass ein Index gesetzt ist
            console.log("Rufe performLayerDelete für Index:", layerIndexToDelete); // DEBUG
            performLayerDelete(layerIndexToDelete);
            layerIndexToDelete = -1; // Index zurücksetzen NACHDEM er verwendet wurde
        } else {
            console.warn("layerIndexToDelete war -1 beim Klick auf 'Ja, löschen'"); // DEBUG
        }

        if (confirmDeleteLayerModalInstance) {
            console.log("Schließe Layer-Löschen-Modal"); // DEBUG
            confirmDeleteLayerModalInstance.hide();
        } else {
            console.warn("Modal-Instanz für Layer-Löschen nicht gefunden zum Schließen"); // DEBUG
        }
    });
    console.log("Event Listener für #confirmDeleteLayerModalYesBtn registriert."); // DEBUG
} else {
    console.error("#confirmDeleteLayerModalYesBtn wurde nicht im DOM gefunden!"); // DEBUG
}

// Event-Listener für den "Ja, verwerfen" Button im Modal
if (confirmResetModalYesBtn && confirmResetModalInstance) { // Stelle sicher, dass Instanz existiert
    confirmResetModalYesBtn.addEventListener('click', () => {
        performProjectReset(); // Führe die Reset-Aktion aus
        confirmResetModalInstance.hide(); // Schließe das Modal
    });
} else if (confirmResetModalYesBtn && !confirmResetModalInstance && confirmResetModalElement) {
    // Fallback, falls Instanz noch nicht da war, aber Element schon (sollte nicht oft passieren)
    // Man könnte die Instanzerzeugung auch in initializeApp machen
    confirmResetModalYesBtn.addEventListener('click', () => {
        performProjectReset();
        const instance = bootstrap.Modal.getInstance(confirmResetModalElement);
        if (instance) instance.hide();
    });
}

initUIController(setActiveLayer); // UI Controller mit Callback zum Setzen des aktiven Layers initialisieren

// --- Event Listener ---

imageUpload.addEventListener("change", e => {
    const file = e.target.files[0];
    if (!file) {
        displayBaseImageSize(null, null);
        return;
    }
    const reader = new FileReader();
    reader.onload = evt => {
        const newBaseImage = new Image(); // newBaseImage, um Konflikt mit globalem baseImage zu vermeiden
        newBaseImage.originalName = file.name;
        newBaseImage.onload = () => {
            baseImage = newBaseImage; // Jetzt das globale baseImage setzen
            canvas.width = baseImage.width;
            canvas.height = baseImage.height;
            displayBaseImageSize(baseImage.naturalWidth, baseImage.naturalHeight);
            redrawAll();
        };
        newBaseImage.onerror = () => {
            console.error("Basisbild konnte nicht geladen werden.");
            alert("Fehler: Das ausgewählte Basisbild konnte nicht geladen werden.");
            displayBaseImageError();
            baseImage = null;
        };
        newBaseImage.src = evt.target.result;
    };
    reader.readAsDataURL(file);
});

// js/main.js
// ... (Stelle sicher, dass Layer, layers, layerSelect, showNotification,
//      setActiveLayer, recordStateForUndo, canvas importiert/definiert sind)

addLayerBtn.addEventListener("click", () => {
    // 1. Hole die Quelle und das Label aus dem Haupt-Dropdown (#layerSelect)
    const src = layerSelect.value;
    const selectedIndex = layerSelect.selectedIndex; // Hole den Index für das Label

    if (!src || selectedIndex < 0) { // Prüfe auch, ob ein gültiger Index ausgewählt ist
        showNotification("Bitte wählen Sie einen Layer-Typ aus der Liste.", 'warning');
        return;
    }
    const label = layerSelect.options[selectedIndex].text;

    // 2. Zustand für Undo sichern, BEVOR der neue Layer hinzugefügt wird
    //    (und bevor der activeLayerIndex sich potenziell ändert)
    recordStateForUndo();

    // 3. Image-Objekt erstellen und Lade-Handler definieren
    const img = new Image();

    img.onload = () => {
        // Bild wurde erfolgreich geladen
        const initialX = (canvas.width > 0 && img.width > 0) ? (canvas.width / 2) - (img.width / 2) : 50;
        const initialY = (canvas.height > 0 && img.height > 0) ? (canvas.height / 2) - (img.height / 2) : 50;
        const newLayer = new Layer(img, initialX, initialY, label);

        layers.push(newLayer);

        // 4. Neuen Layer als aktiv setzen.
        //    setActiveLayer sollte intern recordStateForUndo (falls sich der Index ändert)
        //    und redrawAll() aufrufen.
        //    Der Index des neuen Layers ist layers.length - 1.
        setActiveLayer(layers.length - 1);
        // setActiveLayer(newLayerIndex) ruft intern:
        //   - recordStateForUndo() (wenn activeLayerIndex sich wirklich ändert)
        //   - activeLayerIndex = newLayerIndex
        //   - redrawAll()
        // redrawAll() ruft intern:
        //   - drawCanvas(...)
        //   - updateLayerList(...)
        //   - populateCameraOverlaySelectWithProjectLayers() // Wichtig für das Overlay-Dropdown
        //   - initializeTooltips()

        showNotification(`Layer "${label}" erfolgreich hinzugefügt!`, 'success', 3000);
    };

    img.onerror = () => {
        // Fehler beim Laden des Bildes
        const errorMessage = `Layer-Bild "${label}" (${src}) konnte nicht geladen werden.`;
        console.error(errorMessage);
        showNotification(errorMessage, 'error', 5000);
        // Wichtig: Wenn ein Fehler auftritt, sollte der zuvor mit recordStateForUndo()
        // gespeicherte Zustand möglicherweise "verworfen" oder der Undo-Stack bereinigt werden,
        // da die Aktion nicht erfolgreich abgeschlossen wurde. Das ist aber fortgeschritten.
        // Für den Moment ist die Fehlermeldung das Wichtigste.
        // Der recordStateForUndo bleibt bestehen, ein Undo würde zum Zustand vor dem Versuch zurückkehren.
    };

    // Setze die Quelle, um das Laden des Bildes zu starten
    img.src = src;
});

downloadBtn.addEventListener("click", () => {
    const currentActive = activeLayerIndex; // Aktuellen aktiven Layer merken
    activeLayerIndex = -1; // Handles für Download deaktivieren
    drawCanvas(layers, activeLayerIndex, baseImage); // Ohne Handles zeichnen

    const imageDataURL = canvas.toDataURL("image/png"); // Oder image/jpeg je nach Bedarf

    // 1. Client-seitiger Download (wie bisher)
    let finalFilename = "bild-mit-layern.png";
    const userInputFilename = downloadFilenameInput.value.trim();
    if (userInputFilename) {
        finalFilename = userInputFilename.toLowerCase().endsWith('.png') ? userInputFilename : userInputFilename + ".png";
    } else if (baseImage && baseImage.originalName) {
        const nameWithoutExtension = baseImage.originalName.substring(0, baseImage.originalName.lastIndexOf('.')) || baseImage.originalName;
        finalFilename = nameWithoutExtension + "_layer.png";
    }

    const link = document.createElement("a");
    link.download = finalFilename;
    link.href = canvas.toDataURL("image/png");
    link.click();

    // 2. Bilddaten an den Server senden zum Speichern
    const formData = new FormData();
    formData.append('imageData', imageDataURL); // Sende den kompletten Data-URL

    fetch('php/save_image.php', { // Pfad zu deinem PHP-Skript
        method: 'POST',
        body: formData
        // Kein 'Content-Type' Header nötig, wenn FormData verwendet wird, der Browser setzt ihn korrekt (multipart/form-data)
        // Wenn du JSON senden würdest: headers: { 'Content-Type': 'application/json' }, body: JSON.stringify({imageData: imageDataURL})
        // Dann müsste PHP $_POST['imageData'] oder json_decode(file_get_contents('php://input')) verwenden.
        // Für Base64-Strings ist FormData oder ein einfacher POST-Parameter oft ausreichend.
    })
        .then(response => {
            // Prüfe, ob die Antwort vom Server OK ist (Status 200-299)
            // Auch wenn die Antwort JSON ist, müssen wir sie erst parsen
            if (!response.ok) {
                // Versuche, Fehlerdetails aus dem JSON-Body zu lesen, falls vorhanden
                return response.json().then(errData => {
                    throw new Error(errData.message || `Serverfehler: ${response.status}`);
                }).catch(() => { // Falls Body kein JSON oder leer
                    throw new Error(`Serverfehler: ${response.status} ${response.statusText}`);
                });
            }
            return response.json(); // Parse die JSON-Antwort
        })
        .then(data => {
            if (data.success) {
                showNotification(data.message || 'Bild erfolgreich auf dem Server gespeichert.', 'success', 4000);
                console.log('Server-Antwort (Speichern erfolgreich):', data);
            } else {
                // Fehler wurde schon im vorherigen .then geworfen, falls response.ok false war.
                // Dieser Block wäre für Fälle, wo response.ok true ist, aber data.success false.
                showNotification(data.message || 'Fehler beim serverseitigen Speichern.', 'error');
                console.error('Server-Antwort (Speichern fehlgeschlagen):', data);
            }
        })
        .catch(error => {
            console.error('Fehler beim Senden des Bildes an den Server:', error);
            showNotification(`Fehler beim Server-Upload: ${error.message}`, 'error', 5000);
        })
        .finally(() => {
            // Nach Client-Download und Server-Upload (oder Fehler dabei)
            activeLayerIndex = currentActive; // Aktiven Layer wiederherstellen
            redrawAll(); // Wieder mit Handles zeichnen (falls der aktive Layer einer war)
        });
});

// Canvas Interaktions-Listener
canvas.addEventListener("mousedown", e => {
    const { x, y } = getMousePos(e);
    for (let i = layers.length - 1; i >= 0; i--) {
        const layer = layers[i]; // <<< DEFINIERE LAYER HIER
        if (layer.isVisible && layer.contains(x, y)) { // Jetzt kann layer verwendet werden
            activeLayerIndex = i;
            action = "move";
            offset = { x: x - layer.x, y: y - layer.y };
            redrawAll();
            return;
        }
    }
});

canvas.addEventListener("mousemove", e => {
    if (activeLayerIndex === -1 || action !== "move") return;
    const { x, y } = getMousePos(e);
    const layer = layers[activeLayerIndex];
    layer.x = x - offset.x;
    layer.y = y - offset.y;
    drawCanvas(layers, activeLayerIndex, baseImage); // Nur Canvas neu zeichnen, Liste nicht bei jedem Move
});

window.addEventListener("mouseup", () => {
    if (action === "move") {
        recordStateForUndo();
        action = null;
        if (activeLayerIndex !== -1) {
            updateLayerList(layers, activeLayerIndex); // Liste nach dem Verschieben aktualisieren
        }
    }
});

canvas.addEventListener("touchstart", e => {
    const touches = e.touches;
    if (touches.length === 1) {
        const { x, y } = getTouchPos(touches[0]);
        for (let i = layers.length - 1; i >= 0; i--) {
            const layer = layers[i];
            // PRÜFUNG AUF SICHTBARKEIT HINZUGEFÜGT:
            if (layer.isVisible && layer.contains(x, y)) {
                activeLayerIndex = i;
                action = "move";
                offset = { x: x - layers[i].x, y: y - layers[i].y };
                redrawAll();
                break;
            }
        }
    } else if (touches.length === 2 && activeLayerIndex !== -1) {
        // PRÜFUNG AUF SICHTBARKEIT FÜR PINCH-START HINZUGEFÜGT:
        if (layers[activeLayerIndex].isVisible) {
            action = "pinch";
            initialDistance = getTouchDistance(touches);
            initialScale = layers[activeLayerIndex].scale;
        } else {
            action = null; // Keine Pinch-Aktion für unsichtbare Layer
        }
    }
}, { passive: true });

canvas.addEventListener("touchmove", e => {
    if (activeLayerIndex === -1 || !action) return;

    e.preventDefault(); // Verhindere Scrollen NUR wenn eine Canvas-Aktion aktiv ist

    const touches = e.touches;
    const layer = layers[activeLayerIndex];

    if (touches.length === 1 && action === "move") {
        const { x, y } = getTouchPos(touches[0]);
        layer.x = x - offset.x;
        layer.y = y - offset.y;
    } else if (touches.length === 2 && action === "pinch") {
        const newDist = getTouchDistance(touches);
        layer.scale = Math.max(0.1, initialScale * (newDist / initialDistance));
    }
    drawCanvas(layers, activeLayerIndex, baseImage); // Nur Canvas
}, { passive: false });

canvas.addEventListener("touchend", e => {
    console.log("touchend event ausgelöst", e.touches.length, "aktive Touches"); // DEBUG
    const wasAction = action;
    action = null;
    if (wasAction && activeLayerIndex !== -1) { // Nur wenn eine Aktion lief und ein Layer aktiv ist
        console.log(`touchend: Aktion war "${wasAction}". Rufe recordStateForUndo auf.`); // DEBUG
        recordStateForUndo(); // Zustand nach Abschluss der Touch-Aktion
        updateLayerList(layers, activeLayerIndex); // Liste aktualisieren mit finalen Werten
        showNotification(`Layer-Aktion (${wasAction}) abgeschlossen.`, 'info', 1500); // DEBUG Feedback
    }
    action = null; // Setze die Aktion JETZT zurück, für den nächsten Touch-Start
    console.log("touchend: 'action' zurückgesetzt auf null."); // DEBUG
});

canvas.addEventListener("wheel", e => {
    // 1. Prüfen, ob überhaupt ein Layer aktiv ist
    if (activeLayerIndex === -1) {
        return; // Nichts tun, wenn kein Layer aktiv ist
    }

    // 2. Hole den aktiven Layer und prüfe, ob er existiert und sichtbar ist
    const activeLayer = layers[activeLayerIndex];
    if (!activeLayer || !activeLayer.isVisible) {
        // Nichts tun, wenn der aktive Layer nicht existiert oder nicht sichtbar ist
        return;
    }

    // Wenn wir hier ankommen, ist ein aktiver, sichtbarer Layer vorhanden.
    e.preventDefault(); // Verhindere das Scrollen der Seite NUR, wenn wir tatsächlich zoomen.

    clearTimeout(wheelDebounceTimeout);

    const scaleAmount = e.deltaY < 0 ? 1.1 : 1 / 1.1;
    const { x: mouseX, y: mouseY } = getMousePos(e); // Mausposition relativ zum Canvas Inhalt

    // Vektor vom Layer-Ursprung zur Maus
    const mouseRelX = mouseX - activeLayer.x;
    const mouseRelY = mouseY - activeLayer.y;

    const newScale = Math.max(0.1, activeLayer.scale * scaleAmount);

    // Neue Position des Layer-Ursprungs, sodass der Punkt unter der Maus fix bleibt
    activeLayer.x = mouseX - (mouseRelX * newScale / activeLayer.scale);
    activeLayer.y = mouseY - (mouseRelY * newScale / activeLayer.scale);
    activeLayer.scale = newScale;

    redrawAll(); // UI sofort aktualisieren

    wheelDebounceTimeout = setTimeout(() => {
        recordStateForUndo(); // Zustand für Undo/Redo nach einer Pause sichern
    }, 500); // 500ms nach dem letzten Wheel-Event
}, { passive: false });

// Layer Positionierungs-Buttons
document.querySelectorAll('.position-btn').forEach(button => {
    button.addEventListener('click', function () {

        if (activeLayerIndex === -1 || !baseImage) {
            // ERSETZE alert DURCH showNotification:
            showNotification(
                "Bitte wählen Sie zuerst einen Layer aus und laden Sie ein Basisbild, um ihn zu positionieren.",
                'warning', // Typ der Benachrichtigung (z.B. 'warning' oder 'info')
                4000       // Anzeigedauer in Millisekunden (z.B. 4 Sekunden)
            );
            return; // Verlasse die Funktion frühzeitig
        }
        recordStateForUndo();
        const layer = layers[activeLayerIndex];
        const layerBounds = layer.getCanvasBounds();
        const canvasWidth = canvas.width;
        const canvasHeight = canvas.height;
        const positionCommand = this.dataset.position;
        let newX = layer.x;
        let newY = layer.y;

        switch (positionCommand) {
            case "top-left": newX = 0; newY = 0; break;
            case "top-center": newX = canvasWidth / 2 - layerBounds.width / 2; newY = 0; break;
            case "top-right": newX = canvasWidth - layerBounds.width; newY = 0; break;
            case "middle-left": newX = 0; newY = canvasHeight / 2 - layerBounds.height / 2; break;
            case "middle-center": newX = canvasWidth / 2 - layerBounds.width / 2; newY = canvasHeight / 2 - layerBounds.height / 2; break;
            case "middle-right": newX = canvasWidth - layerBounds.width; newY = canvasHeight / 2 - layerBounds.height / 2; break;
            case "bottom-left": newX = 0; newY = canvasHeight - layerBounds.height; break;
            case "bottom-center": newX = canvasWidth / 2 - layerBounds.width / 2; newY = canvasHeight - layerBounds.height; break;
            case "bottom-right": newX = canvasWidth - layerBounds.width; newY = canvasHeight - layerBounds.height; break;
            default:
                console.warn("Unbekannter Positionierungsbefehl:", positionCommand);
                return; // Verlasse bei unbekanntem Befehl
        }
        layer.x = newX;
        layer.y = newY;
        redrawAll();
    });
});


// // Initiale UI-Anzeige
initializeApp();
// updateLayerList(layers, activeLayerIndex);
// console.log("App initialisiert mit Modulen.");