<?php

namespace WOWGmbH\Wownaechtebuch\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use WOWGmbH\Wownaechtebuch\Service\AnonymizationService;

class AnonymizationCommand extends Command
{
    /**
     * Configure the command by defining the name, options and arguments
     */
    protected function configure()
    {
        $this->setDescription('Anonymizes all archived data that has already been archived for 3 months.')
            ->setHelp('Anonymizes all archived data that has already been archived for 3 months.');
    }

    /**
     * Executes the command for showing sys_log entries
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $anonymizationService = new AnonymizationService();
        $io = new SymfonyStyle($input, $output);
        
        
        $io->title($this->getDescription());
        $result = $anonymizationService->anonymizeParentUsers();
        
        $io->writeln("anonymized users");
        $io->writeln("tx_wownaechtebuch_domain_model_parentuser - affected rows: $result");
        
        $io->writeln("");

        $result = $anonymizationService->anonymizeChilds();
        $io->writeln("anonymized children");
        $io->writeln("tx_wownaechtebuch_domain_model_child - affected rows: $result");

        return 0;
    }
}