<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Controller;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

/**
 * AnswerTypeController
 */
class AnswerTypeController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * answerTypeRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\AnswerTypeRepository
     */
    protected $answerTypeRepository;
    public function __construct()
    {
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\AnswerTypeRepository $answerTypeRepository
     */
    public function injectAnswerTypeRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\AnswerTypeRepository $answerTypeRepository)
    {
        $this->answerTypeRepository = $answerTypeRepository;
    }

    /**
     * action list
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function listAction(): \Psr\Http\Message\ResponseInterface
    {
        $answerTypes = $this->answerTypeRepository->findAll();
        $this->view->assign('answerTypes', $answerTypes);
        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function newAction(): \Psr\Http\Message\ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * action create
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $newAnswerType
     */
    public function createAction(\WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $newAnswerType): \Psr\Http\Message\ResponseInterface
    {
        $this->answerTypeRepository->add($newAnswerType);
        return $this->redirect('list');
    }

    /**
     * action edit
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("answerType")
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function editAction(\WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType): \Psr\Http\Message\ResponseInterface
    {
        $this->view->assign('answerType', $answerType);
        return $this->htmlResponse();
    }

    /**
     * action update
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType
     */
    public function updateAction(\WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType): \Psr\Http\Message\ResponseInterface
    {
        $this->answerTypeRepository->update($answerType);
        return $this->redirect('list');
    }

    /**
     * action delete
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType
     */
    public function deleteAction(\WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType): \Psr\Http\Message\ResponseInterface
    {
        $this->answerTypeRepository->remove($answerType);
        return $this->redirect('list');
    }
}
