<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Controller;

/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Extbase\Http\ForwardResponse;

/**
 * ProductRecordController
 */
class ProductRecordController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * productRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRepository
     */
    protected $productRepository;
    
    /**
     * parentUserRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository
     */
    protected $parentUserRepository;

    /**
     * productRecordRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRecordRepository
     */
    protected $productRecordRepository;
    /**
     * persistenceManager
     *
     * @var \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager
     */
    protected $persistenceManager;
    public function __construct()
    {
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager $persistenceManager
     */
    public function injectPersistenceManager(\TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager $persistenceManager)
    {
        $this->persistenceManager = $persistenceManager;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRepository $productRepository
     */
    public function injectProductRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRepository $productRepository)
    {
        $this->productRepository = $productRepository;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository $parentUserRepository
     */
    public function injectParentUserRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository $parentUserRepository)
    {
        $this->parentUserRepository = $parentUserRepository;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRecordRepository $productRecordRepository
     */
    public function injectProductRecordRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRecordRepository $productRecordRepository)
    {
        $this->productRecordRepository = $productRecordRepository;
    }

    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function newForUserAction( ): \Psr\Http\Message\ResponseInterface
    {
        $frontendUserUid = $this->request->getAttribute('frontend.user')->user['uid'];
        $parentUser = $this->parentUserRepository->findOneBy(['user' => $frontendUserUid]);
        $products = $this->productRepository->findAll();
        $this->view->assign('products', $products);
        $this->view->assign('parentUser', $parentUser);
        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("parentUser")
     */
    public function newAction(\WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser $parentUser ): \Psr\Http\Message\ResponseInterface
    {
        $products = $this->productRepository->findAll();
        $this->view->assign('products', $products);
        $this->view->assign('parentUser', $parentUser);
        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("parentUser")
     */
    public function newForCMAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child ): \Psr\Http\Message\ResponseInterface
    {
        $products = $this->productRepository->findAll();
        $this->view->assign('products', $products);
        $this->view->assign('child', $child);
        return $this->htmlResponse();
    }

    /**
     * action createForUser
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\ProductRecord $roductRecord
     */
    public function createForUserAction(\WOWGmbH\Wownaechtebuch\Domain\Model\ProductRecord $productRecord): \Psr\Http\Message\ResponseInterface
    {
        $productRecord->setProtuctName($productRecord->getProduct()->getName());

        $this->productRecordRepository->add($productRecord);
        
        $frontendUserUid = $this->request->getAttribute('frontend.user')->user['uid'];
        $parentUser = $this->parentUserRepository->findOneBy(['user' => $frontendUserUid]);

        $this->persistenceManager->persistAll();
        return (new ForwardResponse('newForUser'))
          ->withControllerName('Child')
          ->withArguments(['parentUser' => $parentUser, 'productRecord' => $productRecord]);
    }

    /**
     * action create
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\ProductRecord $roductRecord
     */
    // public function createAction(\WOWGmbH\Wownaechtebuch\Domain\Model\ProductRecord $productRecord): \Psr\Http\Message\ResponseInterface
    // {
    //     $this->productRecordRepository->add($productRecord);
    //     return (new ForwardResponse('index'))
    //       ->withControllerName('ParentUser');
    //     //   ->withArguments(['parentUser' => $productRecord->getParentUser()]);
    // }

    /**
     * action create
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\ProductRecord $roductRecord
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("productRecord")
     */
    public function createForCMAction(\WOWGmbH\Wownaechtebuch\Domain\Model\ProductRecord $productRecord): \Psr\Http\Message\ResponseInterface
    {
        $productRecord->setProtuctName($productRecord->getProduct()->getName());
        $this->productRecordRepository->add($productRecord);
        $this->persistenceManager->persistAll();
        return (new ForwardResponse('editForCM'))
          ->withControllerName('ParentUser')
          ->withArguments(['parentUser' => $productRecord->getChild()->getParentUser()]);
    }
}
