<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Controller;

use TYPO3\CMS\Core\Utility\DebugUtility;

/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

use \TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use \TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Http\ForwardResponse;

/**
 * TreatmentRunController
 */
class TreatmentRunController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * treatmentRunRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository
     */
    protected $treatmentRunRepository;
    /**
     * persistenceManager
     *
     * @var \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager
     */
    protected $persistenceManager;
    public function __construct()
    {
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager $persistenceManager
     */
    public function injectPersistenceManager(\TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager $persistenceManager)
    {
        $this->persistenceManager = $persistenceManager;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository $treatmentRunRepository
     */
    public function injectTreatmentRunRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository $treatmentRunRepository)
    {
        $this->treatmentRunRepository = $treatmentRunRepository;
    }

    /**
     * action index
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function indexAction(): \Psr\Http\Message\ResponseInterface
    {
        $treatmentRuns = $this->treatmentRunRepository->findAll();
        $this->view->assign('treatmentRuns', $treatmentRuns);
        return $this->htmlResponse();
    }

    /**
     * action list
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function listAction(): \Psr\Http\Message\ResponseInterface
    {
        $treatmentRuns = $this->treatmentRunRepository->findAll();
        $this->view->assign('treatmentRuns', $treatmentRuns);
        return $this->htmlResponse();
    }

    /**
     * action show
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function showAction(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun): \Psr\Http\Message\ResponseInterface
    {
        $this->view->assign('treatmentRun', $treatmentRun);
        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function newAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child): \Psr\Http\Message\ResponseInterface
    {
        $this->view->assign('child', $child);
        return $this->htmlResponse();
    }

    /**
     * action create
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $newTreatmentRun
     */
    public function createAction(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $newTreatmentRun): \Psr\Http\Message\ResponseInterface
    {
        $this->treatmentRunRepository->add($newTreatmentRun);
        return $this->redirect('list');
    }

    /**
     * action delete
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     */
    public function deleteAction(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun): \Psr\Http\Message\ResponseInterface
    {
        $this->treatmentRunRepository->remove($treatmentRun);
        return $this->redirect('list');
    }

    /**
     * action relapse
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     */
    public function relapseAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child, \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $relapseSurvey): \Psr\Http\Message\ResponseInterface
    {
        $treatmentRun = GeneralUtility::makeInstance(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun::class);
        $treatmentRun->setNumber(0);
        $treatmentRun->setState(0);
        $treatmentRun->setChild($child);


        $this->treatmentRunRepository->add($treatmentRun);
        $this->persistenceManager->persistAll();

        return (new ForwardResponse('fill'))
        ->withControllerName('SurveyRecord')
        ->withArguments(['survey' => $relapseSurvey, 'child' => $child]);
    }

    public function initializeUpdateAction(){
        if ($this->arguments->hasArgument('treatmentRun')) {
            $this->arguments['treatmentRun']->getPropertyMappingConfiguration()->forProperty('start')->setTypeConverterOption(
            'TYPO3\\CMS\\Extbase\\Property\\TypeConverter\\DateTimeConverter', 
            \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT, 
            'Y-m-d'
            );
        }
    }

    /**
     * action update
     *
     *  @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     */
    public function updateAction(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun): \Psr\Http\Message\ResponseInterface
    {
        $this->treatmentRunRepository->update($treatmentRun);
        return $this->redirect('editProtocol', 'SurveyRecord', null, ['child'=> $treatmentRun->getChild(), 'week'=> 1]);
    }

    public function initializeUpdateForCMAction(){
        if ($this->arguments->hasArgument('treatmentRun')) {
            $this->arguments['treatmentRun']->getPropertyMappingConfiguration()->forProperty('start')->setTypeConverterOption(
            'TYPO3\\CMS\\Extbase\\Property\\TypeConverter\\DateTimeConverter', 
            \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT, 
            'Y-m-d'
            );
        }
    }

    /**
     * action updateForCM
     *
     *  @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     */
    public function updateForCMAction(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun): \Psr\Http\Message\ResponseInterface
    {
        $this->treatmentRunRepository->update($treatmentRun);
        return $this->redirect('editProtocolForCM', 'SurveyRecord', null, ['child'=> $treatmentRun->getChild(), 'week'=> 1]);
    }
}
