<?php

declare(strict_types=1);
/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

namespace WOWGmbH\Wownaechtebuch\DTO;

use WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class ProtocolData {
    /** @var ObjectStorage<SurveyRecord>  */
    protected ObjectStorage $surveyRecords;

    /** @var int */
    protected int $state = 0;

    /** @var bool */
    protected bool $save = false;

    // public function __construct()
    // {
    //     $this->initializeObject();
    // }

    // public function initializeObject(): void
    // {
    //     $this->surveyRecords = new ObjectStorage();
    // }

    /** @return int */
    public function getState() : int
    {
        return $this->state;
    }
    
    /** @param int */
    public function setState(int $state) : void
    {
        $this->state = $state;
    }

    /** @return bool */
    public function getSave() : bool
    {
        return $this->save;
    }
    
    /** @param bool */
    public function setSave(bool $save) : void
    {
        $this->save = $save;
    }

    /** @return ObjectStorage<SurveyRecord> */
    public function setSurveyRecords(ObjectStorage $surveyRecords): void
    {
        $this->surveyRecords = $surveyRecords;
    }
    
    /** @param ObjectStorage<SurveyRecord> */
    public function getSurveyRecords(): ?ObjectStorage
    {
        return $this->surveyRecords;
    }
}