<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use \TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * Child
 */
class Child extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    public const STATE_ACTIVE = 0;
    public const STATE_ARCHIVED = 3;

    /**
    * treatmentRuns
    * 
    * @var ?ObjectStorage<TreatmentRun>
    */
    protected $treatmentRuns = null;

    /**
     * firstName
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $firstName;

    /**
     * lastName
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $lastName;

    /**
     * dateOfArchive
     *
     * @var \DateTime
     */
    protected $dateOfArchive;

    /**
     * state
     *
     * @var int
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $state;

    /**
     * parentUser
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser
     */
    protected $parentUser;

    /**
     * parentUser
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord
     */
    protected $registrationSurveyRecord;

    public function __construct()
    {
        $this->initializeObject();
    }

    public function initializeObject(): void
    {
        $this->treatmentRuns = new ObjectStorage();
    }

    /**
     * Returns the firstName
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * Sets the firstName
     *
     * @param string|null $firstName
     * @return void
     */
    public function setFirstName(?string $firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * Returns the lastName
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * Sets the lastName
     *
     * @param string|null $lastName
     * @return void
     */
    public function setLastName(?string $lastName)
    {
        $this->lastName = $lastName;
    }

    /**
     * Returns the dateOfArchive
     *
     * @return \DateTime
     */
    public function getDateOfArchive()
    {
        return $this->dateOfArchive;
    }

    /**
     * Sets the dateOfArchive
     *
     * @param \DateTime $dateOfArchive
     * @return void
     */
    public function setDateOfArchive(\DateTime $dateOfArchive)
    {
        $this->dateOfArchive = $dateOfArchive;
    }

    /**
     * Returns the state
     *
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the state
     *
     * @param int $state
     * @return void
     */
    public function setState(int $state)
    {
        $this->state = $state;
    }

    /**
     * Returns the parentUser
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser
     */
    public function getParentUser()
    {
        return $this->parentUser;
    }

    /**
     * Sets the parentUser
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser $parentUser
     * @return void
     */
    public function setParentUser(\WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser $parentUser)
    {
        $this->parentUser = $parentUser;
    }

    /**
     * Returns the registrationSurveyRecord
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord
     */
    public function getRegistrationSurveyRecord()
    {
        return $this->registrationSurveyRecord;
    }

    /**
     * Sets the registrationSurveyRecord
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord $registrationSurveyRecord
     * @return void
     */
    public function setRegistrationSurveyRecord(\WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord $registrationSurveyRecord)
    {
        $this->registrationSurveyRecord = $registrationSurveyRecord;
    }

    /**
     * Adds a treatmentRun to this Child
     */
    public function addTreatmentRun(TreatmentRun $treatmentRun): void
    {
        $this->treatmentRuns?->attach($treatmentRun);
    }

    /**
     * Remove a treatmentRun from this Child
     */
    public function removeTreatmentRun(TreatmentRun $treatmentRunToRemove): void
    {
        $this->treatmentRuns?->detach($treatmentRunToRemove);
    }

    /**
     * Returns all treatmentRuns in this Child
     *
     *  @return ObjectStorage<TreatmentRun>
     */
    public function getTreatmentRuns(): ObjectStorage
    {
        return $this->treatmentRuns;
    }

    /**
     * @param ObjectStorage<TreatmentRun> $treatmentRuns
     */
    public function setTreatmentRuns(ObjectStorage $treatmentRuns): void
    {
        $this->treatmentRuns = $treatmentRuns;
    }
}
