<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use \TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * ParentUser
 */
class ParentUser extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    public const STATE_ACTIVE = 0;
    public const STATE_ARCHIVED = 3;

    /**
     * children
     * 
     * @var ?ObjectStorage<Child>
     */
    #[Lazy()]
    protected $childs = null;

    /**
     * @var int
     */
    protected $gender;

    /**
     * firstName
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $firstName;

    /**
     * lastName
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $lastName;

    /**
     * email
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $email;

    /**
     * city
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $city;

    /**
     * zip
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $zip;

    /**
     * region
     *
     * @var string|null
     */
    protected $region;

    /**
     * country
     *
     * @var string|null
     */
    protected $country;

    /**
     * address
     *
     * @var string|null
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $address;

    /**
     * dateOfArchive
     *
     * @var \DateTime
     */
    protected $dateOfArchive;

    /**
     * state
     *
     * @var int
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $state;

    /**
     * user
     *
     * @var \In2code\Femanager\Domain\Model\User
     */
    protected \In2code\Femanager\Domain\Model\User|null $user;


    /**
     * Returns the firstName
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * Sets the firstName
     *
     * @param string|null $firstName
     * @return void
     */
    public function setFirstName(?string $firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * Returns the lastName
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * Sets the lastName
     *
     * @param string|null $lastName
     * @return void
     */
    public function setLastName(?string $lastName)
    {
        $this->lastName = $lastName;
    }

    /**
     * Returns the email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string|null $email
     * @return void
     */
    public function setEmail(?string $email)
    {
        $this->email = $email;
    }

    /**
     * Returns the city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Sets the city
     *
     * @param string|null $city
     * @return void
     */
    public function setCity(?string $city)
    {
        $this->city = $city;
    }

    /**
     * Returns the zip
     *
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     *
     * @param string|null $zip
     * @return void
     */
    public function setZip(?string $zip)
    {
        $this->zip = $zip;
    }

    /**
     * Returns the region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * Sets the region
     *
     * @param string|null $region
     * @return void
     */
    public function setRegion(?string $region)
    {
        $this->region = $region;
    }

    /**
     * Returns the country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * Sets the country
     *
     * @param string|null $country
     * @return void
     */
    public function setCountry(?string $country)
    {
        $this->country = $country;
    }

    /**
     * Returns the address
     *
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Sets the address
     *
     * @param string|null $address
     * @return void
     */
    public function setAddress(?string $address)
    {
        $this->address = $address;
    }

    /**
     * Returns the dateOfArchive
     *
     * @return \DateTime
     */
    public function getDateOfArchive()
    {
        return $this->dateOfArchive;
    }

    /**
     * Sets the dateOfArchive
     *
     * @param \DateTime $dateOfArchive
     * @return void
     */
    public function setDateOfArchive(\DateTime $dateOfArchive)
    {
        $this->dateOfArchive = $dateOfArchive;
    }

    /**
     * Returns the state
     *
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the state
     *
     * @param int $state
     * @return void
     */
    public function setState(int $state)
    {
        $this->state = $state;
    }

    /**
     * Adds a child to this paretnUser
     */
    public function addChild(Child $child): void
    {
        $this->childs?->attach($child);
    }

    /**
     * Remove a child from this paretnUser
     */
    public function removeChild(Child $childToRemove): void
    {
        $this->childs?->detach($childToRemove);
    }

    /**
     * Returns all childs in this paretnUser
     *
     * @return ObjectStorage<Child>
     */
    public function getChilds(): ObjectStorage
    {
        if(!$this->childs) return new ObjectStorage();
        return $this->childs;
    }

    /**
     * @param ObjectStorage<Child> $childs
     */
    public function setChilds(ObjectStorage $childs): void
    {
        $this->childs = $childs;
    }

    /**
     * Returns the user
     *
     * @return \In2code\Femanager\Domain\Model\User
     */
    public function getUser(): ?\In2code\Femanager\Domain\Model\User
    {
        return $this->user ?? null;
    }

    /**
     * @param \In2code\Femanager\Domain\Model\User $user
     */
    public function setUser(\In2code\Femanager\Domain\Model\User $user): void
    {
        $this->user = $user;
    }

        /**
     * Returns the gender
     *
     * @return int $gender
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Sets the gender
     *
     * @param int $gender
     */
    public function setGender($gender)
    {
        $this->gender = $gender;
    }

}
