<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * ProductRecord
 */
class ProductRecord extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * serialNumber
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $serialNumber;

    /**
     * static name of the product, on time of buying.
     *
     * @var string
     */
    protected $protuctName;

    /**
     * child
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\Child
     */
    
    protected $child;

    /**
     * product
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\Product
     */
    
    protected $product;

    /**
     * Returns the serialNumber
     *
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }

    /**
     * Sets the serialNumber
     *
     * @param string $serialNumber
     * @return void
     */
    public function setSerialNumber(string $serialNumber)
    {
        $this->serialNumber = $serialNumber;
    }

    /**
     * Returns the protuctName
     *
     * @return string
     */
    public function getProtuctName()
    {
        return $this->protuctName;
    }

    /**
     * Sets the protuctName
     *
     * @param string $protuctName
     * @return void
     */
    public function setProtuctName(string $protuctName)
    {
        $this->protuctName = $protuctName;
    }

    /**
     * Returns the child
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\Child
     */
    public function getChild()
    {
        return $this->child;
    }

    /**
     * Sets the child
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Child $child
     * @return void
     */
    public function setChild(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child)
    {
        $this->child = $child;
    }

    /**
     * Returns the product
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\Product
     */
    public function getProduct()
    {
        return $this->product;
    }

    /**
     * Sets the product
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Product $product
     * @return void
     */
    public function setProduct(\WOWGmbH\Wownaechtebuch\Domain\Model\Product $product)
    {
        $this->product = $product;
    }
}
