<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

use Doctrine\DBAL\Types\JsonType;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * Question
 */
class Question extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * text
     *
     * @var string
     */
    protected $text;

    /**
     * options
     *
     * @var string
     */
    protected $options;

    /**
     * survey
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\Survey
     */
    
    protected $survey;

    /**
     * answerType
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType
     */
    
    protected $answerType;

    /**
     * page
     *
     * @var int
     */
    protected $page;

    /**
     * Returns the text
     *
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * Sets the text
     *
     * @param string $text
     * @return void
     */
    public function setText(string $text)
    {
        $this->text = $text;
    }

        /**
     * Returns the questionText
     *
     * @return int
     */
    public function getPage()
    {
        return $this->page;
    }

    /**
     * Sets the questionText
     *
     * @param string $questionText
     * @return void
     */
    public function setPage(int $page)
    {
        $this->page = $page;
    }

    /**
     * Returns the options
     *
     * @return string
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * Sets the options
     *
     * @param string $options
     * @return void
     */
    public function setOptions(string $options)
    {
        $this->options = $options;
    }

    /**
     * Returns the survey
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\Survey
     */
    public function getSurvey()
    {
        return $this->survey;
    }

    /**
     * Sets the survey
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey
     * @return void
     */
    public function setSurvey(\WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey)
    {
        $this->survey = $survey;
    }

    /**
     * Returns the answerType
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType
     */
    public function getAnswerType()
    {
        return $this->answerType;
    }

    /**
     * Sets the answerType
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType
     * @return void
     */
    public function setAnswerType(\WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType)
    {
        $this->answerType = $answerType;
    }
}
