<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use \TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;
/**
 * SurveyRecord
 */
class SurveyRecord extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    public const STATE_OPEN = 0;
    public const STATE_SENT = 1;
    public const STATE_ARCHIVED = 3;

    /**
     * questionRecord
     * 
     * @var ?ObjectStorage<QuestionRecord>
     */
    protected ?ObjectStorage $questionRecords = null;

    /**
     * surveyName
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $surveyName;

    /**
     * dateOfArchive
     *
     * @var \DateTime
     */
    protected $dateOfArchive;

    /**
     * state
     *
     * @var int
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $state;

    /**
     * week
     *
     * @var int
     */
    protected $week;
 
    /**
     * day
     *
     * @var int
     */
    protected $day;

    /**
     * treatmentRun
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun
     */
    protected $treatmentRun;

    /**
     * survey
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\Survey
     */
    
    protected $survey;

    public function __construct()
    {
        $this->initializeObject();
    }

    public function initializeObject(): void
    {
        $this->questionRecords = new ObjectStorage();
    }

    /**
     * Returns the surveyName
     *
     * @return string
     */
    public function getSurveyName()
    {
        return $this->surveyName;
    }

    /**
     * Sets the surveyName
     *
     * @param string $surveyName
     * @return void
     */
    public function setSurveyName(string $surveyName)
    {
        $this->surveyName = $surveyName;
    }

    /**
     * Returns the dateOfArchive
     *
     * @return \DateTime
     */
    public function getDateOfArchive()
    {
        return $this->dateOfArchive;
    }

    /**
     * Sets the dateOfArchive
     *
     * @param \DateTime $dateOfArchive
     * @return void
     */
    public function setDateOfArchive(\DateTime $dateOfArchive)
    {
        $this->dateOfArchive = $dateOfArchive;
    }

    /**
     * Returns the state
     *
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the state
     *
     * @param int $state
     * @return void
     */
    public function setState(int $state)
    {
        $this->state = $state;
    }

    /**
     * Returns the week
     *
     * @return int
     */
    public function getWeek()
    {
        return $this->week;
    }

    /**
     * Sets the week
     *
     * @param int $week
     * @return void
     */
    public function setWeek(int $week)
    {
        $this->week = $week;
    }

    /**
     * Returns the day
     *
     * @return int
     */
    public function getDay()
    {
        return $this->day;
    }

    /**
     * Sets the day
     *
     * @param int $day
     * @return void
     */
    public function setDay(int $day)
    {
        $this->day = $day;
    }

    /**
     * Returns the treatmentRun
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun
     */
    public function getTreatmentRun()
    {
        return $this->treatmentRun;
    }

    /**
     * Sets the treatmentRun
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     * @return void
     */
    public function setTreatmentRun(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun)
    {
        $this->treatmentRun = $treatmentRun;
    }

    /**
     * Returns the survey
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\Survey
     */
    public function getSurvey()
    {
        return $this->survey;
    }

    /**
     * Sets the survey
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey
     * @return void
     */
    public function setSurvey(\WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey)
    {
        $this->survey = $survey;
    }

        /**
     * Adds a questionRecord to this surveyRecord
     */
    public function addQuestionRecord(QuestionRecord $questionRecord): void
    {
        $this->questionRecords?->attach($questionRecord);
    }

    /**
     * Remove a questionRecord from this surveyRecord
     */
    public function removeQuestionRecord(QuestionRecord $questionRecordToRemove): void
    {
        $this->questionRecords?->detach($questionRecordToRemove);
    }

    /**
     * Returns all questionRecords in this surveyRecord
     *
     * @return ObjectStorage<QuestionRecord>
     */
    public function getQuestionRecords(): ?ObjectStorage
    {
        return $this->questionRecords;
    }

    /**
     * @param ObjectStorage<QuestionRecord> $questionRecords
     */
    public function setQuestionRecords(ObjectStorage $questionRecords): void
    {
        $this->questionRecords = $questionRecords;
    }
}
