<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use \TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * TreatmentRun
 */
class TreatmentRun extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{    
    /**
     * surveyRecords
     * 
     * @var ?ObjectStorage<SurveyRecord>
     */
    
    protected ?ObjectStorage $surveyRecords = null;

    /**
     * number
     *
     * @var int
     */
    protected $number;

    /**
     * start
     *
     * @var \DateTime
     */
    protected $start;

    /**
     * end
     *
     * @var \DateTime
     */
    protected $end;

    /**
     * dateOfArchive
     *
     * @var \DateTime
     */
    protected $dateOfArchive;

    /**
     * state
     *
     * @var int
     */
    protected $state;

    /**
     * child
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\Child
     */
    
    protected $child;

    /**
     * Returns the number
     *
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * Sets the number
     *
     * @param int $number
     * @return void
     */
    public function setNumber(int $number)
    {
        $this->number = $number;
    }

    /**
     * Returns the start
     *
     * @return \DateTime
     */
    public function getStart()
    {
        return $this->start;
    }

    /**
     * Sets the start
     *
     * @param \DateTime $start
     * @return void
     */
    public function setStart(\DateTime $start)
    {
        $this->start = $start;
    }

    /**
     * Returns the end
     *
     * @return \DateTime
     */
    public function getEnd()
    {
        return $this->end;
    }

    /**
     * Sets the end
     *
     * @param \DateTime $end
     * @return void
     */
    public function setEnd(\DateTime $end)
    {
        $this->end = $end;
    }

    /**
     * Returns the dateOfArchive
     *
     * @return \DateTime
     */
    public function getDateOfArchive()
    {
        return $this->dateOfArchive;
    }

    /**
     * Sets the dateOfArchive
     *
     * @param \DateTime $dateOfArchive
     * @return void
     */
    public function setDateOfArchive(\DateTime $dateOfArchive)
    {
        $this->dateOfArchive = $dateOfArchive;
    }

    /**
     * Returns the state
     *
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the state
     *
     * @param int $state
     * @return void
     */
    public function setState(int $state)
    {
        $this->state = $state;
    }

    /**
     * Returns the child
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\Child
     */
    public function getChild()
    {
        return $this->child;
    }

    /**
     * Sets the child
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Child $child
     * @return void
     */
    public function setChild(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child)
    {
        $this->child = $child;
    }

    /**
     * Adds a child to this paretnUser
     */
    public function addSurveyRecord(SurveyRecord $surveyRecord): void
    {
        $this->surveyRecords?->attach($surveyRecord);
    }

    /**
     * Remove a child from this paretnUser
     */
    public function removeSurveyRecord(SurveyRecord $surveyRecord): void
    {
        $this->surveyRecords?->detach($surveyRecord);
    }

    /**
     * Returns all surveyRecord in this paretnUser
     *
     * @return ObjectStorage<SurveyRecord>
     */
    public function getSurveyRecords(): ?ObjectStorage
    {
        return $this->surveyRecords;
    }

    /**
     * @param ObjectStorage<SurveyRecord> $surveyRecord
     */
    public function setSurveyRecords(ObjectStorage $surveyRecords): void
    {
        $this->surveyRecords = $surveyRecords;
    }
}
