<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Repository;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

/**
 * The repository for children
 */
class ChildRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
  public function findAllUnarchived() {
    $query = $this->createQuery();
    $query->matching(
      $query->logicalNot(
        $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Child::STATE_ARCHIVED)
      ),
    );
    
    return $query->execute();
  }

  public function findArchived() {
    $query = $this->createQuery();
    $query->matching(
        $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Child::STATE_ARCHIVED)
    );
    
    return $query->execute();
  }
}
