<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Repository;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use \WOWGmbH\Wownaechtebuch\Domain\Model\Letter;
use \WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;
/**
 * The repository for LetterRecords
 */
class LetterRecordRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
  public function findLatestByLetter(Letter $letter): ?LetterRecord
  {
    $query = $this->createQuery();
    $query->matching($query->equals('letter', $letter));
    $query->setOrderings(['crdate' => QueryInterface::ORDER_DESCENDING]);
    $result = $query->execute();
    return $result->getFirst();
  }
}
