<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Repository;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use WOWGmbH\Wownaechtebuch\Domain\Model\Child;
use WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;
/**
 * The repository for TreatmentRuns
 */
class TreatmentRunRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
  public function findLatestByChild(Child $child): ?TreatmentRun
  {
    $query = $this->createQuery();
    $query->matching($query->equals('child', $child));
    $query->setOrderings(['crdate' => QueryInterface::ORDER_DESCENDING]);
    $result = $query->execute();
    return $result->getFirst();
  }
}
