<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Event;
use \WOWGmbH\Wownaechtebuch\Domain\Model\Child;

final class AfterSendProtocolsEvent
{
    public function __construct(
        private readonly Child $child,
        private readonly int $week
    ) {}

    public function getChild(): Child
    {
        return $this->child;
    }

    public function getWeek(): int
    {
      return $this->week;  
    }
}