<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\EventListener;

use TYPO3\CMS\Core\Attribute\AsEventListener;
use In2code\Femanager\Event\BeforeUserCreateEvent ;
use In2code\Femanager\Domain\Repository\UserRepository;
use \WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser;
use \TYPO3\CMS\Core\Utility\DebugUtility;
use \TYPO3\CMS\Core\Utility\GeneralUtility;

final readonly class ChangeUsernameBeforeUserCreate
{
      /**
     * parentUserRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository
     */
    protected ?UserRepository $userRepository;

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\ParentUserRepository $parentUserRepository
     */
    public function injectUserRepository(\In2code\Femanager\Domain\Repository\UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }
    
    public function __invoke(BeforeUserCreateEvent  $event): void
    {
      $user = $event->getUser();
      // 
      // $uniqueNumber = (string) rand(10000, 99999).$parentUserRepository->getNextUid();
      // $lenght = 6

      do {
        $username = sprintf("k%06d", rand(100000, 999999));
        $count = $this->userRepository->countByUsername($username);
      } while ($count > 0);
        
      $user->setUsername($username);

    }
}
