<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Service;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use WOWGmbH\WowNaechtebuch\Domain\Model\Child;
use WOWGmbH\Wownaechtebuch\Domain\Model\ParentUser;

class AnonymizationService
{
  function anonymizeChilds(): int
  {
    $date = (new \DateTime('-90 days'))->format('Y-m-d');
    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_wownaechtebuch_domain_model_child');
    $queryBuilder
      ->update('tx_wownaechtebuch_domain_model_child')
      ->where(
        $queryBuilder->expr()->eq('pid', 8),
        $queryBuilder->expr()->eq('state', Child::STATE_ARCHIVED),
        $queryBuilder->expr()->gt('date_of_archive', $date),
      )
      ->set('first_name', '')
      ->set('last_name', '');

    $result = $queryBuilder->executeStatement();
    return $result;
  }

  function anonymizeParentUsers(): int
  {
    $date = (new \DateTime('-90 days'))->format('Y-m-d');
    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_wownaechtebuch_domain_model_parentuser');
    $queryBuilder
      ->update('tx_wownaechtebuch_domain_model_parentuser')
      ->where(
        $queryBuilder->expr()->eq('pid', 8),
        $queryBuilder->expr()->eq('state', ParentUser::STATE_ARCHIVED),
        $queryBuilder->expr()->gt('date_of_archive', $date),
      )
      ->set('first_name', '')
      ->set('last_name', '')
      ->set('email', '')
      ->set('city', '')
      ->set('zip', '')
      ->set('region', '')
      ->set('country', '')
      ->set('gender', '')
      ->set('address', '');

    $result = $queryBuilder->executeStatement();
    return $result;
  }

  function anonymizeLetters(): int
  {
    $date = (new \DateTime('-90 days'))->format('Y-m-d');
    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_wownaechtebuch_domain_model_letterrecord');
    $queryBuilder
      ->delete('tx_wownaechtebuch_domain_model_letterrecord', 'lr')
      ->join(
        'lr',
        'tx_wownaechtebuch_domain_model_letter',
        'l',
        $queryBuilder->expr()->eq('lr.letter', 'l.uid')
      )
      ->where(
        $queryBuilder->expr()->eq('lr.pid', 8),
        $queryBuilder->expr()->eq('l.state', Child::STATE_ARCHIVED),
        $queryBuilder->expr()->gt('l.date_of_archive', $date),
      );
    $result = $queryBuilder->executeStatement();

    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_wownaechtebuch_domain_model_letterrecord');
    $queryBuilder
      ->delete('tx_wownaechtebuch_domain_model_letter')
      ->where(
        $queryBuilder->expr()->eq('lr.pid', 8),
        $queryBuilder->expr()->eq('l.state', Child::STATE_ARCHIVED),
        $queryBuilder->expr()->gt('l.date_of_archive', $date),
      );
    $result = $queryBuilder->executeStatement();

    return $result;
  }



  function anonymizeSurveyRecords(): int
  {
    $date = (new \DateTime('-90 days'))->format('Y-m-d');
    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_wownaechtebuch_domain_model_surveyrecord');
    $queryBuilder
      ->update('tx_wownaechtebuch_domain_model_surveyrecord')
      ->where(
        $queryBuilder->expr()->eq('pid', 8),
        $queryBuilder->expr()->gt('date_of_archive', $date),
      )
      ->set('first_name', '');

    $result = $queryBuilder->executeStatement();
    return $result;
  }
}
