<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord',
        'label' => 'number',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'text,html,identifier,to_address,letter_template_name',
        'iconfile' => 'EXT:wownaechtebuch/Resources/Public/Icons/tx_wownaechtebuch_domain_model_letterrecord.gif',
        'security' => [
            'ignorePageTypeRestriction' => true,
        ],
    ],
    'types' => [
        '1' => ['showitem' => 'number, subject, to_address, identifier, text, html, pdf, letter_template_name, letter, letter_template, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, hidden, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_wownaechtebuch_domain_model_letterrecord',
                'foreign_table_where' => 'AND {#tx_wownaechtebuch_domain_model_letterrecord}.{#pid}=###CURRENT_PID### AND {#tx_wownaechtebuch_domain_model_letterrecord}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'number' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.number',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.number.description',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'required' => true,
                'default' => 0
            ]
        ],
        'crdate' => [
            'label' => 'crdate',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime',
            ],
        ],
        'to_address' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.to_address',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_parentuser.to_address.description',
            'config' => [
                'type' => 'email',
                'nullable' => true,
                'default' => null
            ]
        ],
        'identifier' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_child.identifier',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_child.identifier.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'default' => ''
            ],
        ],
        'subject' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_child.subject',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_child.subject.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,null',
                'default' => ''
            ],
        ],
        'text' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.text',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.text.description',
            'config' => [
                'type' => 'text',
                'rows' => 10,
                'eval' => 'trim',
                'default' => ''
            ]
        ],
        'html' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.html',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.html.description',
            'config' => [
                'type' => 'text',
                'enableRichtext' => 'true',
                'eval' => 'trim',
                'default' => ''
            ]
        ],
        'pdf' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.pdf',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.pdf.description',
            'config' => [
                'type' => 'file',
                'required' => false,
                'allowed' => 'common-image-types',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
        'letter_template_name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.letter_template_name',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.letter_template_name.description',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'default' => ''
            ],
        ],
        'letter' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.letter',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.letter.description',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_letter',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],
        'letter_template' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.letter_template',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_letterrecord.letter_template.description',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_lettertemplate',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],
    
    ],
];
