<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun',
        'label' => 'number',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => '',
        'iconfile' => 'EXT:wownaechtebuch/Resources/Public/Icons/tx_wownaechtebuch_domain_model_treatmentrun.gif',
        'security' => [
            'ignorePageTypeRestriction' => true,
        ],
    ],
    'types' => [
        '1' => ['showitem' => 'number, start, end, date_of_archive, state, child, survey_records, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language, sys_language_uid, l10n_parent, l10n_diffsource, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, hidden, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'language',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_wownaechtebuch_domain_model_treatmentrun',
                'foreign_table_where' => 'AND {#tx_wownaechtebuch_domain_model_treatmentrun}.{#pid}=###CURRENT_PID### AND {#tx_wownaechtebuch_domain_model_treatmentrun}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'number' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.number',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.number.description',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'required' => true,
                'default' => 0
            ]
        ],
        'start' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.start',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.start.description',
            'config' => [
                'type' => 'datetime',
                'format' => 'date',
                'size' => 20,
                'nullable' => true,
                'default' => time()
            ],
        ],
        'end' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.end',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.end.description',
            'config' => [
                'type' => 'datetime',
                'format' => 'date',
                'size' => 20,
                'nullable' => true,
                'default' => null
            ],
        ],
        'date_of_archive' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.date_of_archive',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.date_of_archive.description',
            'config' => [
                'type' => 'datetime',
                'format' => 'datetime',
                'size' => 20,
                'nullable' => true,
                'default' => null
            ],
        ],
        'state' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.state',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.state.description',
            'config' => [
                'type' => 'number',
                'size' => 30,
                'required' => true,
                'default' => 0
            ]
        ],
        'child' => [
            'exclude' => false,
            'label' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.child',
            'description' => 'LLL:EXT:wownaechtebuch/Resources/Private/Language/locallang_db.xlf:tx_wownaechtebuch_domain_model_treatmentrun.child.description',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_child',
                'default' => 0,
                'minitems' => 0,
                'maxitems' => 1,
            ],

        ],
        'survey_records' => [
            'label' => 'Survey Records',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_wownaechtebuch_domain_model_surveyrecord',
                'foreign_field' => 'treatment_run',
            ],
        ],
    ],
];
