# KI-Briefing zur WOW-Naechtebuch-Extension #

## Ziel dieses Dokuments ##
- Eine zweite KI soll aus neutraler Sicht bewerten, wie stabil und vollständig die Extension ist.
- Sie soll konkrete Handlungsempfehlungen liefern, insbesondere zu den roten/orangenen Themen der Ampel.
- Fokus liegt ausschließlich auf dem TYPO3-Modul „Naechtebuch“ (Onlinebetreuung), nicht auf E-Commerce oder Shop-Prozessen.

## Wichtige Rahmenbedingungen ##
- Frontend-Registrierung & Login werden extern durch `fe_manager` umgesetzt. Für dieses Review genügt es, den Login als gegeben zu betrachten.
- Extension basiert auf TYPO3/Extbase, Ordnerstruktur ist Standard (Classes, Resources, Configuration, etc.).
- Aktuell nur Dokumentationsänderungen – keine Laufzeitänderungen seit dem letzten Review.
- Tests oder CI-Pipelines existieren bisher nicht; Review kann entsprechende Vorschläge machen.

## Funktionsumfang der Extension ##
- Eltern/Kinder-Verwaltung (CRUD, Archivierung, Reaktivierung).
- Fragebogen-Handling (Registrierungsfragebogen, medizinische Zusatzbögen für Case-Manager).
- Wöchentliches Protokoll („Naechtebuch“) inklusive Erinnerungs-Mail, manueller Nachpflege und PDF-Erstellung.
- Brief-Workflow (Entwurf → Freigabe → Versand inkl. PDF-Erstellung und Versand-Mail).
- Produktzuordnung (z. B. Klingelhose-Varianten) an Eltern bzw. Kinder.
- Scheduler-Kommando zur Anonymisierung archivierter Daten nach 90 Tagen (aktuell fehlerhaft).

## Aktuelle Bewertung (Ampel) ##
| Bereich | Status | Erläuterung |
| --- | --- | --- |
| Fragebogen (Initial & CM) | :large_orange_diamond: | Grundfunktion vorhanden; einige Fluid-Templates verlinken auf nicht existierende Actions. |
| Naechtebuch / Protokolle | :large_orange_diamond: | Funktionen laufen, Code enthält Altlasten (z. B. Methodenaufruf ohne `$this`, fehlende DTO-Initialisierung). |
| Briefe & PDF-Versand | :white_check_mark: | Workflow funktioniert, aber `LetterController::updateAction` fehlt trotz Konfiguration. |
| Admin-Aktionen (Archiv, Löschen) | :x: | Mehrere Backend-Buttons zeigen auf nicht implementierte Aktionen (`delete`, `edit`). |
| Automatische Benachrichtigungen | :large_orange_diamond: | Protokoll-Mails senden; Registrierungs-Mail deaktiviert, Entscheidung offen. |
| Datenschutz / Anonymisierung | :x: | Command/Service existiert, aber Datums-Logik falsch (vertauschte Vergleichsoperatoren). |
| Codequalität & Altlasten | :large_orange_diamond: | Backup-Dateien, auskommentierte Methoden, Encoding-Probleme in Templates. |

## Relevanteste technische Probleme ##
- Fehlende Actions trotz Plugin-Konfiguration: `SurveyRecordController::deleteForCM`, `LetterController::update`, `TreatmentRunController::edit`.
- Fluid-Templates verweisen auf nicht vorhandene Controller/Actions (insbesondere E-Mail-Templates, SurveyRecord-Listen, TreatmentRun-Listen).
- `ProtocolData` (DTO) initialisiert `ObjectStorage` nicht → potenzielle Null-Errors. Zudem ruft `addProtocolAction` `saveProtocolsForCMAction` ohne `$this` auf.
- `AnonymizationService` nutzt `>` statt `<` in Datumsvergleichen; Join-Statements sehen fehlerhaft aus.
- PDF-Erstellung nutzt absolute Pfade (`/html/typo3-composer/...`) → schlecht portierbar.
- Keine Tests/CI. Regressionen nicht abgesichert.

## Erwartung an die Zweitmeinung ##
- Review der identifizierten Problemstellen: Einschätzung, wie kritisch sie sind, und Vorschläge zur Absicherung (Tests, Refactorings).
- Zusätzliche Code-Smells oder Sicherheits-/Stabilitätsrisiken identifizieren.
- Konkrete Priorisierung: Welche Maßnahmen zuerst? Wie lässt sich Zeitaufwand begrenzen?
- Optional: Vorschläge für automatische Tests (PHPUnit/Codeception) oder Migrationsschritte zur Qualitätsverbesserung.

## Hinweise zur Navigation ##
- Controller liegen unter `Classes/Controller/*` (Primärdateien ohne Backup/TXT-Versionen betrachten).
- Templates unter `Resources/Private/Templates/*`, Partials unter `Resources/Private/Partials/*`.
- `ext_localconf.php` enthält Plugin-Konfigurationen (Plugin → Controller → Actions).
- Eventlistener & Services: `Classes/EventListener/*`, `Classes/Service/*`, `Classes/Command/*`.

## Erwartete Antwortform ##
Bitte in folgender Struktur antworten:
1. Wichtigste Kritikpunkte (geordnet nach Priorität, Gründe benennen).
2. Empfohlene Maßnahmen (kurz + optional Aufwandsschätzung).
3. Optional: Ergänzende Hinweise (z. B. Infrastruktur, Tests, Dokumentation).

Ziel ist eine actionable Roadmap mit Blick auf Stabilität und Funktionsabdeckung der Onlinebetreuung.
