# WOW Naechtebuch - Technische Uebersicht

## Prozessreferenz (Ablauf.pdf)
- Eltern registrieren sich (handled via fe_manager), bestaetigen die E-Mail und landen anschliessend im Naechtebuch.
- Ein initialer Fragebogen wird erzeugt und mit vorhandenen Questions gefuellt (`SurveyRecordController::fillAction`).
- Eltern pflegen wochenweise Protokolle; Case-Manager nutzen die *ForCM*-Varianten zum Nachpflegen.
- Neue Protokolle loesen PDF- und Mail-Events aus (`CreatePdfAfterNewLetterRecord`, `SendEmailAfterProtocolsSend`).
- Berater erstellen Antwortbriefe, die nach Freigabe als PDF gespeichert und an Eltern versendet werden.
- Ein Rueckfall erzeugt einen neuen Behandlungslauf (`TreatmentRunController::relapseAction`).
- Der geplante CLI-Job `AnonymizationCommand` soll archivierte Daten nach drei Monaten anonymisieren.

## Plugin-Konfiguration (ext_localconf.php)
- **Admin**: ParentUser, Child, SurveyRecord, LetterRecord, Letter (Backoffice-Features).
- **ClientManagament**: ParentUser, Child, TreatmentRun, SurveyRecord, ProductRecord (Case-Manager-Workflows).
- **UserProfile**: ParentUser, ProductRecord, Child, SurveyRecord, Letter, TreatmentRun (Eltern-Frontend).
- **Naechtebuch**: Child, SurveyRecord, TreatmentRun (Protokollbearbeitung).
- **Survey**: Child, Survey, SurveyRecord (Fragebogen-Backend).
- **Registration**: ProductRecord, Child, ParentUser, SurveyRecord (Registrierungsstrecke).
- Auffaelligkeiten: `deleteForCM` (SurveyRecord) und `update` (Letter) sind konfiguriert, aber nicht umgesetzt; `TreatmentRunController::editAction` fehlt.

## Fortschrittsampel (Stand Oktober 2025)
Hinweis: Registrierung und Login laufen im separaten Projekt "fe_manager" und werden hier nicht bewertet.

| Bereich | Ampel | Status | Naechste Schritte |
| --- | --- | --- | --- |
| Fragebogen (Initial & CM) | :large_orange_diamond: | Formulare lauffaehig, mehrere Frontend-Links zeigen jedoch auf nicht existierende Aktionen. | Fehlende Actions nachruesten oder Buttons entfernen, Testdatenlauf dokumentieren. |
| Naechtebuch / Protokolle | :large_orange_diamond: | Eltern- und CM-Fluesse funktionieren grundsaetzlich, Code enthaelt Altlasten (`addProtocol` ruft Methode ohne `$this`). | Methodenaufrufe bereinigen, DTO initialisieren, End-to-End-Test aufsetzen. |
| Briefe & PDF-Versand | :white_check_mark: | PDF-Erstellung und Versand laufen, Admin-Statuswechsel verfuegbar. | Fehlende `update`-Actions fuer Letter/LetterRecord nachruesten oder UI anpassen. |
| Admin-Aktionen (Archiv, Loeschen) | :x: | Mehrere Buttons verweisen auf nicht implementierte Controller-Aktionen. | Aktionen implementieren oder Buttons deaktivieren, Rechtepruefung definieren. |
| Automatische Benachrichtigungen | :large_orange_diamond: | Protokoll-Mail aktiv, Registrierungs-Mail derzeit deaktiviert. | Entscheiden, ob Registrierungsbenachrichtigung aktiv bleiben soll; Templates pruefen. |
| Datenschutz / Anonymisierung | :x: | Service vorhanden, aber Filterbedingungen falsch (arbeitet mit `>` statt `<`). | SQL-Bedingungen korrigieren, Testlauf aufsetzen, Scheduler-Task dokumentieren. |
| Codequalitaet & Altlasten | :large_orange_diamond: | Backup-Dateien, auskommentierte Methoden, Encoding-Probleme. | Code bereinigen, UTF-8 sicherstellen, ungenutzte Dateien entfernen. |

Legende: :white_check_mark: = funktionsfaehig, :large_orange_diamond: = eingeschraenkt funktionsfaehig, :x: = kritische Luecke.

## Controller, Aktionen und Plugin-Nutzung
### AnswerTypeController (Classes/Controller/AnswerTypeController.php)
Antworttypen
| Action | Implementiert | Plugins |
| --- | --- | --- |
| create | ja |  |
| delete | ja |  |
| edit | ja |  |
| list | ja |  |
| new | ja |  |
| update | ja |  |
> Keine offenen Aktionen bekannt.

### ChildController (Classes/Controller/ChildController.php)
Kinder
| Action | Implementiert | Plugins |
| --- | --- | --- |
| archive | ja | Admin |
| create | ja | ClientManagament, UserProfile |
| createForUser | ja | Registration |
| delete | ja | Admin, ClientManagament |
| edit | ja | Admin |
| editDocForCM | ja | ClientManagament |
| editForCM | ja | ClientManagament |
| index | ja |  |
| list | ja |  |
| listForAdmin | ja | Admin |
| listForCM | ja | ClientManagament |
| listForNaechtebuch | ja | Naechtebuch |
| listForSurvey | ja | Survey |
| listForTreatmentRun | ja | UserProfile |
| new | ja | ClientManagament, UserProfile |
| newForUser | ja | Registration |
| noUser | ja | Naechtebuch, Survey |
| show | ja | Admin, ClientManagament, UserProfile |
| unarchive | ja | Admin |
| update | ja |  |
| updateForCM | ja | ClientManagament |
> Keine offenen Aktionen bekannt.

### LetterController (Classes/Controller/LetterController.php)
Briefe
| Action | Implementiert | Plugins |
| --- | --- | --- |
| archive | ja | Admin |
| create | ja | Admin |
| delete | ja | Admin |
| edit | ja | Admin |
| index | ja |  |
| list | ja |  |
| listForAdmin | ja | Admin |
| listForAdminByChild | ja | Admin |
| listForParentUser | ja | UserProfile |
| new | ja | Admin |
| show | ja | Admin, UserProfile |
| unarchive | ja | Admin |
| update | nein | Admin |
> Offene Aktionen: update

### LetterRecordController (Classes/Controller/LetterRecordController.php)
Brief-Inhalte
| Action | Implementiert | Plugins |
| --- | --- | --- |
| create | ja | Admin |
| edit | ja | Admin |
| index | ja |  |
| list | ja |  |
| listForAdminByChild | ja | Admin |
| new | ja | Admin |
| show | ja | Admin |
| update | ja | Admin |
> Keine offenen Aktionen bekannt.

### ParentUserController (Classes/Controller/ParentUserController.php)
Elternkonten
| Action | Implementiert | Plugins |
| --- | --- | --- |
| archive | ja | Admin |
| create | ja | Admin, ClientManagament |
| delete | ja | Admin, ClientManagament |
| edit | ja | Admin |
| editForCM | ja | ClientManagament |
| editForParentUser | ja | UserProfile |
| editForUser | ja | Registration |
| index | ja |  |
| list | ja |  |
| listForAdmin | ja | Admin |
| listForCM | ja | ClientManagament |
| new | ja | Admin, ClientManagament |
| show | ja | Admin, ClientManagament, Registration, UserProfile |
| showLoggedUser | ja | UserProfile |
| unarchive | ja | Admin |
| update | ja | Admin, UserProfile |
| updateForCM | ja | ClientManagament |
| updateForParentUser | ja | UserProfile |
| updateForUser | ja | Registration |
> Keine offenen Aktionen bekannt.

### ProductRecordController (Classes/Controller/ProductRecordController.php)
Produkt-Buchungen
| Action | Implementiert | Plugins |
| --- | --- | --- |
| create | ja | UserProfile |
| createForCM | ja | ClientManagament |
| createForUser | ja | Registration |
| new | ja | UserProfile |
| newForCM | ja | ClientManagament |
| newForUser | ja | Registration |
> Keine offenen Aktionen bekannt.

### SurveyController (Classes/Controller/SurveyController.php)
Frageboegen
| Action | Implementiert | Plugins |
| --- | --- | --- |
| create | ja |  |
| edit | ja |  |
| index | ja |  |
| list | ja |  |
| listRequired | ja | Survey |
| new | ja |  |
| show | ja |  |
| update | ja |  |
> Keine offenen Aktionen bekannt.

### SurveyRecordController (Classes/Controller/SurveyRecordController.php)
Fragebogen- & Protokolldatensaetze
| Action | Implementiert | Plugins |
| --- | --- | --- |
| addProtocol | ja | ClientManagament |
| create | ja |  |
| createAndSaveProtocolForCM | ja | ClientManagament |
| createForCM | ja | ClientManagament |
| createProtocol | ja | ClientManagament, Naechtebuch |
| createProtocolForCM | ja | ClientManagament |
| deleteForCM | nein | ClientManagament |
| deleteProtocol | ja | Naechtebuch |
| deleteProtocolForCM | ja | ClientManagament |
| edit | ja | Survey, UserProfile |
| editForCM | ja | ClientManagament |
| editNext | ja |  |
| editNextProtocol | ja | Naechtebuch |
| editNextProtocolForCM | ja | ClientManagament |
| editPrevProtocol | ja | Naechtebuch |
| editPrevProtocolForCM | ja | ClientManagament |
| editProtocol | ja | Naechtebuch |
| editProtocolForCM | ja | ClientManagament |
| editRegistrationSurvey | ja | Registration |
| editRegistrationSurveyForCM | ja | ClientManagament |
| fill | ja | Survey, UserProfile |
| fillForCM | ja | ClientManagament |
| fillRegistrationSurvey | ja | Registration |
| fillRegistrationSurveyForCM | ja | ClientManagament |
| handleProtocolForCM | ja |  |
| index | ja |  |
| initializeSaveProtocols | ja |  |
| list | ja |  |
| listByChild | ja | Admin |
| listForAdminByChild | ja | Admin |
| listForCMByChild | ja | ClientManagament |
| listProtocol | ja |  |
| listProtocolForCM | ja |  |
| new | ja | ClientManagament |
| saveProtocols | ja | Naechtebuch |
| saveProtocolsForCM | ja | ClientManagament |
| saveProtocolsForCMTest | ja | ClientManagament |
| saveProtocolsKeepWeek | ja | Naechtebuch |
| sendProtocols | ja | Naechtebuch |
| sendProtocolsForCM | ja | ClientManagament |
| show | ja | Admin, ClientManagament, Survey, UserProfile |
| update | ja | Survey, UserProfile |
| updateForCM | ja | ClientManagament |
| updateRegistrationSurvey | ja | Registration |
| updateRegistrationSurveyForCM | ja | ClientManagament |
> Offene Aktionen: deleteForCM

### TreatmentRunController (Classes/Controller/TreatmentRunController.php)
Behandlungsverlaeufe
| Action | Implementiert | Plugins |
| --- | --- | --- |
| create | ja | ClientManagament |
| delete | ja | ClientManagament |
| edit | nein | ClientManagament |
| index | ja | ClientManagament |
| initializeUpdate | ja |  |
| initializeUpdateForCM | ja |  |
| list | ja | ClientManagament |
| new | ja | ClientManagament |
| relapse | ja | UserProfile |
| show | ja | ClientManagament |
| update | ja | Naechtebuch |
| updateForCM | ja | ClientManagament |
> Offene Aktionen: edit

## Templates und bekannte Auffaelligkeiten
- Resources/Private/Templates/AnswerType/List.html: `controller="AnswerType"`, `action="show"` -> action missing
- Resources/Private/Templates/Email/CreateAdminConfirmation.html: `controller="New"`, `action="confirmCreateRequest"` -> controller missing
- Resources/Private/Templates/Email/CreateNotify.html: `controller="New"`, `action="confirmCreateRequest"` -> controller missing
- Resources/Private/Templates/Email/CreateUserConfirmation.html: `controller="New"`, `action="confirmCreateRequest"` -> controller missing
- Resources/Private/Templates/Email/Invitation.html: `controller="Invitation"`, `action="delete"` -> controller missing
- Resources/Private/Templates/Email/Invitation.html: `controller="Invitation"`, `action="edit"` -> controller missing
- Resources/Private/Templates/Email/UpdateRequest.html: `controller="Edit"`, `action="confirmUpdateRequest"` -> controller missing
- Resources/Private/Templates/Email/zzz_CreateAdminConfirmation.html: `controller="New"`, `action="confirmCreateRequest"` -> controller missing
- Resources/Private/Templates/LetterRecord/Index.html: `controller="LetterRecord"`, `action="delete"` -> action missing
- Resources/Private/Templates/LetterRecord/List.html: `controller="LetterRecord"`, `action="delete"` -> action missing
- Resources/Private/Templates/LetterRecord/ListForAdminByChild.html: `controller="LetterRecord"`, `action="delete"` -> action missing
- Resources/Private/Templates/ParentUser/EditForCM.html: `controller="ProductRecord"`, `action="deleteForCM"` -> action missing
- Resources/Private/Templates/Survey/Index.html: `controller="Survey"`, `action="delete"` -> action missing
- Resources/Private/Templates/Survey/List.html: `controller="Survey"`, `action="delete"` -> action missing
- Resources/Private/Templates/SurveyRecord/Index.html: `controller="SurveyRecord"`, `action="delete"` -> action missing
- Resources/Private/Templates/SurveyRecord/List.html: `controller="SurveyRecord"`, `action="delete"` -> action missing
- Resources/Private/Templates/TreatmentRun/Index.html: `controller="TreatmentRun"`, `action="edit"` -> action missing
- Resources/Private/Templates/TreatmentRun/List.html: `controller="TreatmentRun"`, `action="edit"` -> action missing
- Resources/Private/Templates/TreatmentRun/Show.html: `controller="SurveyRecord"`, `action="delete"` -> action missing

## Weitere Risiken & Empfehlungen
- `ProtocolData` initialisiert seine `ObjectStorage`-Property nicht; das fuehrt zu Null-Fehlern in `saveProtocolsForCMAction`.
- `addProtocolAction` ruft `saveProtocolsForCMAction` aktuell ohne `$this` und damit ausserhalb des Controller-Kontexts.
- `AnonymizationService` nutzt unpassende Vergleichsoperatoren (arbeitet mit `>` fuer ein Datumsfeld, erwartet wird `<`).
- Die PDF-Erstellung arbeitet mit festen Pfaden (`/html/typo3-composer/...`); ein konfigurierbarer Ansatz ist notwendig.
- Email-Templates verweisen auf Controller-Namen (`New`, `Invitation`, `Edit`), die in der Extension nicht existieren.
- Encoding der Fluid-Templates ist gemischt (Umlaute werden teilweise falsch dargestellt); UTF-8 sicherstellen.
