$(document).ready(function () {
  // Funktion zum Setzen der Validierung und des Buttons
  function validateSerialNumber() {
      var selectedOption = $('#product option:selected');
      var regexPattern = selectedOption.data('regex');
      var serialNumber = $('#serialNumber').val();
      
      if (!regexPattern) {
          $('#serialNumber').removeClass('is-valid is-invalid');
          $('.invalid-feedback').hide();
          $('#validateButton').prop('disabled', true);
          return;
      }
      
      var regex = new RegExp(regexPattern);
      
      if (regex.test(serialNumber)) {
          $('#serialNumber').removeClass('is-invalid').addClass('is-valid');
          $('.invalid-feedback').hide();
          $('[type="submit"]').prop('disabled', false);
      } else {
          $('#serialNumber').removeClass('is-valid').addClass('is-invalid');
          $('.invalid-feedback').show();
          $('[type="submit"]').prop('disabled', true);
      }
  }
  
  // Validierung bei Auswahländerung im Select-Feld
  $('#product').change(function () {
      validateSerialNumber();
  });
  
  // Validierung bei Eingabeänderung im Serial Number-Feld
  $('#serialNumber').on('input', function () {
      validateSerialNumber();
  });

  validateSerialNumber();
});