
const config = [
  {
    questiontext: "Trocken durchgeschlafen",
    deactivate: "all"
  },
  {
    questiontext: "vom Harndrang geweckt",
    deactivate: "all"
  },
  // {
  //   questiontext: "nicht wach geworden",
  //   deactivate: ["Trocken durchgeschlafen", "vom Harndrang geweckt", "wach geworden"],
  //   mustBeFilled: {
  //     logic: "or",
  //     conditions: ["Unterhose", "Schlafanzug", "Bett"]
  //   }
  // },
  {
    questiontext: "wach geworden",
    deactivate: ["Trocken durchgeschlafen", "vom Harndrang geweckt", "nicht wach geworden"],
    mustBeFilled: {
      logic: "or",
      conditions: ["Unterhose", "Schlafanzug", "Bett"]
    }
  },


  {
    questiontext: "Unterhose",
    deactivate: [],
    activeWhen: {
      logic: "or",
      conditions: ["wach geworden", "nicht wach geworden"]
    }
  },
  {
    questiontext: "Schlafanzug",
    deactivate: ["Unterhose"],
    activeWhen: {
      logic: "or",
      conditions: ["wach geworden", "nicht wach geworden"]
    },
    checkWhenCheck: ["Unterhose"]
  },
  {
    questiontext: "Bett",
    deactivate: ["Schlafanzug", "Unterhose"],
    activeWhen: {
      logic: "or",
      conditions: ["wach geworden", "nicht wach geworden"]
    },
    checkWhenCheck: ["Schlafanzug", "Unterhose"]
  }

];

$(document).ready(function () {
  // Iteriere über die Konfigurationsobjekte
  $('input[type="checkbox"]').change(function () {
    var surveyRecord = $(this).attr('data-surveyrecord');
    config.forEach(function (rule) {
      if (rule.activeWhen) {
        let active = rule.activeWhen.logic == "and";
        rule.activeWhen.conditions.forEach(function (questiontext) {
          if (rule.activeWhen.logic == "and") active &= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
          else active |= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
        });

        $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').toggleClass('notAcitvated', !active);
        let disabled = $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').hasClass('deactivated');
        $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').prop('disabled', !active || disabled);
        if (!active) $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').prop('checked', false);
      }

      if (rule.mustBeFilled) {
        let mustBeFilled = rule.mustBeFilled.logic == "and";
        if ($('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + rule.questiontext + '"]').is(':checked')) {
          rule.mustBeFilled.conditions.forEach(function (questiontext) {
            if (rule.mustBeFilled.logic == "and") mustBeFilled &= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
            else mustBeFilled |= $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').is(':checked');
          });
        }
        else mustBeFilled = true;

        rule.mustBeFilled.conditions.forEach(function (questiontext) {
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').toggleClass('missing', !mustBeFilled);
        })
      }

    });
  })

  config.forEach(function (rule) {

    $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').change(function () {
      var surveyRecord = $(this).attr('data-surveyrecord');

      if ($(this).is(':checked')) {
        if (rule.deactivate === "all") {
          // Deaktiviere alle Checkboxen in der gleichen surveyrecord-Reihe außer der aktuellen
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"]').not(this).prop('disabled', true);
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"]').not(this).prop('checked', false);
        } else {
          // Deaktiviere spezifische Checkboxen in der gleichen surveyrecord-Reihe
          rule.deactivate.forEach(function (checkboxId) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').addClass('deactivated');
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').prop('disabled', true);
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').prop('checked', false);
          });
        }

        if (rule.checkWhenCheck && rule.checkWhenCheck.length >= 1) {
          rule.checkWhenCheck.forEach(function (questiontext) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').prop('checked', true);
          });
        }
      } else {
        // Aktiviere alle Checkboxen in der gleichen surveyrecord-Reihe
        if (rule.deactivate === "all") {
          $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"]').each(function (checkbox) {
            $(this).removeClass('deactivated');


            let notAcitvated = $(this).hasClass('notAcitvated');
            if (!notAcitvated) $(this).prop('disabled', false);
          });
        }
        else {
          rule.deactivate.forEach(function (checkboxId) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').removeClass('deactivated');


            let notAcitvated = $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').hasClass('notAcitvated', false);
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + checkboxId + '"]').prop('disabled', notAcitvated);
          });
        }

        if (rule.checkWhenCheck && rule.checkWhenCheck.length >= 1) {
          rule.checkWhenCheck.forEach(function (questiontext) {
            $('input[type="checkbox"][data-surveyrecord="' + surveyRecord + '"][data-questiontext="' + questiontext + '"]').prop('checked', false);
          });
        }
      }

    });


  });

  checkForActiveWhen();
});

function checkForActiveWhen() {
  config.forEach(function (rule) {
    if (rule.activeWhen) {
      let active = rule.activeWhen.logic == "and";
      rule.activeWhen.conditions.forEach(function (questiontext) {
        if (rule.activeWhen.logic == "and") active &= $('input[type="checkbox"][data-questiontext="' + questiontext + '"]').is(':checked');
        else active |= $('input[type="checkbox"][data-questiontext="' + questiontext + '"]').is(':checked');
      })

      $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').toggleClass('notAcitvated', !active);
      let disabled = $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').hasClass('notAcitvated', !active);
      $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').prop('disabled', !active || disabled);
      if (!active || disabled) $('input[type="checkbox"][data-questiontext="' + rule.questiontext + '"]').prop('checked', false);
    }
  });
}


//
// Auto Date
//


$(document).ready(function () {

  if ($('#treatmentRun-start').data('treatmentrunstart')) {
    $('[type="date"]').each(function () {
      let day = $(this).closest('.protocol-record').data('day') - 1;
      let week = $(this).closest('.protocol-record').data('week') - 1;
      let date = new Date($('#treatmentRun-start').data('treatmentrunstart'));

      $(this).val(date.addDays(7 * week + day).toISOString().split('T')[0]);
      $(this).prop('readonly', true);

    });
  }
});

Date.prototype.addDays = function (days) {
  var date = new Date(this.valueOf());
  date.setDate(date.getDate() + days);
  return date;
}

// // Validierung vor dem Senden des Formulars
// $('[name="protocolData"]').on('submit', function(event) {
//   let allRowsValid = true;

//   // Überprüfe jede Zeile mit der Klasse .protocol-record
//   $('.protocol-record').each(function() {
//     let hasCheckedCheckbox = $(this).find('input[type="checkbox"]:checked').length > 0;

//     if (!hasCheckedCheckbox) {
//       allRowsValid = false;
//       // Zeige eine Fehlermeldung oder markiere die ungültige Zeile
//       $(this).css('background-color', '#f8d7da'); // Fehlerhervorhebung
//     } else {
//       $(this).css('background-color', ''); // Entferne Fehlerhervorhebung
//     }
//   });

//   // Wenn eine Zeile keine angekreuzte Checkbox hat, verhindere das Absenden
//   if (!allRowsValid) {
//     event.preventDefault();
//     alert('Bitte füllen Sie alle Protokolle vollständig aus, indem Sie mindestens eine Box pro Zeile ankreuzen.');
//   }
// });


// // Senden von Protokollen
// $('.sent').on('click', function(event) {
//   let allRowsValid = true;

//   // Überprüfe jede Zeile mit der Klasse .protocol-record
//   $('.protocol-record').each(function() {
//     let hasCheckedCheckbox = $(this).find('input[type="checkbox"]:checked').length > 0;

//     if (!hasCheckedCheckbox) {
//       allRowsValid = false;
//       // Zeige eine Fehlermeldung oder markiere die ungültige Zeile
//       $(this).css('background-color', '#f8d7da'); // Fehlerhervorhebung
//     } else {
//       $(this).css('background-color', ''); // Entferne Fehlerhervorhebung
//     }
//   });

//   // Wenn eine Zeile keine angekreuzte Checkbox hat, verhindere das Absenden
//   if (!allRowsValid) {
//     event.preventDefault();
//     alert('Bitte füllen Sie alle Protokolle vollständig aus, indem Sie mindestens eine Box pro Zeile ankreuzen.');
//   }
// });


// $('.plus').click(function(){
//   let newRow = $(this).closest('tr').clone();
//   newRow.find('input').val(''); // Setzt alle Input-Felder zurück
//   newRow.insertAfter($(this).closest('tr'));
// });
// $('.minus').click(function() {
//   $(this).closest('tr').remove();
// });

$('input[data-questiontext="wach geworden"]').change(function () {
  console.log('chgecker');
});
$('input[data-questiontext="nicht wach geworden"]').change(function () {
  console.log('chgecker2');
  $(this).parents('tr').addClass('test')
  $(this).parents('tr').find('input[data-questiontext="Unterhose"]').toggleClass('someclass');
  $(this).parents('tr').find('input[data-questiontext="Schlafanzug"]').toggleClass('someclass');
  $(this).parents('tr').find('input[data-questiontext="Bett"]').toggleClass('someclass');
  console.log($(this).parents('tr').find('[data-questiontext="Unterhose"]'));

});

document.addEventListener('DOMContentLoaded', function () {
    // Alle Zeilen (z.B. tr), die die Inputs und den Button enthalten
    const rows = document.querySelectorAll('tr');

    rows.forEach(row => {
        const button = row.querySelector('.plus-ajax');
        const inputs = row.querySelectorAll('input[data-questiontext="Klingelhose nicht getragen"], input[data-questiontext="Trocken durchgeschlafen"]');

        if (!button || inputs.length === 0) return; // Falls in der Zeile nichts Relevantes ist

        function updateButtonState() {
            let shouldDisable = false;
            inputs.forEach(input => {
                if (input.checked) {
                    shouldDisable = true;
                }
            });
            button.disabled = shouldDisable;
        }

        inputs.forEach(input => {
            input.addEventListener('change', updateButtonState);
        });

        // Initial prüfen
        updateButtonState();
    });
});

document.querySelectorAll('.btn.plus-ajax').forEach(button => { // Zeile 270 (Beginn des forEach)
  button.addEventListener('click', function (e) {
    e.preventDefault();

    const child = this.dataset.child;
    const day = this.dataset.day;
    const week = this.dataset.week;
    const clickedButton = this; // Referenz auf den geklickten Button

    // Hinweis-Div erstellen und anzeigen
    const saveIndicator = document.createElement('div');
    saveIndicator.id = 'save-indicator';
    saveIndicator.innerHTML = `
      <div style="
        position: fixed;
        top: 20px;
        right: 20px;
        background-color: #007bff;
        color: white;
        padding: 15px 20px;
        border-radius: 5px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        z-index: 9999;
        font-family: Arial, sans-serif;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 10px;
      ">
        <div style="
          width: 20px;
          height: 20px;
          border: 2px solid #ffffff;
          border-top: 2px solid transparent;
          border-radius: 50%;
          animation: spin 1s linear infinite;
        "></div>
        Daten werden gespeichert...
      </div>
      <style>
        @keyframes spin {
          0% { transform: rotate(0deg); }
          100% { transform: rotate(360deg); }
        }
      </style>
    `;

    // Hinweis zum Body hinzufügen
    document.body.appendChild(saveIndicator);

    const url = `https://stero-neu.wow-internet.de`
              + `/kundenpflege?type=123456`
              + `&tx_wownaechtebuch_clientmanagament[action]=createProtocolForCM`
              + `&tx_wownaechtebuch_clientmanagament[child]=${child}`
              + `&tx_wownaechtebuch_clientmanagament[controller]=SurveyRecord`
              + `&tx_wownaechtebuch_clientmanagament[day]=${day}`
              + `&tx_wownaechtebuch_clientmanagament[week]=${week}`;

    console.log("Requesting URL:", url);

    fetch(url) // Gibt ein Promise (P1) zurück
      .then(response => { // Callback für P1. Wird ausgeführt, wenn P1 settled.
        console.log("Raw response object:", response);
        if (!response.ok) {
            throw new Error(`Network response was not ok, status: ${response.status}`); // Wirft Fehler, der von .catch() gefangen wird
        }
        return response.text(); // Gibt ein neues Promise (P2) zurück
      }) // Das Ergebnis dieses .then() ist P2
      .then(html => { // Callback für P2. Wird ausgeführt, wenn P2 mit dem HTML-Text resolved.
        console.log("Received HTML content:", html); // html ist der Text von der AJAX-Antwort

        // JETZT das Formular auf der aktuellen Seite absenden
        const form = clickedButton.closest('form'); // Finde das Formular, zu dem der Button gehört
                                                    // ODER: const form = document.getElementById('meineFormId');
        if (form) {
          console.log("Submitting form on current page:", form);
          form.submit(); // Sendet das Formular ab. Diese Operation ist synchron und gibt kein Promise zurück.
          // Hinweis bleibt aktiv bis die Seite neu geladen wird
        } else {
          console.warn("Button is not inside a form, or specified form not found.");
          // Hinweis nur entfernen, wenn kein Form-Submit stattfindet
          const indicator = document.getElementById('save-indicator');
          if (indicator) {
            indicator.remove();
          }
        }
      })
      .catch(error => {
        console.error('Error during fetch or in .then() blocks:', error);
        
        // Hinweis entfernen auch bei Fehler
        const indicator = document.getElementById('save-indicator');
        if (indicator) {
          indicator.remove();
        }
        
        alert('Fehler: ' + error.message);
      });
  });
});


document.querySelectorAll('.btn.plus-ajax.user').forEach(button => {
  button.addEventListener('click', function (e) {
    e.preventDefault();

    // 1. Die fertige, korrekte URL aus dem data-Attribut holen
    const ajaxUrl = this.dataset.ajaxUrl;
    if (!ajaxUrl) {
      console.error('Das Attribut "data-ajax-url" fehlt am Button.');
      alert('Fehler: Konnte die Anfrage-URL nicht erstellen.');
      return;
    }
    
    // 2. Referenz auf den Submit-Button holen (unverändert)
    const keepWeekSubmitButton = document.getElementById('keepWeekButton');
    if (!keepWeekSubmitButton) {
      console.error('Der Submit-Button mit der ID "keepWeekButton" wurde nicht gefunden.');
      return;
    }

    // 3. Indikator anzeigen (unverändert)
    const saveIndicator = document.createElement('div');
    saveIndicator.id = 'save-indicator';
    saveIndicator.innerHTML = `<div>...</div>`; // Dein Spinner-HTML
    document.body.appendChild(saveIndicator);

    console.log("Requesting URL from data-attribute:", ajaxUrl);

    // 4. Den fetch-Aufruf mit der korrekten URL ausführen
    fetch(ajaxUrl)
      .then(response => {
        if (!response.ok) {
          // Versuche, eine Fehlermeldung vom Server zu bekommen, falls vorhanden
          return response.text().then(text => { 
            throw new Error(`Network response was not ok, status: ${response.status}. Server says: ${text}`);
          });
        }
        return response.text();
      })
      .then(html => {
        // Der AJAX-Aufruf war erfolgreich. Du kannst hier den HTML-Inhalt loggen oder verarbeiten,
        // aber für dein Ziel reicht die Erfolgsbestätigung.
        console.log("AJAX 'createProtocol' war erfolgreich. Sende jetzt das Hauptformular ab.");
        
        // Simuliere den Klick, um die Seite neu zu laden
        keepWeekSubmitButton.click();
      })
      .catch(error => {
        console.error('Fehler während des AJAX-Aufrufs:', error);
        const indicator = document.getElementById('save-indicator');
        if (indicator) {
          indicator.remove();
        }
        alert('Fehler beim Ausführen der Aktion: ' + error.message);
      });
  });
});


document.addEventListener('DOMContentLoaded', function () {

    // Finde alle relevanten Zeilen (<tr>) in der Tabelle.
    // Wir nehmen die Zeile als Ausgangspunkt, da alle Aktionen pro Zeile stattfinden.
    const protocolRows = document.querySelectorAll('.protocol-record');

    protocolRows.forEach(function (row) {
        // Finde die drei relevanten Checkboxen innerhalb jeder Zeile.
        const bettCheckbox = row.querySelector('input[data-questiontext="Bett"]');
        const schlafanzugCheckbox = row.querySelector('input[data-questiontext="Schlafanzug"]');
        const unterhoseCheckbox = row.querySelector('input[data-questiontext="Unterhose"]');

        // Stelle sicher, dass alle drei Checkboxen existieren, bevor wir fortfahren.
        if (!bettCheckbox || !schlafanzugCheckbox || !unterhoseCheckbox) {
            return; // Nächste Zeile
        }

        // --- Regel 1: "Bett" steuert "Schlafanzug" und "Unterhose" ---
        bettCheckbox.addEventListener('change', function () {
            const isChecked = this.checked;

            // Setze den Status für beide abhängigen Checkboxen.
            schlafanzugCheckbox.checked = isChecked;
            unterhoseCheckbox.checked = isChecked;
        });


        // --- Regel 2: "Schlafanzug" steuert "Unterhose" ---
        schlafanzugCheckbox.addEventListener('change', function () {
            // Wenn "Schlafanzug" aktiviert wird, muss auch "Unterhose" aktiviert werden.
            if (this.checked) {
                unterhoseCheckbox.checked = true;
            }
            // HINWEIS: Wir fügen hier bewusst keine "else"-Bedingung hinzu.
            // Wenn der Benutzer "Schlafanzug" deaktiviert, soll "Unterhose" nicht
            // automatisch mit deaktiviert werden. Das wäre sonst verwirrend.
            // Der Benutzer kann "Unterhose" unabhängig deaktivieren.
        });
    });
});