if (window.jQuery) {
  $(document).ready(function () {
    initializeSurvey();
  });
} else {
  alert("jQuery not defiend. Survey may not Work!");
}


function initializeSurvey() {

  $('.substitut-field').change((e) => {
    $('.substitut-field').each( function(element) {
      updateHiddenField($(this).data('question'), $(this));
    });
    $('.substitut-toggler-field').each( function(element) {
      toggleField($( this ).data('substitut'), $( this ).is(':checked'));
    });  
  });
  $('.substitut-toggler-field').change((e) => {
    toggleField($(e.target).data('substitut'), $(e.target).is(':checked'));
    $('.substitut-field').each( function(element) {
      updateHiddenField($(this).data('question'), $(this));
    });
  });
  $('.substitut-toggler-field').each( function(element) {
    toggleField($( this ).data('substitut'), $( this ).is(':checked'));
  });

}


// Initialize an object to store the values for each hidden field
let hiddenFields = {};

// Function to update the hidden input field based on the changed input
function updateHiddenField(hiddenFieldId, changed) {
  // Select the hidden field element
  let hiddenField = $(`#${hiddenFieldId}`);

  // Initialize the entry in hiddenFields object if not already present
  hiddenFields[hiddenFieldId] = hiddenFields[hiddenFieldId] || {};

  // Check if the changed element is a checkbox
  if (changed.is(':checkbox')) {
    // Update the value in the hiddenFields object for this checkbox
    hiddenFields[hiddenFieldId][changed.attr('id')] = changed.is(':checked') ? changed.val() : '';

    // Check if the changed element is a text input
  } else if (changed.is(':text')) {
    // Update the value in the hiddenFields object for this text input
    hiddenFields[hiddenFieldId][changed.attr('id')] = changed.val();

  } else if (changed.is(':radio')) {
    // Update the value in the hiddenFields object for this text input
    hiddenFields[hiddenFieldId][changed.attr('id')] = changed.is(':checked') ? changed.val() : '';

  }
  else {    
    let label = ''
    if (changed.data('question-unit')) label = changed.data('question-unit')
    hiddenFields[hiddenFieldId][changed.attr('id')] = changed.val() + label;
    // console.log(hiddenField.val());
  }

  // Concatenate all values from the hiddenFields object into a single string
  let concatenatedValues = Object.values(hiddenFields[hiddenFieldId]).filter(val => val).join(', ');

  // Update the hidden field's value with the concatenated string
  hiddenField.val(concatenatedValues);
  
}

function toggleField(field, isActive) {
  if (!isActive) $(`#${field}`).val('');
  $(`#${field}`).toggle(isActive).prop('disabled', !isActive);

  updateHiddenField($(`#${field}`).data('question'), $(`#${field}`))
}

// Next and prev page
$(document).ready(function() {
  $(".page-prev").on('click', function () {
    let pageNumber = $(this).data('page-number');
    let prevTab;

    do {
      pageNumber--;
      prevTab = document.querySelector(`#simple-tab-${pageNumber}`);
      
    } while ($(prevTab).prop('disabled'));

    let tab = new bootstrap.Tab(prevTab);
    tab.show();
  });
  $(".page-next").on('click', function () {
    let pageNumber = $(this).data('page-number');
    let nextTab;
    do {
      pageNumber++;
      nextTab = document.querySelector(`#simple-tab-${pageNumber}`);
      
    } while ($(nextTab).prop('disabled'));

    let tab = new bootstrap.Tab(nextTab);
    tab.show();
  });
});

// Sonderfälle

$(document).ready(function() {
  // Funktion zum Überprüfen des Status des Radio-Buttons
  function toggleTab() {
    if ($('[value="tagsüber [auch ab und zu] und nachts"]').is(':checked')) {
      $('#simple-tab-1').removeClass('bg-light');
      $('#simple-tab-1').prop('disabled', false);
    } else {
      $('#simple-tab-1').addClass('bg-light');
      $('#simple-tab-1').prop('disabled', true);
    }
  }

  function toggleInput() {
    if ($('[value="nachts"]').is(':checked')) {
      $('[data-question-parent="Wann war Ihr Kind tagsüber trocken?"]').removeClass('d-none');
      $('[data-question-parent="Wann war Ihr Kind tagsüber trocken?"]').prop('disabled', false);
    } else {
      $('[data-question-parent="Wann war Ihr Kind tagsüber trocken?"]').addClass('d-none');
      $('[data-question-parent="Wann war Ihr Kind tagsüber trocken?"]').prop('disabled', true);
    }
  }

  // Beim Laden der Seite überprüfen
  toggleTab();
  

  // Überwachen, ob der Radio-Button geändert wird
  $('[value="tagsüber [auch ab und zu] und nachts"]').change(function() {
    toggleTab();
    toggleInput();
  });
  $('[value="nachts"]').change(function() {
    toggleTab();
    toggleInput();
  });


  $('[value="Ich weiß es nicht"').change(function() {
    let questionNumber = $(this).data('question');

    console.log(questionNumber);
if ($(this).is(':checked')) {
        $(`[data-question="${questionNumber}"]`).not(this).prop('disabled', true);
    } else {
        $(`[data-question="${questionNumber}"]`).prop('disabled', false);
    }
  });
});

//Units
$(document).ready(function() {
  // Set step size for milliliter
  $('[data-question-unit="Milliliter"]').attr('step', 50)
  
  // Max of 7 days a Week
  $('[data-question-unit="Tag(e) in der Woche"]').attr('max', 7)
  $('[data-question-unit="Tag(e) in der Woche"]').change(function () {
    $(this).val($(this).val() > 7 ? 7 : $(this).val());
  } )
});




$(document).ready(function() {

  function toggleInput() {
    console.log("Hello World!");
    
    if (!$('[value="Seit der Geburt"]').is(':checked')) {
      $('[data-question-parent="Sehen Sie bei Ihrem Kind Gründe für das Wiedereinnässen? [Mehrfachnennung möglich]"]').removeClass('d-none');
      $('[data-question-parent="Sehen Sie bei Ihrem Kind Gründe für das Wiedereinnässen? [Mehrfachnennung möglich]"]').prop('disabled', false);
    } else {
      $('[data-question-parent="Sehen Sie bei Ihrem Kind Gründe für das Wiedereinnässen? [Mehrfachnennung möglich]"]').addClass('d-none');
      $('[data-question-parent="Sehen Sie bei Ihrem Kind Gründe für das Wiedereinnässen? [Mehrfachnennung möglich]"]').prop('disabled', true);
    }
  }
  
  let name = $('[value="Seit der Geburt"]').attr('name');
  console.log(name);
  
  // Überwachen, ob der Radio-Button geändert wird
  $(`[name="${name}"]`).change(function() {
    toggleInput();
  });
});


// Arzt-Info Pflicht
$(function(){
  $('[data-question-parent="Vollständiger Name des Arztes"] input').prop('required', true);
  // $('[data-question-parent="Vollständiger Name des Arztes"] input').addClass('missing');
  $('[data-question-parent="Vollständiger Name des Arztes"]').find('.lead').append('*');

  $('[data-question-parent="Straße und Hausnummer des Arztes"] input').prop('required', true);
  // $('[data-question-parent="Straße und Hausnummer des Arztes"] input').addClass('missing');
  $('[data-question-parent="Straße und Hausnummer des Arztes"]').find('.lead').append('*');

  $('[data-question-parent="Postleitzahl des Arztes"] input').prop('required', true);
  // $('[data-question-parent="Postleitzahl des Arztes"] input').addClass('missing');
  $('[data-question-parent="Postleitzahl des Arztes"]').find('.lead').append('*');

  $('[data-question-parent="Ort des Arztes"] input').prop('required', true);
  // $('[data-question-parent="Ort des Arztes"] input').addClass('missing');
  $('[data-question-parent="Ort des Arztes"]').find('.lead').append('*');

  $('[data-question-parent="Vorname des Kindes"] input').prop('required', true);
  // $('[data-question-parent="Vorname des Kindes"] input').addClass('missing');
  $('[data-question-parent="Vorname des Kindes"]').find('.lead').append('*');

  $('[data-question-parent="Geschlecht"] input').prop('required', true);
  // $('[data-question-parent="Geschlecht"] input').addClass('missing');
  $('[data-question-parent="Geschlecht"]').find('.lead').append('*');

  $('[data-question-parent="Geburtsdatum des Kindes"] input').prop('required', true);
  // $('[data-question-parent="Geburtsdatum des Kindes"] input').addClass('missing');
  $('[data-question-parent="Geburtsdatum des Kindes"]').find('.lead').append('*');
})