CREATE TABLE tx_wownaechtebuch_domain_model_parentuser (
	gender 						int(11) unsigned DEFAULT '0' NOT NULL,
	first_name 				varchar(255) DEFAULT NULL,
	last_name 				varchar(255) DEFAULT NULL,
	email							varchar(255) DEFAULT NULL,
	city 							varchar(255) DEFAULT NULL,
	zip 							varchar(255) DEFAULT NULL,
	region 						varchar(255) DEFAULT NULL,
	country 					varchar(255) DEFAULT NULL,
	address 					varchar(255) DEFAULT NULL,
	date_of_archive 	int(11) NOT NULL DEFAULT '0',
	state 						int(11) NOT NULL DEFAULT '0',
	childs 						int(11) unsigned DEFAULT '0' NOT NULL,
	user							int(11) unsigned DEFAULT '0',
);

CREATE TABLE tx_wownaechtebuch_domain_model_child (
	first_name 									varchar(255) DEFAULT NULL,
	last_name 									varchar(255) DEFAULT NULL,
	date_of_archive 						int(11) NOT NULL DEFAULT '0',
	state 											int(11) NOT NULL DEFAULT '0',
	parent_user 								int(11) unsigned DEFAULT '0',
	registration_survey_record 	int(11) unsigned DEFAULT '0',
	treatment_runs							int(11) unsigned DEFAULT '0' NOT NULL,
);

CREATE TABLE tx_wownaechtebuch_domain_model_treatmentrun (
	number 						int(11) NOT NULL DEFAULT '0',
	start 						int(11) NOT NULL DEFAULT '0',
	end 							int(11) NOT NULL DEFAULT '0',
	date_of_archive 	int(11) NOT NULL DEFAULT '0',
	state 						int(11) NOT NULL DEFAULT '0',
	child 						int(11) unsigned DEFAULT '0',
	survey_records		int(11) unsigned DEFAULT '0' NOT NULL,
);

CREATE TABLE tx_wownaechtebuch_domain_model_productrecord (
	serial_number 		varchar(255) NOT NULL DEFAULT '',
	protuct_name 			varchar(255) NOT NULL DEFAULT '',
	child 						int(11) unsigned DEFAULT '0',
	product 					int(11) unsigned DEFAULT '0'
);

CREATE TABLE tx_wownaechtebuch_domain_model_product (
	name 									varchar(255) NOT NULL DEFAULT '',
	description 					varchar(255) NOT NULL DEFAULT '',
	serial_number_schema 	varchar(255) NOT NULL DEFAULT ''
);

CREATE TABLE tx_wownaechtebuch_domain_model_letter (
	date_of_archive 	int(11) NOT NULL DEFAULT '0',
	state 						int(11) NOT NULL DEFAULT '0',
	treatment_run 		int(11) unsigned DEFAULT '0',
	sent 							smallint(1) unsigned NOT NULL DEFAULT '0',
);

CREATE TABLE tx_wownaechtebuch_domain_model_letterrecord (
	crdate 								int(11) DEFAULT '0' NOT NULL,
	
	number 								int(11) NOT NULL DEFAULT '0',
	text 									text NOT NULL DEFAULT '',
	identifier 						text NOT NULL DEFAULT '',
	to_address  					text NOT NULL DEFAULT '',
	subject 							text NOT NULL DEFAULT '',
	html 									text NOT NULL DEFAULT '',
	pdf 									int(11) unsigned 	NOT NULL DEFAULT '0',
	letter_template_name 	varchar(255) NOT NULL DEFAULT '',
	letter 								int(11) unsigned DEFAULT '0',
	letter_template 			int(11) unsigned DEFAULT '0'
);

CREATE TABLE tx_wownaechtebuch_domain_model_lettertemplate (
	name varchar(255) NOT NULL DEFAULT '',
	text text NOT NULL DEFAULT '',
	html text NOT NULL DEFAULT ''
);

CREATE TABLE tx_wownaechtebuch_domain_model_surveyrecord (
	survey_name 			varchar(255) NOT NULL DEFAULT '',
	date_of_archive 	int(11) NOT NULL DEFAULT '0',
	state 						int(11) NOT NULL DEFAULT '0',
	week	 						int(11) NOT NULL DEFAULT '0',
	day		 						int(11) NOT NULL DEFAULT '0',
	treatment_run 		int(11) unsigned DEFAULT '0',
	survey 						int(11) unsigned DEFAULT '0',
	question_records	int(11) unsigned DEFAULT '0' NOT NULL,
);

CREATE TABLE tx_wownaechtebuch_domain_model_questionrecord (
	question_page			int(11) NOT NULL DEFAULT '0',
	question_text 		varchar(255) NOT NULL DEFAULT '',
	question_answere 	varchar(255) NOT NULL DEFAULT '',
	question_options 	json DEFAULT NULL,
	is_sensetive 			smallint(1) unsigned NOT NULL DEFAULT '0',
	survey_record 		int(11) unsigned DEFAULT '0',
	answer_type 			int(11) unsigned DEFAULT '0'
);

CREATE TABLE tx_wownaechtebuch_domain_model_survey (
	name 							varchar(255) NOT NULL DEFAULT '',
	description 			text NOT NULL DEFAULT '',
	questions					int(11) unsigned DEFAULT '0' NOT NULL,
);

CREATE TABLE tx_wownaechtebuch_domain_model_question (
	page							int(11) NOT NULL DEFAULT '0',
	text 							varchar(255) NOT NULL DEFAULT '',
	options 					json DEFAULT NULL,
	survey 						int(11) unsigned DEFAULT '0',
	answer_type				int(11) unsigned DEFAULT '0'
);

CREATE TABLE tx_wownaechtebuch_domain_model_answertype (
	html					varchar(255) NOT NULL DEFAULT '',
	validator 		varchar(255) DEFAULT '' NOT NULL,
	is_sensetive 	smallint(1) unsigned NOT NULL DEFAULT '0'
);

CREATE TABLE tx_wownaechtebuch_domain_model_survey (
	categories 		int(11) unsigned DEFAULT '0' NOT NULL
);
