<?php
session_start();

// 1. Sicherheitscheck: Ist der Benutzer eingeloggt?
if (!isset($_SESSION['is_admin_logged_in']) || $_SESSION['is_admin_logged_in'] !== true) {
    http_response_code(403); // Forbidden
    die("Zugriff verweigert. Bitte einloggen.");
}

// 2. Erlaubte Ordner (genau wie in view_folder.php - Konsistenz ist wichtig!)
$allowedFolders = [
    'layers',
    'generated_images'
    // Füge hier weitere Ordner hinzu, wenn nötig
];

// 3. Parameter abrufen und validieren
$folderKey = $_GET['folder'] ?? '';
$fileName  = $_GET['file'] ?? '';

if (empty($folderKey) || empty($fileName)) {
    http_response_code(400); // Bad Request
    die("Fehlende Parameter: Ordner oder Dateiname nicht angegeben.");
}

// 4. Sicherheitscheck: Ist der angeforderte Ordner erlaubt?
if (!in_array($folderKey, $allowedFolders)) {
    http_response_code(403); // Forbidden
    die("Zugriff auf diesen Ordner ('".htmlspecialchars($folderKey)."') ist nicht erlaubt.");
}

// 5. Sicherheitscheck: Dateinamen bereinigen, um Path Traversal zu verhindern
// basename() entfernt alle Pfadinformationen und gibt nur den Dateinamen zurück.
// Dies ist eine sehr wichtige Sicherheitsmaßnahme!
$fileName = basename($fileName);
if (empty($fileName) || $fileName === '.' || $fileName === '..') {
    http_response_code(400); // Bad Request
    die("Ungültiger Dateiname.");
}

// 6. Vollständigen Pfad zur Datei konstruieren
// Geht davon aus, dass 'admin' ein Unterordner des Web-Roots ist.
$filePath = dirname(__DIR__) . '/' . $folderKey . '/' . $fileName;

// 7. Sicherheitscheck: Existiert die Datei und ist sie lesbar?
if (!file_exists($filePath) || !is_readable($filePath) || is_dir($filePath)) {
    http_response_code(404); // Not Found
    die("Datei nicht gefunden oder nicht lesbar: " . htmlspecialchars($fileName));
}

// 8. Datei zum Download anbieten
// Header setzen, um den Browser zum Download zu zwingen
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream'); // Generischer Mime-Typ für Downloads
header('Content-Disposition: attachment; filename="' . $fileName . '"'); // Schlägt den Dateinamen vor
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filePath));

// Puffer leeren, um sicherzustellen, dass keine vorherigen Ausgaben den Download stören
ob_clean();
flush();

// Dateiinhalt ausgeben
readfile($filePath);
exit; // Wichtig, um sicherzustellen, dass kein weiterer Code ausgeführt wird

?>