<?php
session_start();

if (!isset($_SESSION['is_admin_logged_in']) || $_SESSION['is_admin_logged_in'] !== true) {
    header("Location: index.php");
    exit;
}

$allowedFolders = [
    'layers'           => 'Layers',
    'generated_images' => 'Generierte Bilder'
];

$folderKey = $_GET['folder'] ?? '';
$folderDisplayName = 'Unbekannter Ordner';
$currentDirectoryPath = '';
$currentWebPath = '';
$folderContentHtml = '<p>Kein gültiger Ordner ausgewählt oder Ordner nicht gefunden.</p>';

// Nachrichten für den Benutzer (z.B. nach Löschvorgang)
$message = $_SESSION['delete_message'] ?? '';
unset($_SESSION['delete_message']);


if ($folderKey && array_key_exists($folderKey, $allowedFolders)) {
    $folderDisplayName = $allowedFolders[$folderKey];
    $currentDirectoryPath = dirname(__DIR__) . '/' . $folderKey . '/';
    $currentWebPath = '../' . $folderKey . '/';

    if (is_dir($currentDirectoryPath)) {
        $items = scandir($currentDirectoryPath);
        $items = array_filter($items, function($item) {
            return !in_array($item, ['.', '..']);
        });
        // Optional: Sortieren, z.B. Ordner zuerst
        // usort($items, function($a, $b) use ($currentDirectoryPath) {
        //     $aIsDir = is_dir($currentDirectoryPath . $a);
        //     $bIsDir = is_dir($currentDirectoryPath . $b);
        //     if ($aIsDir !== $bIsDir) {
        //         return $aIsDir ? -1 : 1; // Ordner vor Dateien
        //     }
        //     return strcasecmp($a, $b); // Alphabetisch
        // });


        if (!empty($items)) {
            $folderContentHtml = '<ul class="file-list">';
            foreach ($items as $item) {
                $itemServerPath = $currentDirectoryPath . $item;
                $itemWebAccessPath = $currentWebPath . rawurlencode($item);
                $previewHtml = '';
                $downloadLink = '';
                $deleteLink = ''; // Initialisiere Delete-Link

                if (is_dir($itemServerPath)) {
                    $type = '[Ordner]';
                    $previewHtml = '<span class="item-icon folder-icon">📁</span>';
                    // Lösch-Link für Ordner
                    $deleteLink = '<a href="delete_item.php?folder=' . urlencode($folderKey) . '&item=' . urlencode($item) . '&type=dir" class="delete-btn" onclick="return confirmDelete(\'' . htmlspecialchars($item, ENT_QUOTES) . '\', true);" title="Ordner löschen">🗑️</a>';
                } else {
                    $type = '[Datei]';
                    $extension = strtolower(pathinfo($item, PATHINFO_EXTENSION));
                    $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp', 'svg'];

                    if (in_array($extension, $imageExtensions)) {
                        $previewHtml = '<img src="' . htmlspecialchars($itemWebAccessPath) . '" alt="Vorschau für ' . htmlspecialchars($item) . '" class="image-preview">';
                    } else {
                        $previewHtml = '<span class="item-icon file-icon">📄</span>';
                    }
                    $downloadLink = '<a href="download_file.php?folder=' . urlencode($folderKey) . '&file=' . urlencode($item) . '" class="download-btn" title="Datei herunterladen">⬇️</a>';
                    // Lösch-Link für Dateien
                    $deleteLink = '<a href="delete_item.php?folder=' . urlencode($folderKey) . '&item=' . urlencode($item) . '&type=file" class="delete-btn" onclick="return confirmDelete(\'' . htmlspecialchars($item, ENT_QUOTES) . '\', false);" title="Datei löschen">🗑️</a>';
                }
                $folderContentHtml .= '<li>' . $previewHtml . '<span class="file-name">' . htmlspecialchars($item) . '</span> <span class="file-type">' . $type . '</span>' . $downloadLink . $deleteLink . '</li>';
            }
            $folderContentHtml .= '</ul>';
        } else {
            $folderContentHtml = '<p>Der Ordner "' . htmlspecialchars($folderDisplayName) . '" ist leer.</p>';
        }
    } else {
        $folderContentHtml = '<p>Fehler: Der Ordner "' . htmlspecialchars($folderDisplayName) . '" wurde nicht gefunden unter: ' . htmlspecialchars($currentDirectoryPath) . '</p>';
    }
} else if (!empty($folderKey)) {
    $folderContentHtml = '<p>Zugriff auf den Ordner "'.htmlspecialchars($folderKey).'" ist nicht erlaubt.</p>';
}

?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo htmlspecialchars($folderDisplayName); ?></title>
    <style>
        body { font-family: sans-serif; margin: 0; background-color: #f4f4f4; padding: 20px; }
        .container { background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); width: 90%; max-width: 800px; margin: 0 auto; }
        h1 { color: #333; margin-bottom: 20px; border-bottom: 1px solid #eee; padding-bottom: 15px;}
        a { color: #007bff; text-decoration: none; }
        /* a:hover { text-decoration: underline; } */ /* Oft nicht gewünscht bei Buttons */
        
        .nav-links { margin-bottom: 20px; display: flex; justify-content: space-between; align-items: center; }
        .nav-links .back-link { background-color: #6c757d; color: white !important; padding: 8px 15px; border-radius: 5px; text-decoration: none !important; }
        .nav-links .back-link:hover { background-color: #5a6268; }
        .nav-links .logout-link { color: #dc3545 !important; padding: 8px 15px; border: 1px solid #dc3545; border-radius: 5px; text-decoration: none !important;}
        .nav-links .logout-link:hover { background-color: #dc3545; color:white !important; }

        ul.file-list { list-style-type: none; padding-left: 0; }
        ul.file-list li { 
            padding: 10px 5px; 
            border-bottom: 1px solid #eee; 
            display: flex;
            align-items: center;
            gap: 10px;
        }
        ul.file-list li:last-child { border-bottom: none; }
        .file-name { flex-grow: 1; word-break: break-all; }
        .file-type { font-style: italic; color: #777; margin-left: 10px; white-space: nowrap; }
        .image-preview {
            width: 40px; height: 40px; object-fit: cover;
            border: 1px solid #ddd; border-radius: 3px; flex-shrink: 0;
        }
        .item-icon {
            font-size: 24px; width: 40px; height: 40px;
            display: flex; align-items: center; justify-content: center;
            color: #6c757d; flex-shrink: 0;
        }
        .download-btn, .delete-btn {
            margin-left: 5px;
            padding: 5px 8px;
            color: white !important;
            border-radius: 4px;
            text-decoration: none !important;
            font-size: 1em;
            line-height: 1;
            flex-shrink: 0; /* Verhindert, dass Buttons schrumpfen */
        }
        .download-btn { background-color: #28a745; }
        .download-btn:hover { background-color: #218838; }
        .delete-btn { background-color: #dc3545; }
        .delete-btn:hover { background-color: #c82333; }

        .message {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 4px;
            text-align: center;
        }
        .upload-form-container {
            background-color: #f9f9f9;
            padding: 15px;
            border: 1px solid #e0e0e0;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .upload-form-container h3 {
            margin-top: 0;
            color: #333;
        }
        .upload-form-container input[type="file"] {
            border: 1px solid #ccc;
            padding: 8px;
            border-radius: 4px;
            width: calc(100% - 18px); /* Berücksichtigt Padding */
            margin-bottom: 10px;
        }
        .upload-form-container input[type="submit"] {
            background-color: #007bff;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 1em;
        }
        .upload-form-container input[type="submit"]:hover {
            background-color: #0056b3;
        }
        .message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
    </style>
</head>
<body>
    <div class="container">
        <div class="nav-links">
            <a href="index.php" class="back-link">❮ Zurück zur Hauptseite</a>
            <a href="index.php?logout=true" class="logout-link">Logout</a>
        </div>
        <h1>Inhalt: <?php echo htmlspecialchars($folderDisplayName); ?></h1>

         <?php if ($message): ?>
            <div class="message <?php echo (strpos(strtolower($message), 'erfolgreich') !== false || strpos(strtolower($message), 'hochgeladen') !== false || strpos(strtolower($message), 'gelöscht') !== false) ? 'success' : 'error'; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <?php
        // Upload-Formular nur anzeigen, wenn der aktuelle Ordner 'layers' ist
        if ($folderKey === 'layers'):
        ?>
            <div class="upload-form-container">
                <h3>Bild in "<?php echo htmlspecialchars($allowedFolders['layers']); ?>" hochladen</h3>
                <form action="upload_file.php" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="target_folder" value="layers"> <!-- Wichtig für upload_file.php -->
                    <div>
                        <input type="file" name="uploaded_file" id="uploaded_file" required accept="image/jpeg,image/png,image/gif,image/webp">
                    </div>
                    <div>
                        <input type="submit" value="Datei hochladen" name="submit_upload">
                    </div>
                </form>
            </div>
        <?php endif; ?>
        
        <?php echo $folderContentHtml; // Die Dateiliste ?>

    </div>

    <script>
    function confirmDelete(itemName, isDirectory) {
        let type = isDirectory ? "Ordner" : "Datei";
        let message = "Sind Sie sicher, dass Sie " + type + " '" + itemName + "' wirklich löschen möchten?";
        if (isDirectory) {
            message += "\n\nACHTUNG: Alle Inhalte dieses Ordners werden ebenfalls unwiderruflich gelöscht!";
        }
        return confirm(message);
    }
    </script>
    <script>
  if ('serviceWorker' in navigator) {
    // Versuche, zuerst alle bestehenden SWs für den Admin-Pfad zu deregistrieren
    navigator.serviceWorker.getRegistrations().then(function(registrations) {
      for(let registration of registrations) {
        if (registration.scope.includes('/admin/')) { // Oder genauer Scope-Vergleich
          registration.unregister().then(function(boolean) {
            console.log(boolean ? 'Admin SW unregistriert' : 'Admin SW nicht unregistriert');
          });
        }
      }
      // Dann den No-Op SW registrieren
      navigator.serviceWorker.register('/admin/admin-noop-sw.js', { scope: '/admin/' })
        .then(registration => {
          console.log('Admin No-Op ServiceWorker registriert mit scope:', registration.scope);
        })
        .catch(error => {
          console.error('Admin No-Op ServiceWorker Registrierung fehlgeschlagen:', error);
        });
    });
  }
</script>
</body>
</html>