// js/dataLoader.js
import { showNotification } from './notifications.js'; // <<< IMPORT HINZUGEFÜGT
import { layerSelect } from './config.js'; // Importiere das DOM-Element

const offlineFallbackLayers = [
    { value: "layers/2023-Korporations-F-kleiner-Rat.png", text: "kleiner-Rat (Offline)" },
    { value: "layers/2023-Korporations-F-Elferrat.png", text: "Elferrat (Offline)" },
    { value: "layers/2023-Korporations-F-Senat.png", text: "Senat (Offline)" },
    { value: "layers/2023-Korporations-F-Garde.png", text: "Garde (Offline)" },
    { value: "layers/2025-Korporations-F-Jofelinen.png", text: "Jofelinen (Offline)" },
    { value: "layers/2023-Korporations-F-Kadetten.png", text: "Kadetten (Offline)" },
    { value: "layers/2023-Korporations-F-Tanzcorp.png", text: "Tanzcorp (Offline)" },

    // Stelle sicher, dass "layers/offline-default-layer1.png" in urlsToCache ist!
];

export async function fetchLayerOptionsFromServer() {
    try {
        const response = await fetch('php/list_layers.php');
        if (!response.ok) {
            let errorMsg = `Serverfehler beim Laden der Layer-Optionen: ${response.status}`;
            try {
                const errorData = await response.json();
                if (errorData && errorData.error) {
                    errorMsg += ` - ${errorData.error}`;
                }
            } catch (e) { /* ignore */ }
            throw new Error(errorMsg);
        }
        const layersData = await response.json();
        if (layersData.error) {
            throw new Error(`Fehler vom Server-Skript: ${layersData.error}`);
        }
        return layersData;
    } catch (error) {
        console.warn("Laden der Layer-Optionen vom Server fehlgeschlagen, verwende Offline-Fallback:", error.message);
        showNotification("Offline-Modus: Standard-Layer-Liste wird verwendet.", "info", 4000); // Funktioniert jetzt
        return offlineFallbackLayers;
    }
}

export function populateLayerSelectWithOptions(layersData) {
    if (!layerSelect) {
        console.error("layerSelect DOM-Element nicht gefunden.");
        return;
    }
    const currentMainSelectValue = layerSelect.value; // Alten Wert merken
    layerSelect.innerHTML = ''; // Haupt-Dropdown leeren

    if (!layersData || layersData.length === 0) {
        const msg = navigator.onLine ? 'Keine Layer vom Server erhalten.' : 'Offline: Keine Layer verfügbar.';
        layerSelect.innerHTML = `<option value="">${msg}</option>`;
    } else {
        layersData.forEach(layerData => {
            const option = document.createElement('option');
            option.value = layerData.value; // Dies ist der Bild-Pfad
            option.textContent = layerData.text;
            layerSelect.appendChild(option);
        });
        // Versuche, alten Wert wiederherzustellen
        if (Array.from(layerSelect.options).some(opt => opt.value === currentMainSelectValue)) {
            layerSelect.value = currentMainSelectValue;
        }
    }
    // --- NEU: Kamera-Overlay-Dropdown synchronisieren ---
    syncCameraOverlaySelect();
}
// NEUE Funktion zum Synchronisieren des Kamera-Overlay-Dropdowns
export function syncCameraOverlaySelect() {
    if (!cameraOverlaySelect || !layerSelect) return;

    const currentOverlaySelectValue = cameraOverlaySelect.value; // Alten Wert des Overlay-Selects merken

    cameraOverlaySelect.innerHTML = '<option value="-1">Kein Overlay</option>'; // Standardoption

    // Iteriere über die Optionen des Haupt-Layer-Dropdowns (#layerSelect)
    // und füge sie dem Kamera-Overlay-Dropdown hinzu.
    // Wichtig: Hier speichern wir den *Index* der Layer im globalen `layers`-Array
    // als `value` für das Overlay-Dropdown, da `handleOverlaySelection` diesen Index erwartet.
    // ABER: #layerSelect speichert den Bild-Pfad als value.
    // Wir müssen also die aktuell im Projekt *vorhandenen* Layer durchgehen.

    // Dies bedeutet, dass populateCameraOverlaySelect doch besser in main.js bleibt,
    // da es Zugriff auf das globale `layers`-Array von main.js benötigt.
    // dataLoader.js sollte nicht direkt auf den Anwendungsstatus von main.js zugreifen.

    // Alternativ: Wir übergeben das `layers`-Array an eine Funktion hier,
    // oder wir rufen eine Funktion in main.js auf, um das zu tun.

    // Für den Moment lassen wir die Synchronisation in main.js,
    // direkt nach dem Hinzufügen eines Layers oder dem Laden eines Projekts.
    // Die `populateLayerSelectWithOptions` hier befüllt nur #layerSelect.
}