// js/layer.js
export class Layer {
    constructor(image, x, y, label) {
        this.image = image;
        this.x = x;
        this.y = y;
        this.scale = 1;
        this.width = image.width;
        this.height = image.height;
        this.label = label;
        this.isVisible = true; // Neuer Standardwert: Layer ist sichtbar
    }

    getScaledSize() {
        return {
            width: this.width * this.scale,
            height: this.height * this.scale
        };
    }

    getCanvasBounds() {
        const scaledSize = this.getScaledSize();
        return {
            x: this.x,
            y: this.y,
            width: scaledSize.width,
            height: scaledSize.height,
            right: this.x + scaledSize.width,
            bottom: this.y + scaledSize.height
        };
    }

    contains(x, y) {
        const bounds = this.getCanvasBounds();
        return x >= bounds.x && x <= bounds.right && y >= bounds.y && y <= bounds.bottom;
    }

    getCenter() {
        const bounds = this.getCanvasBounds();
        return {
            x: bounds.x + bounds.width / 2,
            y: bounds.y + bounds.height / 2
        };
    }

    getCorners() {
        const bounds = this.getCanvasBounds();
        return {
            tl: { x: bounds.x, y: bounds.y },
            tr: { x: bounds.right, y: bounds.y },
            bl: { x: bounds.x, y: bounds.bottom },
            br: { x: bounds.right, y: bounds.bottom }
        };
    }
}