# Reminder App für Windows

Dieses kleine Tool zeigt dir Windows-Benachrichtigungen in frei definierbaren Intervallen an. Typische Anwendung: Du startest die App morgens (oder lässt sie automatisch im Autostart laufen) und wirst während des Tages daran erinnert, Zwischenberichte oder andere To-Dos zu erledigen.

## Voraussetzungen

- Windows 10 oder 11  
- Python 3.9 oder neuer (über `python --version` prüfen)

## Installation

1. Abhängigkeiten installieren:

   ```powershell
   cd <pfad-zum-projekt>
   python -m venv .venv
   .\.venv\Scripts\Activate.ps1
   pip install -r requirements.txt
   ```

2. Konfiguration in `config.json` anpassen. Beispiel:

   ```json
   {
     "reminders": [
       {
         "title": "Zwischenbericht",
         "message": "Bitte erstelle deinen Zwischenbericht für den WOW-Kunden.",
         "start_time": "08:30",
         "interval_minutes": 120,
         "occurrences_per_day": 4,
         "days": ["monday", "tuesday", "wednesday", "thursday", "friday"]
       }
     ]
   }
   ```

   - `title`: Überschrift der Benachrichtigung (optional).
   - `message`: Text der Benachrichtigung.
   - `start_time`: Erste Erinnerung des Tages (`HH:MM` im 24h-Format).
   - `interval_minutes`: Abstand zwischen Erinnerungen in Minuten.
   - `occurrences_per_day`: Wie oft die Erinnerung pro Tag erscheinen soll (optional, ansonsten läuft sie bis Mitternacht).
   - `days`: Optionale Liste aktiver Tage (`monday`, `dienstag`, …).

3. Reminder starten:

   ```powershell
   .\.venv\Scripts\Activate.ps1
   python reminder_app.py --config config.json
   ```

   Standardmäßig prüft das Skript alle 30 Sekunden, ob ein Reminder fällig ist oder ob sich die Konfigurationsdatei geändert hat. Mit `--verbose` erhältst du zusätzliche Log-Ausgaben.

## Autostart einrichten

### Variante 1: Windows-Startup-Ordner

1. Eine Verknüpfung zur PowerShell-Datei erstellen:

   ```powershell
   $script = "Start-Process powershell -ArgumentList '-NoProfile','-File','{FullPathToProject}\start_reminder.ps1'"
   ```

   (Für einen komfortablen Start legt das Skript `start_reminder.ps1` an, siehe unten.)

2. `Win + R` drücken, `shell:startup` eintippen und bestätigen.
3. Verknüpfung in den geöffneten Ordner ziehen. Beim nächsten Windows-Start läuft die App automatisch.

### Variante 2: Aufgabenplaner

1. Aufgabenplanung öffnen (`taskschd.msc`).
2. „Aufgabe erstellen…“ wählen und z. B. „Beim Anmelden“ als Trigger festlegen.
3. Aktion: `Programm/Script` → `powershell.exe`, Argumente:

   ```
   -NoProfile -ExecutionPolicy Bypass -File "<Pfad>\start_reminder.ps1"
   ```

4. Speichern – fertig.

## Hilfsskript für den Start

Optional kannst du folgende Datei `start_reminder.ps1` im Projektverzeichnis speichern. Sie aktiviert das virtuelle Environment und startet den Reminder:

```powershell
$base = Split-Path -Parent $MyInvocation.MyCommand.Path
$venv = Join-Path $base ".venv\Scripts\Activate.ps1"
if (Test-Path $venv) { & $venv }
python (Join-Path $base "reminder_app.py") --config (Join-Path $base "config.json")
```

Lege für dieses Skript eine Verknüpfung in den Autostart-Ordner oder nutze den Aufgabenplaner.

## Tipps

- Änderungen an `config.json` werden automatisch eingelesen – du musst das Skript nicht neu starten.
- Über `--check-interval 10` kannst du die Polling-Intervalle verkürzen.
- Falls keine Benachrichtigungen erscheinen, prüfe die Windows-Fokus-Unterstützung („Nicht stören“) und ob `python` aus dem Autostart-Kontext erreichbar ist.
