<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Controller;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Core\Utility\DebugUtility;
use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \WOWGmbH\Wownaechtebuch\Event\NewLetterRecordEvent;

/**
 * LetterRecordController
 */
class LetterRecordController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * letterRecordRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\LetterRecordRepository
     */
    protected $letterRecordRepository;
    
        /**
     * productRecordRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRecordRepository
     */
    protected $productRecordRepository;

    /**
     * letterTemplateRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\LetterTemplateRepository
     */
    protected $letterTemplateRepository;
    
    /**
     * treatmentRunRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository
     */
    protected $treatmentRunRepository;

    /** 
     * persistenceManager
     *
     * @var \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager
     */
    protected $persistenceManager;
    
    public function __construct()
    {
    }
    

        /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRecordRepository $productRecordRepository
     */
    public function injectProductRecordRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\ProductRecordRepository $productRecordRepository)
    {
        $this->productRecordRepository = $productRecordRepository;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager $persistenceManager
     */
    public function injectPersistenceManager(\TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager $persistenceManager)
    {
        $this->persistenceManager = $persistenceManager;
    }
    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository $treatmentRunRepository
     */
    public function injectTreatmentRunRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository $treatmentRunRepository)
    {
        $this->treatmentRunRepository = $treatmentRunRepository;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\LetterTemplateRepository $letterTemplateRepository
     */
    public function injectLetterTemplateRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\LetterTemplateRepository $letterTemplateRepository)
    {
        $this->letterTemplateRepository = $letterTemplateRepository;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\LetterRecordRepository $letterRecordRepository
     */
    public function injectLetterRecordRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\LetterRecordRepository $letterRecordRepository)
    {
        $this->letterRecordRepository = $letterRecordRepository;
    }

    /**
     * action index
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function indexAction(): \Psr\Http\Message\ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * action list
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function listAction(): \Psr\Http\Message\ResponseInterface
    {
        $letterRecords = $this->letterRecordRepository->findAll();
        $this->view->assign('letterRecords', $letterRecords);
        return $this->htmlResponse();
    }

    /**
     * action listForAdminByChild
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function listForAdminByChildAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child): \Psr\Http\Message\ResponseInterface
    {
        $latestTreatmentRun = $this->treatmentRunRepository->findLatestByChild($child);
        $letterRecords = $this->letterRecordRepository->findBy(['letter.treatmentRun' => $latestTreatmentRun]);
        $this->view->assign('letterRecords', $letterRecords);
        return $this->htmlResponse();
    }

    /**
     * action show
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $letterRecord
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function showAction(\WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $letterRecord): \Psr\Http\Message\ResponseInterface
    {
        $this->view->assign('letterRecord', $letterRecord);
        return $this->htmlResponse();
    }
    
    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function newAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Letter $letter): \Psr\Http\Message\ResponseInterface
    {
        $number = ($this->letterRecordRepository->count(['letter' => $letter]) ?? 0) + 1;
        
        $productRecord = $this->productRecordRepository->findOneBy(['child' => $letter->getTreatmentRun()->getChild()]);

        $letterTemplates = $this->letterTemplateRepository->findAll();
        $latestLetterRecord = $this->letterRecordRepository->findLatestByLetter($letter);

        $this->view->assign('letterTemplates', $letterTemplates);
        $this->view->assign('letter', $letter);
        $this->view->assign('latestLetterRecord', $latestLetterRecord);
        $this->view->assign('number', $number);
        $this->view->assign('productRecord', $productRecord);
        return $this->htmlResponse();
    }

    /**
     * action create
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Letter $newLetter
     */
    public function createAction(\WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $newLetterRecord): \Psr\Http\Message\ResponseInterface
    {
        $newLetterRecord->setText(strip_tags($newLetterRecord->getHtml()));
        
        $this->letterRecordRepository->add($newLetterRecord);
        $this->persistenceManager->persistAll();

        /** @var NewLetterRecordEvent $event */
        $event = $this->eventDispatcher->dispatch(
            new NewLetterRecordEvent($newLetterRecord),
        );

        return (new ForwardResponse('listForAdminByChild'))
            ->withControllerName('Letter')
            ->withArguments(['child' => $newLetterRecord->getLetter()->getTreatmentRun()->getChild()]);
    }

    /**
     * action edit
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $letterRecord
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("letterRecord")
     * @return \Psr\Http\Message\ResponseInterface
     */
    // public function editAction(\WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $letterRecord): \Psr\Http\Message\ResponseInterface
    // {
    //     $letterTemplates = $this->letterTemplateRepository->findAll();

    //     $this->view->assign('letterTemplates', $letterTemplates);
    //     $this->view->assign('letterRecord', $letterRecord);
    //     return $this->htmlResponse();
    // }

    // /**
    //  * action update
    //  *
    //  * @param \WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $letterRecord
    //  */
    // public function updateAction(\WOWGmbH\Wownaechtebuch\Domain\Model\LetterRecord $letterRecord): \Psr\Http\Message\ResponseInterface
    // {
    //     $this->addFlashMessage('The object was updated. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/p/friendsoftypo3/extension-builder/master/en-us/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
    //     $this->letterRecordRepository->update($letterRecord);
    //     $this->persistenceManager->persistAll();
    //     return $this->redirect('list');
    // }
}
