<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Controller;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Core\Utility\DebugUtility;

/**
 * SurveyController
 */
class SurveyController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * surveyRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\SurveyRepository
     */
    protected $surveyRepository;

    /**
     * treatmentRunRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository
     */
    protected $treatmentRunRepository;

    /**
     * surveyRecordRepository
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Repository\SurveyRecordRepository
     */
    protected $surveyRecordRepository;
    
    public function __construct()
    {
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository $treatmentRunRepository
     */
    public function injectTreatmentRunRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\TreatmentRunRepository $treatmentRunRepository)
    {
        $this->treatmentRunRepository = $treatmentRunRepository;
    }


    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\SurveyRepository $surveyRepository
     */
    public function injectSurveyRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\SurveyRepository $surveyRepository)
    {
        $this->surveyRepository = $surveyRepository;
    }

    /**
     * @param \WOWGmbH\Wownaechtebuch\Domain\Repository\SurveyRecordRepository $surveyRecordRepository
     */
    public function injectSurveyRecordRepository(\WOWGmbH\Wownaechtebuch\Domain\Repository\SurveyRecordRepository $surveyRecordRepository)
    {
        $this->surveyRecordRepository = $surveyRecordRepository;
    }


    /**
     * action index
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function indexAction(): \Psr\Http\Message\ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * action list
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function listAction(): \Psr\Http\Message\ResponseInterface
    {
        $surveys = $this->surveyRepository->findAll();
        $this->view->assign('surveys', $surveys);
        return $this->htmlResponse();
    }
    
    /**
     * action listRequired
     * should only be called from a plugin with settings.required-surveys set
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function listRequiredAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Child $child): \Psr\Http\Message\ResponseInterface
    {
        $treatmentRun = $this->treatmentRunRepository->findLatestByChild($child);
        $surveys = $this->surveyRepository->findByUids(explode(',',$this->settings['required-surveys']))->toArray();

        $filledSurveys = $treatmentRun->getSurveyRecords()->toArray();

        // TODO Should just include surveys with a specific State (but I did not implement States yet)
        $filledSurveys = array_unique(array_map(fn($n) => $n->getSurveyName() ,$filledSurveys));

        foreach ($surveys as $key => $survey) {
            if (in_array($survey->getName(), $filledSurveys)) {
                unset($surveys[$key]);
            }
        }
        
        $registrationSurvey = $this->surveyRepository->findByUid($this->settings['registration-survey']);
        
        
        $this->view->assign('registrationSurvey', $registrationSurvey);
        $this->view->assign('surveys', $surveys);
        $this->view->assign('child', $child);
        return $this->htmlResponse();
    }

    /**
     * action show
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function showAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey): \Psr\Http\Message\ResponseInterface
    {
        $this->view->assign('survey', $survey);
        return $this->htmlResponse();
    }

    /**
     * action new
     *
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function newAction(): \Psr\Http\Message\ResponseInterface
    {
        return $this->htmlResponse();
    }

    /**
     * action create
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $newSurvey
     */
    public function createAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Survey $newSurvey): \Psr\Http\Message\ResponseInterface
    {
        $this->surveyRepository->add($newSurvey);
        return $this->redirect('list');
    }

    /**
     * action edit
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("survey")
     * @return \Psr\Http\Message\ResponseInterface
     */
    public function editAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey): \Psr\Http\Message\ResponseInterface
    {
        $this->view->assign('survey', $survey);
        return $this->htmlResponse();
    }

    /**
     * action update
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey
     */
    public function updateAction(\WOWGmbH\Wownaechtebuch\Domain\Model\Survey $survey): \Psr\Http\Message\ResponseInterface
    {
        $this->surveyRepository->update($survey);
        return $this->redirect('list');
    }
}
