<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

/**
 * AnswerType
 */
class AnswerType extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * html
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $html;

    /**
     * validator
     *
     * @var int
     */
    protected $validator;

    /**
     * isSensetive
     *
     * @var bool
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $isSensetive;

    /**
     * Returns the html
     *
     * @return string
     */
    public function getHtml()
    {
        return $this->html;
    }

    /**
     * Sets the html
     *
     * @param string $html
     * @return void
     */
    public function setHtml(string $html)
    {
        $this->html = $html;
    }

    /**
     * Returns the validator
     *
     * @return int
     */
    public function getValidator()
    {
        return $this->validator;
    }

    /**
     * Sets the validator
     *
     * @param int $validator
     * @return void
     */
    public function setValidator(int $validator)
    {
        $this->validator = $validator;
    }

    /**
     * Returns the isSensetive
     *
     * @return bool
     */
    public function getIsSensetive()
    {
        return $this->isSensetive;
    }

    /**
     * Sets the isSensetive
     *
     * @param bool $isSensetive
     * @return void
     */
    public function setIsSensetive(bool $isSensetive)
    {
        $this->isSensetive = $isSensetive;
    }

    /**
     * Returns the boolean state of isSensetive
     *
     * @return bool
     */
    public function isIsSensetive()
    {
        return $this->isSensetive;
    }
}
