<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * Letter
 */
class Letter extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    // The naming is from the old version for t3 10
    // You are free to change
    public const STATUS_ENTWURF = 0;
    public const STATUS_FREIGABE = 1;
    public const STATUS_VERSENDET = 2;
    public const STATUS_ARCHIVIERT = 3;

    /**
     * dateofarchive
     *
     * @var \DateTime
     */
    protected $dateofarchive;

    /**
     * @var \DateTime
     */
    protected $crdate;

    /**
     * state
     *
     * @var int
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $state;

    /**
     * treatmentRun
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun
     * 
     */
    
    protected $treatmentRun;

    /**
     * sent
     *
     * @var bool
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $sent = false;

    /**
     * Returns the dateofarchive
     *
     * @return \DateTime
     */
    public function getDateOfArchive()
    {
        return $this->dateofarchive;
    }

    /**
     * Sets the dateofarchive
     *
     * @param \DateTime $dateofarchive
     * @return void
     */
    public function setDateOfArchive(\DateTime $dateofarchive)
    {
        $this->dateofarchive = $dateofarchive;
    }

    /**
     * Get crdate
     *
     * @return \DateTime|null
     */
    public function getCrdate(): ?\DateTime
    {
        return $this->crdate;
    }

    /**
     * Set crdate
     *
     * @param \DateTime $crdate crdate
     */
    public function setCrdate($crdate): void
    {
        $this->crdate = $crdate;
    }

    /**
     * Returns the state
     *
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the state
     *
     * @param int $state
     * @return void
     */
    public function setState(int $state)
    {
        $this->state = $state;
    }

    /**
     * Returns the treatmentRun
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun
     */
    public function getTreatmentRun()
    {
        return $this->treatmentRun;
    }

    /**
     * Sets the treatmentRun
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun
     * @return void
     */
    public function setTreatmentRun(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun)
    {
        $this->treatmentRun = $treatmentRun;
    }    
    
    /**
     * 
     * @param bool
     * @return void
     */
    public function setSent(bool $sent){
        $this->sent = $sent;
    }

    /**
     * 
     * @return bool
     */
    public function isSent(){
        return $this->sent;
    }
}
