<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;

/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use TYPO3\CMS\Extbase\Annotation\ORM\Lazy;

/**
 * LetterRecord
 */
class LetterRecord extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * number
     *
     * @var int
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $number;

    /**
     * @var \DateTime
     */
    protected $crdate;

    /**
     * identifier
     *
     * @var string
     */
    protected $identifier;

    /**
     * toAddress
     *
     * @var string
     */
    protected string $toAddress;

    /**
     * toAddress
     *
     * @var string
     */
    protected string $subject;

    /**
     * text
     *
     * @var string
     */
    protected $text;


    /**
     * html
     *
     * @var string
     */
    protected $html;

    /**
     * pdf
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $pdf;

    /**
     * letterTemplateName
     *
     * @var string
     */
    protected $letterTemplateName;

    /**
     * letter
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\Letter
     */
    protected $letter;

    /**
     * letterTemplate
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\LetterTemplate
     */
    protected $letterTemplate;

    /**
     * Returns the number
     *
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * Sets the number
     *
     * @param int $number
     * @return void
     */
    public function setNumber(int $number)
    {
        $this->number = $number;
    }

    /**
     * Get crdate
     *
     * @return \DateTime|null
     */
    public function getCrdate(): ?\DateTime
    {
        return $this->crdate;
    }

    /**
     * Set crdate
     *
     * @param \DateTime $crdate crdate
     */
    public function setCrdate($crdate): void
    {
        $this->crdate = $crdate;
    }

    /**
     * Returns the text
     *
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * Sets the text
     *
     * @param string $text
     * @return void
     */
    public function setText(string $text)
    {
        $this->text = $text;
    }

    /**
     * Returns the toAddress
     *
     * @return string
     */
    public function getToAddress()
    {
        return $this->toAddress;
    }

    /**
     * Sets the toAddress
     *
     * @param string $toAddress
     * @return void
     */
    public function setToAddress(string $toAddress)
    {
        $this->toAddress = $toAddress;
    }

    /**
     * Returns the subject
     *
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * Sets the subject
     *
     * @param string $subject
     * @return void
     */
    public function setSubject(string $subject)
    {
        $this->subject = $subject;
    }

    /**
     * Returns the identifier
     *
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * Sets the identifier
     *
     * @param string $identifier
     * @return void
     */
    public function setIdentifier(string $identifier)
    {
        $this->identifier = $identifier;
    }

    /**
     * Returns the html
     *
     * @return string
     */
    public function getHtml()
    {
        return $this->html;
    }

    /**
     * Sets the html
     *
     * @param string $html
     * @return void
     */
    public function setHtml(string $html)
    {
        $this->html = $html;
    }

    /**
     * Returns the pdf
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Sets the pdf
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $pdf
     * @return void
     */
    public function setPdf(\TYPO3\CMS\Extbase\Domain\Model\FileReference $pdf)
    {
        $this->pdf = $pdf;
    }

    /**
     * Returns the letterTemplateName
     *
     * @return string
     */
    public function getLetterTemplateName()
    {
        return $this->letterTemplateName;
    }

    /**
     * Sets the letterTemplateName
     *
     * @param string $letterTemplateName
     * @return void
     */
    public function setLetterTemplateName(string $letterTemplateName)
    {
        $this->letterTemplateName = $letterTemplateName;
    }

    /**
     * Returns the letter
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\Letter
     */
    public function getLetter()
    {
        return $this->letter;
    }

    /**
     * Sets the letter
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\Letter $letter
     * @return void
     */
    public function setLetter(\WOWGmbH\Wownaechtebuch\Domain\Model\Letter $letter)
    {
        $this->letter = $letter;
    }

    /**
     * Returns the letterTemplat
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\LetterTemplate
     */
    public function getLetterTemplate()
    {
        return $this->letterTemplate;
    }

    /**
     * Sets the letterTemplate
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\LetterTemplate $letterTemplate
     * @return void
     */
    public function setLetterTemplate(\WOWGmbH\Wownaechtebuch\Domain\Model\LetterTemplate $letterTemplate)
    {
        $this->letterTemplate = $letterTemplate;
    }
}
