<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

/**
 * Product
 */
class Product extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * name
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $name;

    /**
     * description
     *
     * @var string
     */
    protected $description;

    /**
     * RegEx to check serial number against
     *
     * @var string
     */
    protected $serialNumberSchema;

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     * @return void
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     * @return void
     */
    public function setDescription(string $description)
    {
        $this->description = $description;
    }

    /**
     * Returns the serialNumberSchema
     *
     * @return string
     */
    public function getSerialNumberSchema()
    {
        return $this->serialNumberSchema;
    }

    /**
     * Sets the serialNumberSchema
     *
     * @param string $serialNumberSchema
     * @return void
     */
    public function setSerialNumberSchema(string $serialNumberSchema)
    {
        $this->serialNumberSchema = $serialNumberSchema;
    }
}
