<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;

use TYPO3\CMS\Core\Utility\DebugUtility;

/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

/**
 * QuestionRecord
 */
class QuestionRecord extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * questionText
     *
     * @var string
     */
    protected $questionText;

    /**
     * questionAnswere
     *
     * @var string
     */
    protected $questionAnswere;

    /**
     * questionOptions
     *
     * @var string
     */
    protected $questionOptions;

    /**
     * questionOptionsArray
     *
     * @var array
     * @TYPO3\CMS\Extbase\Annotation\ORM\Transient
     */
    protected $questionOptionsArray;

    /**
     * isSensetive
     *
     * @var bool
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $isSensetive;

    /**
     * surveyRecord
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord
     */
    protected $surveyRecord;

    /**
     * answerType
     *
     * @var \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType
     */
    protected $answerType;
    
    /**
     * questionPage
     *
     * @var int
     */
    protected $questionPage;

    public function __construct()
    {
        $this->initializeObject();
    }

    public function initializeObject(): void
    {
    }

    /**
     * Returns the questionText
     *
     * @return string
     */
    public function getQuestionText()
    {
        return $this->questionText;
    }

    /**
     * Sets the questionText
     *
     * @param string $questionText
     * @return void
     */
    public function setQuestionText(string $questionText)
    {
        $this->questionText = $questionText;
    }

    /**
     * Returns the questionText
     *
     * @return int
     */
    public function getQuestionPage()
    {
        return $this->questionPage;
    }

    /**
     * Sets the questionText
     *
     * @param int $questionText
     * @return void
     */
    public function setQuestionPage(int $questionPage)
    {
        $this->questionPage = $questionPage;
    }

    /**
     * Returns the questionAnswere
     *
     * @return string
     */
    public function getQuestionAnswere()
    {
        return $this->questionAnswere;
    }

    /**
     * Sets the questionAnswere
     *
     * @param string $questionAnswere
     * @return void
     */
    public function setQuestionAnswere(string $questionAnswere)
    {
        $this->questionAnswere = $questionAnswere;
    }

    /**
     * Returns the questionOptions
     *
     * @return string
     */
    public function getQuestionOptions()
    {
        return $this->questionOptions;
    }

    /**
     * Returns the questionOptions
     *
     * @return array
     */
    public function getQuestionOptionsArray() : array
    {
        if ($this->questionOptions) {
            $stage1 = (str_replace("\\", "", $this->questionOptions));
            $stage2 = ($this->removeFirstAndLastIfQuoted($stage1));
            return json_decode($stage2, true) ?? [];
        }
        else {
            return [];
        }
    }

    /**
     * Sets the questionOptions
     *
     * @param string $questionOptions
     * @return void
     */
    public function setQuestionOptions(string $questionOptions)
    {
        $this->questionOptions = $questionOptions;
    }

    /**
     * Returns the isSensetive
     *
     * @return bool
     */
    public function getIsSensetive()
    {
        return $this->isSensetive;
    }

    /**
     * Sets the isSensetive
     *
     * @param bool $isSensetive
     * @return void
     */
    public function setIsSensetive(bool $isSensetive)
    {
        $this->isSensetive = $isSensetive;
    }

    /**
     * Returns the boolean state of isSensetive
     *
     * @return bool
     */
    public function isIsSensetive()
    {
        return $this->isSensetive;
    }

    /**
     * Returns the surveyRecord
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord
     */
    public function getSurveyRecord()
    {
        return $this->surveyRecord;
    }

    /**
     * Sets the surveyRecord
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord $surveyRecord
     * @return void
     */
    public function setSurveyRecord(\WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord $surveyRecord)
    {
        $this->surveyRecord = $surveyRecord;
    }

    /**
     * Returns the answerType
     *
     * @return \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType
     */
    public function getAnswerType()
    {
        return $this->answerType;
    }

    /**
     * Sets the answerType
     *
     * @param \WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType
     * @return void
     */
    public function setAnswerType(\WOWGmbH\Wownaechtebuch\Domain\Model\AnswerType $answerType)
    {
        $this->answerType = $answerType;
    }

    function removeFirstAndLastIfQuoted($str) {
        // Check if the string starts and ends with single or double quotation marks
        if ((substr($str, 0, 1) === '"' && substr($str, -1) === '"') || (substr($str, 0, 1) === "'" && substr($str, -1) === "'")) {
            // Remove the first and last character
            return substr($str, 1, -1);
        }
        // Return the original string if it is not quoted
        return $str;
    }
}
