<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Model;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use \TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * Survey
 */
class Survey extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * question
     * 
     * @var ?ObjectStorage<Question>
     */
    protected ?ObjectStorage $questions = null;


    /**
     * name
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $name;

    /**
     * description
     *
     * @var string
     */
    protected $description;

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     * @return void
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     * @return void
     */
    public function setDescription(string $description)
    {
        $this->description = $description;
    }

            /**
     * Adds a question to this survey
     */
    public function addQuestion(Question $question): void
    {
        $this->questions?->attach($question);
    }

    /**
     * Remove a question from this survey
     */
    public function removeQuestion(Question $questionToRemove): void
    {
        $this->questions?->detach($questionToRemove);
    }

    /**
     * Returns all questions in this survey
     *
     * @return ObjectStorage<Question>
     */
    public function getQuestions(): ObjectStorage
    {
        return $this->questions;
    }

    /**
     * @param ObjectStorage<Question> $questions
     */
    public function setQuestions(ObjectStorage $questions): void
    {
        $this->questions = $questions;
    }
}
