<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Repository;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */

/**
 * The repository for Letters
 */
class LetterRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
  public function findAllUnarchived()
  {
    $query = $this->createQuery();
    $query->matching(
      $query->logicalNot(
        $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Letter::STATUS_ARCHIVIERT)
      ),
    );

    return $query->execute();
  }

  public function findArchived()
  {
    $query = $this->createQuery();
    $query->matching(
      $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Letter::STATUS_ARCHIVIERT)
    );

    return $query->execute();
  }

  public function findUnarchivedByTreatmentRun(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun)
  {
    $query = $this->createQuery();
    $query->matching(
      $query->logicalAnd(
        $query->logicalNot(
          $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Letter::STATUS_ARCHIVIERT)
        ),
        $query->equals('treatmentRun', $treatmentRun->getUid())
      )
    );

    return $query->execute();
  }

  public function findArchivedByTreatmentRun(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun)
  {
    $query = $this->createQuery();
    $query->matching(
      $query->logicalAnd(
        $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Letter::STATUS_ARCHIVIERT),
        $query->equals('treatmentRun', $treatmentRun->getUid())
      )
    );

    return $query->execute();
  }

  public function findUnarchivedAndSentByTreatmentRun(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun)
  {
    $query = $this->createQuery();
    $query->matching(
      $query->logicalAnd(
        $query->logicalNot(
          $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Letter::STATUS_ARCHIVIERT)
        ),
        $query->equals('sent', 1),
        $query->equals('treatmentRun', $treatmentRun->getUid())
      )
    );

    return $query->execute();
  }

  public function findArchivedAndSentByTreatmentRun(\WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun $treatmentRun)
  {
    $query = $this->createQuery();
    $query->matching(
      $query->logicalAnd(
        $query->equals('state', \WOWGmbH\Wownaechtebuch\Domain\Model\Letter::STATUS_ARCHIVIERT),
        $query->equals('sent', 1),
        $query->equals('treatmentRun', $treatmentRun->getUid())
      )
    );

    return $query->execute();
  }
}
