<?php

declare(strict_types=1);

namespace WOWGmbH\Wownaechtebuch\Domain\Repository;


/**
 * This file is part of the "WOW Naechtebuch" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2024 WOW-GmbH <technik@wow.gmbh>, WOW-GmbH
 */
use WOWGmbH\Wownaechtebuch\Domain\Model\Child;
use WOWGmbH\Wownaechtebuch\Domain\Model\TreatmentRun;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use WOWGmbH\Wownaechtebuch\Domain\Model\SurveyRecord;

/**
 * The repository for SurveyRecords
 */
class SurveyRecordRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
  public function getLatestWeek(TreatmentRun $treatmentRun) : int
  {
    $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_wownaechtebuch_domain_model_surveyrecord');

    $result = $queryBuilder
      ->select('treatment_run', 'state')
      ->addSelectLiteral(
        $queryBuilder->expr()->max('week', 'max')
      )
      ->from('tx_wownaechtebuch_domain_model_surveyrecord')
      ->where(
        $queryBuilder->expr()->eq('treatment_run', $queryBuilder->createNamedParameter($treatmentRun->getUid(), Connection::PARAM_INT)),
        $queryBuilder->expr()->eq('state', SurveyRecord::STATE_SENT)
      );
      
      $result = $queryBuilder->executeQuery();
      return (int) $result->fetchAllAssociative()[0]['max'];
  }
}
